/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.entity.behaviour.Disguise;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.projectile.ProjectileImpactListener;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_2487;
import net.minecraft.class_7225;

public abstract class AbstractDisguiseSpell
extends AbstractSpell
implements Disguise,
ProjectileImpactListener {
    private final EntityAppearance disguise;

    public AbstractDisguiseSpell(CustomisedSpellType<?> type) {
        super(type);
        this.disguise = this.dataTracker.startTracking(new EntityAppearance());
    }

    @Override
    protected void onDestroyed(Caster<?> caster) {
        super.onDestroyed(caster);
        caster.asEntity().method_18382();
        caster.asEntity().method_5648(false);
        if (caster instanceof Pony) {
            Pony pony = (Pony)caster;
            pony.setInvisible(false);
        }
        this.disguise.remove();
    }

    @Override
    public EntityAppearance getDisguise() {
        return this.disguise;
    }

    @Override
    public boolean onProjectileImpact(class_1676 projectile) {
        return this.disguise.getAppearance() == projectile;
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        return situation == Situation.BODY && this.update(source, true);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        this.disguise.toNBT(compound, lookup);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.disguise.fromNBT(compound, lookup);
    }

    @Override
    public Optional<EntityAppearance> getAppearance() {
        return Optional.ofNullable(this.disguise);
    }

    public static class_1297 getAppearance(class_1297 e) {
        return e instanceof class_1657 ? Pony.of((class_1657)e).getSpellSlot().get(SpellPredicate.IS_DISGUISE).map(AbstractDisguiseSpell::getDisguise).map(EntityAppearance::getAppearance).orElse(e) : e;
    }
}

