/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.IllusionarySpell;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDisguiseSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.MagicParticleEffect;
import com.minelittlepony.unicopia.particle.UParticles;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_7225;

public class DispersableDisguiseSpell
extends AbstractDisguiseSpell
implements IllusionarySpell {
    private final DataTracker.Entry<Boolean> suppressed;
    private int suppressionCounter;
    private boolean forced;

    public DispersableDisguiseSpell(CustomisedSpellType<?> type) {
        super(type);
        this.suppressed = this.dataTracker.startTracking(TrackableDataType.BOOLEAN, false);
        this.setHidden(true);
    }

    public void setForced() {
        this.forced = true;
        this.setHidden(false);
    }

    @Override
    public boolean isVulnerable(Caster<?> otherSource, Spell other) {
        return this.suppressionCounter <= otherSource.getLevel().get();
    }

    @Override
    public void onSuppressed(Caster<?> otherSource, float time) {
        this.suppressionCounter = (int)(time /= this.getTraits().getOrDefault(Trait.STRENGTH, 1.0f));
        this.suppressed.set(true);
    }

    @Override
    public boolean isSuppressed() {
        return this.suppressionCounter > 0;
    }

    @Override
    public boolean update(Caster<?> source, boolean tick) {
        if (source.isClient()) {
            if (this.isSuppressed()) {
                source.spawnParticles(MagicParticleEffect.UNICORN, 5);
                source.spawnParticles((class_2394)UParticles.CHANGELING_MAGIC, 5);
            } else if (source.asWorld().field_9229.method_43048(30) == 0) {
                source.spawnParticles((class_2394)UParticles.CHANGELING_MAGIC, 2);
            }
        }
        if (!this.forced && !source.canUse(Abilities.DISGUISE)) {
            this.setDead();
        }
        Object owner = source.asEntity();
        class_1297 appearance = this.getDisguise().getAppearance();
        if (this.isSuppressed()) {
            if (--this.suppressionCounter <= 0) {
                this.suppressed.set(false);
            }
            owner.method_5648(false);
            if (source instanceof Pony) {
                ((Pony)source).setInvisible(false);
            }
            if (appearance != null) {
                appearance.method_5648(true);
                appearance.method_23327(appearance.method_23317(), -2.147483648E9, appearance.method_23318());
            }
            return true;
        }
        return super.update(source, tick);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10569("suppressionCounter", this.suppressionCounter);
        compound.method_10556("forced", this.forced);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.suppressionCounter = compound.method_10550("suppressionCounter");
        this.forced = compound.method_10577("forced");
        if (this.suppressionCounter > 0) {
            this.suppressed.set(true);
        }
    }

    @Override
    public Optional<EntityAppearance> getAppearance() {
        return this.isSuppressed() ? Optional.empty() : super.getAppearance();
    }
}

