/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.OrientedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.mob.CastSpellEntity;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlacementControlSpell
extends AbstractSpell
implements OrientedSpell {
    private final DataTracker.Entry<Optional<UUID>> placedEntityId;
    private final DataTracker.Entry<Optional<class_5321<class_1937>>> dimension;
    private final DataTracker.Entry<Optional<class_243>> position;
    private final DataTracker.Entry<Optional<class_243>> orientation;
    @Nullable
    private Spell delegate;

    public PlacementControlSpell(CustomisedSpellType<?> type) {
        super(type);
        this.placedEntityId = this.dataTracker.startTracking(TrackableDataType.UUID, Optional.empty());
        this.dimension = this.dataTracker.startTracking(TrackableDataType.ofRegistryKey(), Optional.empty());
        this.position = this.dataTracker.startTracking(TrackableDataType.OPTIONAL_VECTOR, Optional.empty());
        this.orientation = this.dataTracker.startTracking(TrackableDataType.OPTIONAL_VECTOR, Optional.empty());
    }

    PlacementControlSpell(Spell delegate) {
        this(SpellType.PLACE_CONTROL_SPELL.withTraits(delegate.getTypeAndTraits().traits()));
        this.delegate = delegate;
    }

    @Nullable
    public Spell getDelegate() {
        return this.delegate;
    }

    public Optional<class_243> getPosition() {
        return this.position.get();
    }

    public void setDimension(class_5321<class_1937> dimension) {
        this.dimension.set(Optional.of(dimension));
    }

    public void setPosition(class_243 position) {
        this.position.set(Optional.of(position));
    }

    @Override
    public void setOrientation(Caster<?> caster, float pitch, float yaw) {
        Ether.Entry<?> entry;
        this.orientation.set(Optional.of(new class_243((double)pitch, (double)yaw, 0.0)));
        Spell spell = this.delegate;
        if (spell instanceof OrientedSpell) {
            OrientedSpell o = (OrientedSpell)spell;
            o.setOrientation(caster, pitch, yaw);
        }
        if (!caster.isClient() && (entry = this.getConnection(caster)) != null) {
            entry.setPitch(pitch);
            entry.setYaw(yaw);
        }
    }

    @Override
    public boolean apply(Caster<?> caster) {
        return this.delegate != null && super.apply(caster);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (!source.isClient()) {
            if (this.placedEntityId.get().isEmpty()) {
                if (this.dimension.get().isEmpty()) {
                    this.setDimension((class_5321<class_1937>)source.asWorld().method_27983());
                }
                if (this.getPosition().isEmpty()) {
                    this.setPosition(source.asEntity().method_19538());
                }
                CastSpellEntity entity = new CastSpellEntity(source.asWorld(), source, this);
                class_243 pos = this.getPosition().get();
                class_243 rot = this.orientation.get().orElse(class_243.field_1353);
                entity.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, (float)rot.field_1351, (float)rot.field_1352);
                entity.method_37908().method_8649((class_1297)entity);
                this.placedEntityId.set(Optional.of(entity.method_5667()));
            } else if (this.getConnection(source) == null) {
                this.setDead();
            }
        }
        return !this.isDead();
    }

    @Nullable
    private Ether.Entry<?> getConnection(Caster<?> source) {
        return this.delegate == null || this.placedEntityId.get().isEmpty() ? null : (Ether.Entry)this.getWorld(source).map(world -> Ether.get(world).get(this.getDelegate().getTypeAndTraits().type(), this.placedEntityId.get().get(), this.delegate.getUuid())).orElse(null);
    }

    private Optional<class_1937> getWorld(Caster<?> source) {
        return this.dimension.get().map(arg_0 -> ((MinecraftServer)source.asWorld().method_8503()).method_3847(arg_0));
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10566("spell", (class_2520)Spell.writeNbt(this.delegate, lookup));
        this.position.get().ifPresent(pos -> compound.method_10566("position", (class_2520)NbtSerialisable.writeVector(pos)));
        this.orientation.get().ifPresent(o -> compound.method_10566("orientation", (class_2520)NbtSerialisable.writeVector(o)));
        this.dimension.get().ifPresent(d -> compound.method_10582("dimension", d.method_29177().toString()));
        this.placedEntityId.get().ifPresent(i -> compound.method_25927("placedEntityId", i));
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.delegate = Spell.readNbt(compound.method_10562("spell"), lookup);
        this.placedEntityId.set(compound.method_25928("placedEntityId") ? Optional.of(compound.method_25926("placedEntityId")) : Optional.empty());
        this.position.set(compound.method_10545("position") ? Optional.of(NbtSerialisable.readVector(compound.method_10554("position", 6))) : Optional.empty());
        this.orientation.set(compound.method_10545("orientation") ? Optional.of(NbtSerialisable.readVector(compound.method_10554("orientation", 6))) : Optional.empty());
        this.dimension.set(compound.method_10573("dimension", 8) ? Optional.ofNullable(class_2960.method_12829((String)compound.method_10558("dimension"))).map(id -> class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id)) : Optional.empty());
    }

    public static interface PlacementDelegate {
        public void onPlaced(Caster<?> var1, PlacementControlSpell var2);
    }
}

