/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.client.render.PlayerPoser;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8111;

public class RageAbilitySpell
extends AbstractSpell {
    private int age;
    private int ticksExtenguishing;
    private int ticksToExtenguish;

    public RageAbilitySpell(CustomisedSpellType<?> type) {
        super(type);
        this.setHidden(true);
    }

    public void setExtenguishing() {
        this.ticksToExtenguish += 15;
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        Pony pony;
        if (situation != Situation.BODY || source.asEntity().method_31481() || !source.canUse(Abilities.RAGE)) {
            return false;
        }
        if (source.asEntity().method_5816() || source.asEntity().method_32314() || this.ticksToExtenguish > 0) {
            ++this.ticksExtenguishing;
            source.playSound(USounds.Vanilla.field_15222, 1.0f);
            source.spawnParticles((class_2394)class_2398.field_11204, 12);
        } else {
            this.ticksExtenguishing = 0;
        }
        if (this.ticksToExtenguish > 0) {
            --this.ticksToExtenguish;
        }
        if (this.ticksExtenguishing > 10) {
            return false;
        }
        class_2338 pos = source.getOrigin();
        if (!source.isClient()) {
            class_1309 adversary;
            if (this.age == 0) {
                source.asWorld().method_46407(source.asEntity(), source.asWorld().method_48963().method_48796(class_8111.field_42325, source.asEntity()), new class_5362(this){

                    public boolean method_29554(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float power) {
                        return false;
                    }
                }, source.getOriginVector(), 3.0f, true, class_1937.class_7867.field_40890);
                if (source instanceof Pony) {
                    pony = (Pony)source;
                    pony.setAnimation(PlayerPoser.Animation.ARMS_UP, PlayerPoser.Animation.Recipient.ANYONE, 12);
                }
                source.playSound(USounds.ENTITY_PLAYER_KIRIN_RAGE, 2.0f, 0.1f);
                source.asEntity().method_32876((class_6880)class_5712.field_28178);
            }
            if (source.asEntity().method_24828() && source.asWorld().method_22347(pos) && this.age % 10 == 0) {
                source.asWorld().method_8501(pos, class_2246.field_10036.method_9564());
            }
            if (source instanceof Pony && ((class_1657)(pony = (Pony)source).asEntity()).method_7261(0.0f) == 0.0f && (adversary = ((class_1657)pony.asEntity()).method_6124()) != null) {
                adversary.method_5639(10.0f);
            }
        } else if (this.age % 5 == 0) {
            source.spawnParticles((class_2394)class_2398.field_11239, 4);
            if (source instanceof Pony) {
                pony = (Pony)source;
                if (!((class_1657)pony.asEntity()).field_6252) {
                    source.subtractEnergyCost(Math.min(12.0, 3.0 + source.asEntity().method_18798().method_1033() * 0.1));
                }
            }
        }
        if (source instanceof Pony) {
            pony = (Pony)source;
            if (pony.isClientPlayer() && (this.age == 0 || ((class_1657)pony.asEntity()).method_7261(0.0f) == 0.0f)) {
                InteractionManager.getInstance().playLoopingSound((class_1297)source.asEntity(), 7, source.asWorld().field_9229.method_43055());
            }
            MagicReserves.Bar energyBar = pony.getMagicalReserves().getEnergy();
            float energy = Math.min(1.01f, 0.5f + (float)this.age / 1000.0f);
            float newEnergy = energyBar.get() + energy;
            energyBar.set(Math.min(1.9f + class_3532.method_15374((float)((float)this.age / 3.0f)) * 1.7f, newEnergy));
            float charge = pony.getMagicalReserves().getCharge().get();
            float cost = 1.0f + (float)this.age / 1000.0f;
            if (charge > cost) {
                pony.getMagicalReserves().getCharge().add(-cost);
            } else {
                pony.getMagicalReserves().getMana().add(-cost);
            }
            if (pony.getMagicalReserves().getMana().get() <= 0.0f) {
                return false;
            }
        }
        if (source.asWorld().method_8520(pos.method_10084()) && source.asWorld().field_9229.method_43048(15) == 0) {
            source.playSound(USounds.Vanilla.field_15222, 0.3f);
            source.spawnParticles((class_2394)class_2398.field_11204, 3);
        }
        ++this.age;
        source.asEntity().method_5684(this.age < 25);
        return true;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10569("age", this.age);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.age = compound.method_10550("age");
    }
}

