/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.ability.Abilities;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.OrientedBillboardParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleSpawner;
import com.minelittlepony.unicopia.particle.TargetBoundParticleEffect;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.server.world.ModificationType;
import com.minelittlepony.unicopia.util.shape.Shape;
import com.minelittlepony.unicopia.util.shape.Sphere;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class RainboomAbilitySpell
extends AbstractSpell {
    private static final int RADIUS = 5;
    private static final Shape EFFECT_RANGE = new Sphere(false, 5.0);
    @Nullable
    private ParticleSpawner boundParticle;
    private int age;

    public RainboomAbilitySpell(CustomisedSpellType<?> type) {
        super(type);
        this.setHidden(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        Pony pony;
        if (situation != Situation.BODY) return false;
        if (!source.canUse(Abilities.RAINBOOM)) {
            return false;
        }
        if (source instanceof Pony && !(pony = (Pony)source).getPhysics().isFlying()) {
            return false;
        }
        if (source.isClient()) {
            if (this.boundParticle == null) {
                this.boundParticle = InteractionManager.getInstance().createBoundParticle(this.getUuid());
            }
            this.boundParticle.addParticle(new TargetBoundParticleEffect(UParticles.RAINBOOM_TRAIL, (class_1297)source.asEntity()), source.getOriginVector(), class_243.field_1353);
            if (this.age == 0) {
                source.addParticle(new OrientedBillboardParticleEffect(UParticles.RAINBOOM_RING, source.getPhysics().getMotionAngle()), source.getOriginVector(), class_243.field_1353);
            }
        }
        source.findAllEntitiesInRange(5.0, e -> !source.isOwnerOrFriend((class_1297)e)).forEach(e -> e.method_5643((class_1282)source.damageOf(UDamageTypes.RAINBOOM, source), 6.0f));
        EFFECT_RANGE.translate((class_2382)source.getOrigin()).getBlockPositions().forEach(pos -> {
            class_2680 state = source.asWorld().method_8320(pos);
            if (state.method_26164(UTags.Blocks.FRAGILE) && source.canModifyAt((class_2338)pos, ModificationType.PHYSICAL)) {
                source.asWorld().method_22352(pos, true);
            }
        });
        class_243 motion = source.asEntity().method_5828(1.0f).method_1021(1.5);
        class_243 velocity = source.asEntity().method_18798().method_1019(motion);
        while (velocity.method_1033() > 3.0) {
            velocity = velocity.method_1021(0.6);
        }
        source.asEntity().method_18799(velocity);
        if (source instanceof Pony) {
            Pony pony2 = (Pony)source;
            pony2.getMagicalReserves().getExhaustion().multiply(0.2f);
        }
        if (source.asEntity().method_31481()) return false;
        int n = this.age++;
        if (!((float)n < 90.0f + 7.0f * source.getLevel().getScaled(9.0f))) return false;
        return true;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10569("age", this.age);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.age = compound.method_10550("age");
        this.boundParticle = null;
    }
}

