/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.PlacementControlSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.ThrowableSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.server.world.Ether;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.base.Objects;

public interface Spell
extends NbtSerialisable,
Affine {
    public CustomisedSpellType<?> getTypeAndTraits();

    public DataTracker getDataTracker();

    default public boolean isOf(SpellType<?> type) {
        return this.getTypeAndTraits().type() == type;
    }

    @Override
    default public Affinity getAffinity() {
        return this.getTypeAndTraits().type().getAffinity();
    }

    public UUID getUuid();

    default public boolean equalsOrContains(UUID id) {
        return Objects.equal((Object)this.getUuid(), (Object)id);
    }

    default public <T extends Spell> Stream<T> findMatches(SpellPredicate<T> predicate) {
        return predicate == null || predicate.test(this) ? Stream.of(this) : Stream.empty();
    }

    public void setDead();

    public boolean isDead();

    public boolean isDying();

    default public boolean apply(Caster<?> caster) {
        caster.getSpellSlot().put(this);
        if (!caster.isClient()) {
            Ether.get(caster.asWorld()).getOrCreate(this, caster);
        }
        return true;
    }

    @Nullable
    default public Spell prepareForCast(Caster<?> caster, CastingMethod method) {
        return method == CastingMethod.STAFF ? this.toThrowable() : this;
    }

    public boolean tick(Caster<?> var1, Situation var2);

    public void tickDying(Caster<?> var1);

    public boolean isHidden();

    public void setHidden(boolean var1);

    public void destroy(Caster<?> var1);

    default public PlacementControlSpell toPlaceable() {
        return new PlacementControlSpell(this);
    }

    default public ThrowableSpell toThrowable() {
        return new ThrowableSpell(this);
    }

    @Nullable
    public static <T extends Spell> T readNbt(@Nullable class_2487 compound, class_7225.class_7874 lookup) {
        try {
            if (compound != null) {
                return CustomisedSpellType.fromNBT(compound).create(compound, lookup);
            }
        }
        catch (Exception e) {
            Unicopia.LOGGER.fatal("Invalid spell nbt {}", (Throwable)e);
        }
        return null;
    }

    public static UUID getUuid(@Nullable class_2487 compound) {
        return compound == null || !compound.method_25928("uuid") ? class_156.field_25140 : compound.method_25926("uuid");
    }

    public static class_2487 writeNbt(@Nullable Spell effect, class_7225.class_7874 lookup) {
        if (effect == null) {
            return new class_2487();
        }
        class_2487 compound = effect.toNBT(lookup);
        effect.getTypeAndTraits().toNbt(compound);
        return compound;
    }

    public static <T extends Spell> Spell copy(T spell, class_7225.class_7874 lookup) {
        return Spell.readNbt(Spell.writeNbt(spell, lookup), lookup);
    }
}

