/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDelegatingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.projectile.MagicBeamEntity;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public final class ThrowableSpell
extends AbstractDelegatingSpell
implements ProjectileDelegate.ConfigurationListener,
ProjectileDelegate.BlockHitListener,
ProjectileDelegate.EntityHitListener {
    public ThrowableSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    public ThrowableSpell(Spell delegate) {
        super(SpellType.THROWN_SPELL.withTraits(delegate.getTypeAndTraits().traits()), delegate);
    }

    @Override
    public boolean apply(Caster<?> source) {
        return this.throwProjectile(source).isPresent();
    }

    public Optional<MagicBeamEntity> throwProjectile(Caster<?> caster) {
        return this.throwProjectile(caster, 1.0f);
    }

    public Optional<MagicBeamEntity> throwProjectile(Caster<?> caster, float divergance) {
        class_1937 world = caster.asWorld();
        caster.playSound(USounds.SPELL_CAST_SHOOT, 0.7f, 0.4f / (world.field_9229.method_43057() * 0.4f + 0.8f));
        if (caster.isClient()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.delegate.get().prepareForCast(caster, CastingMethod.STORED)).map(s -> {
            MagicBeamEntity projectile = new MagicBeamEntity(world, (class_1297)caster.asEntity(), divergance, (Spell)s);
            this.configureProjectile(projectile, caster);
            world.method_8649((class_1297)projectile);
            return projectile;
        });
    }

    @Override
    public ThrowableSpell toThrowable() {
        return this;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void setHidden(boolean hidden) {
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3965 hit) {
        Object t = this.delegate.get();
        if (t instanceof ProjectileDelegate.BlockHitListener) {
            ProjectileDelegate.BlockHitListener listener = (ProjectileDelegate.BlockHitListener)t;
            listener.onImpact(projectile, hit);
        }
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        Object t = this.delegate.get();
        if (t instanceof ProjectileDelegate.EntityHitListener) {
            ProjectileDelegate.EntityHitListener listener = (ProjectileDelegate.EntityHitListener)t;
            listener.onImpact(projectile, hit);
        }
    }

    @Override
    public void configureProjectile(MagicProjectileEntity projectile, Caster<?> caster) {
        Object t = this.delegate.get();
        if (t instanceof ProjectileDelegate.ConfigurationListener) {
            ProjectileDelegate.ConfigurationListener listener = (ProjectileDelegate.ConfigurationListener)t;
            listener.configureProjectile(projectile, caster);
        }
    }
}

