/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.attribute;

import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SpellAttribute<T>(Trait trait, BiFunction<SpellTraits, Float, T> valueGetter, TooltipFactory tooltipFactory) implements TooltipFactory
{
    @Override
    public void appendTooltip(CustomisedSpellType<?> type, List<class_2561> tooltip) {
        this.tooltipFactory.appendTooltip(type, tooltip);
    }

    public T get(SpellTraits traits) {
        return this.valueGetter.apply(traits, Float.valueOf(traits.get(this.trait)));
    }

    public static <T extends Number> SpellAttribute<T> create(SpellAttributeType id, AttributeFormat format, Trait trait, BiFunction<SpellTraits, Float, @NotNull T> valueGetter) {
        return SpellAttribute.create(id, format, format, trait, valueGetter, false);
    }

    public static <T extends Number> SpellAttribute<T> create(SpellAttributeType id, AttributeFormat format, Trait trait, Float2ObjectFunction<@NotNull T> valueGetter) {
        return SpellAttribute.create(id, format, format, trait, valueGetter, false);
    }

    public static <T extends Number> SpellAttribute<T> create(SpellAttributeType id, AttributeFormat baseFormat, AttributeFormat relativeFormat, Trait trait, Float2ObjectFunction<@NotNull T> valueGetter) {
        return SpellAttribute.create(id, baseFormat, relativeFormat, trait, valueGetter, false);
    }

    public static <T extends Number> SpellAttribute<T> create(SpellAttributeType id, AttributeFormat baseFormat, AttributeFormat relativeFormat, Trait trait, BiFunction<SpellTraits, Float, @NotNull T> valueGetter) {
        return SpellAttribute.create(id, baseFormat, relativeFormat, trait, valueGetter, false);
    }

    public static <T extends Number> SpellAttribute<T> create(SpellAttributeType id, AttributeFormat baseFormat, AttributeFormat relativeFormat, Trait trait, Float2ObjectFunction<@NotNull T> valueGetter, boolean detrimental) {
        return SpellAttribute.create(id, baseFormat, relativeFormat, trait, (SpellTraits traits, Float value) -> (Number)valueGetter.get(value.floatValue()), detrimental);
    }

    public static <T extends Number> SpellAttribute<T> create(SpellAttributeType id, AttributeFormat baseFormat, AttributeFormat relativeFormat, Trait trait, BiFunction<SpellTraits, Float, @NotNull T> valueGetter, boolean detrimental) {
        return SpellAttribute.createRanged(id, baseFormat, relativeFormat, trait, null, valueGetter, detrimental);
    }

    public static <T extends Number> SpellAttribute<T> createRanged(SpellAttributeType id, AttributeFormat baseFormat, AttributeFormat relativeFormat, Trait trait, @Nullable SpellAttribute<T> maxValueGetter, BiFunction<SpellTraits, Float, @NotNull T> valueGetter, boolean detrimental) {
        BiFunction<SpellTraits, Float, @NotNull T> clampedValueGetter = maxValueGetter == null ? valueGetter : (traits, f) -> {
            Number t = (Number)valueGetter.apply((SpellTraits)traits, (Float)f);
            Number max = (Number)maxValueGetter.get((SpellTraits)traits);
            return max.floatValue() > 0.0f && t.floatValue() > max.floatValue() ? (Number)max : (Number)t;
        };
        return new SpellAttribute<T>(trait, clampedValueGetter, (type, tooltip) -> {
            class_5250 b;
            float traitAmount = type.traits().get(trait);
            float traitDifference = type.relativeTraits().get(trait);
            float max = maxValueGetter == null ? 0.0f : ((Number)maxValueGetter.get(type.traits())).floatValue();
            float value = ((Number)clampedValueGetter.apply(type.traits(), Float.valueOf(traitAmount))).floatValue();
            class_5250 class_52502 = b = max > 0.0f ? baseFormat.getBase(id.name(), value, max, "equals", class_124.field_1076) : baseFormat.getBase(id.name(), value, "equals", class_124.field_1076);
            if (traitDifference != 0.0f) {
                tooltip.add(b.method_10852(relativeFormat.getRelative(((Number)valueGetter.apply(type.traits(), Float.valueOf(traitAmount - traitDifference))).floatValue(), value, detrimental)));
                tooltip.add(AttributeFormat.formatTraitDifference(trait, traitDifference));
            } else {
                tooltip.add(b);
            }
        });
    }

    public static SpellAttribute<Boolean> createConditional(SpellAttributeType id, Trait trait, Float2ObjectFunction<Boolean> valueGetter) {
        return SpellAttribute.createConditional(id, trait, (SpellTraits traits, Float value) -> (Boolean)valueGetter.get(value.floatValue()));
    }

    public static SpellAttribute<Boolean> createConditional(SpellAttributeType id, Trait trait, BiFunction<SpellTraits, Float, @NotNull Boolean> valueGetter) {
        return new SpellAttribute<Boolean>(trait, valueGetter, (type, tooltip) -> {
            float difference = type.relativeTraits().get(trait);
            class_5250 value = AttributeFormat.formatAttributeLine(id.name());
            if (!((Boolean)valueGetter.apply(type.traits(), Float.valueOf(type.traits().get(trait)))).booleanValue()) {
                value = value.method_27661().method_27695(new class_124[]{class_124.field_1055, class_124.field_1063});
            }
            tooltip.add(value);
            if (difference != 0.0f) {
                tooltip.add(AttributeFormat.formatTraitDifference(trait, difference));
            }
        });
    }

    public static <T extends Enum<T>> SpellAttribute<T> createEnumerated(SpellAttributeType id, Trait trait, Float2ObjectFunction<T> valueGetter) {
        return SpellAttribute.createEnumerated(id, trait, (SpellTraits traits, Float value) -> (Enum)valueGetter.get(value.floatValue()));
    }

    public static <T extends Enum<T>> SpellAttribute<T> createEnumerated(SpellAttributeType id, Trait trait, BiFunction<SpellTraits, Float, @NotNull T> valueGetter) {
        Function cache = class_156.method_34866(t -> class_2561.method_43471((String)class_156.method_646((String)"spell_attribute", (class_2960)id.id().method_45134(p -> p + "." + t.name().toLowerCase(Locale.ROOT)))));
        return new SpellAttribute<T>(trait, valueGetter, (type, tooltip) -> {
            float difference;
            Enum t = (Enum)valueGetter.apply(type.traits(), Float.valueOf(type.traits().get(trait)));
            if (t != null) {
                int max = ((Enum[])t.getClass().getEnumConstants()).length;
                tooltip.add(class_2561.method_43469((String)" %s (%s/%s)", (Object[])new Object[]{cache.apply(t), class_2561.method_43470((String)("" + (t.ordinal() + 1))).method_27692(class_124.field_1076), max}).method_27692(class_124.field_1064));
            }
            if ((difference = type.relativeTraits().get(trait)) != 0.0f) {
                tooltip.add(AttributeFormat.formatTraitDifference(trait, difference));
            }
        });
    }
}

