/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.crafting;

import com.minelittlepony.unicopia.ability.magic.spell.crafting.IngredientWithSpell;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.SpellbookRecipe;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.TraitIngredient;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.item.EnchantableItem;
import com.minelittlepony.unicopia.recipe.URecipes;
import com.minelittlepony.unicopia.util.InventoryUtil;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SpellCraftingRecipe
implements SpellbookRecipe {
    private static final Codec<class_1799> RESULT_CODEC = CodecUtils.extend(class_1799.field_24671, SpellType.REGISTRY.method_39673().fieldOf("spell")).xmap(pair -> ((Optional)pair.getSecond()).map(spell -> EnchantableItem.enchant(((Optional)pair.getFirst()).orElse(class_1799.field_8037), spell)).orElse(((Optional)pair.getFirst()).orElse(class_1799.field_8037)), stack -> Pair.of(Optional.of(stack), EnchantableItem.getSpellKeyOrEmpty(stack)));
    public static final MapCodec<SpellCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IngredientWithSpell.CODEC.fieldOf("material").forGetter(recipe -> recipe.material), (App)TraitIngredient.CODEC.fieldOf("traits").forGetter(recipe -> recipe.requiredTraits), (App)IngredientWithSpell.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.requiredItems), (App)RESULT_CODEC.fieldOf("result").forGetter(recipe -> recipe.output)).apply((Applicative)instance, SpellCraftingRecipe::new));
    public static final class_9139<class_9129, SpellCraftingRecipe> PACKET_CODEC = class_9139.method_56905(IngredientWithSpell.PACKET_CODEC, recipe -> recipe.material, TraitIngredient.PACKET_CODEC, recipe -> recipe.requiredTraits, (class_9139)IngredientWithSpell.PACKET_CODEC.method_56433(class_9135.method_56363()), recipe -> recipe.requiredItems, (class_9139)class_1799.field_48349, recipe -> recipe.output, SpellCraftingRecipe::new);
    final IngredientWithSpell material;
    final TraitIngredient requiredTraits;
    final List<IngredientWithSpell> requiredItems;
    final class_1799 output;

    public SpellCraftingRecipe(IngredientWithSpell material, TraitIngredient requiredTraits, List<IngredientWithSpell> requiredItems, class_1799 output) {
        this.material = material;
        this.requiredTraits = requiredTraits;
        this.requiredItems = requiredItems;
        this.output = output;
    }

    @Override
    public void buildCraftingTree(SpellbookRecipe.CraftingTreeBuilder builder) {
        builder.input(this.material.getMatchingStacks());
        for (IngredientWithSpell ingredient : this.requiredItems) {
            builder.input(ingredient.getMatchingStacks());
        }
        this.requiredTraits.min().ifPresent(min -> min.forEach(e -> builder.input((Trait)e.getKey(), ((Float)e.getValue()).floatValue())));
        builder.result(this.output);
    }

    @Override
    public int getPriority() {
        return this.requiredItems.isEmpty() ? 0 : -1;
    }

    public boolean matches(SpellbookRecipe.Input inventory, class_1937 world) {
        if (!this.material.test(inventory.stackToModify())) {
            return false;
        }
        if (this.requiredItems.isEmpty()) {
            return this.requiredTraits.test(inventory.traits());
        }
        ArrayList<IngredientWithSpell> outstandingRequirements = new ArrayList<IngredientWithSpell>(this.requiredItems);
        List ingredients = InventoryUtil.slots(inventory).filter(slot -> !inventory.method_59984((int)slot).method_7960()).map(slot -> Pair.of((Object)slot, (Object)inventory.method_59984((int)slot))).collect(Collectors.toList());
        outstandingRequirements.removeIf(requirement -> {
            Optional<Pair> found = ingredients.stream().filter(pair -> requirement.test((class_1799)pair.getSecond())).findAny();
            found.ifPresent(ingredients::remove);
            return found.isPresent();
        });
        if (!outstandingRequirements.isEmpty()) {
            return false;
        }
        return this.requiredTraits.test(SpellTraits.union((SpellTraits[])ingredients.stream().map(pair -> SpellTraits.of((class_1799)pair.getSecond()).multiply(((Integer)pair.getFirst()).intValue())).toArray(SpellTraits[]::new)));
    }

    public class_1799 craft(SpellbookRecipe.Input inventory, class_7225.class_7874 registries) {
        return this.method_8110(registries).method_7972();
    }

    public boolean method_8113(int width, int height) {
        return width * height > 0;
    }

    public class_1799 method_8110(class_7225.class_7874 registries) {
        return this.output;
    }

    public class_1865<?> method_8119() {
        return URecipes.TRAIT_REQUIREMENT;
    }
}

