/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.HomingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AttractionUtils;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.ShieldSpell;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.shape.Sphere;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_7225;

public class AttractiveSpell
extends ShieldSpell
implements HomingSpell,
TimedSpell,
ProjectileDelegate.EntityHitListener {
    static final SpellAttribute<Boolean> TARGET_FOCUSED_ENTITY = SpellAttribute.createConditional(SpellAttributeType.FOCUSED_ENTITY, Trait.ORDER, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)order -> order >= 20.0f));
    static final SpellAttribute<Boolean> STICK_TO_TARGET = SpellAttribute.createConditional(SpellAttributeType.STICK_TO_TARGET, Trait.CHAOS, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)chaos -> chaos > 0.0f));
    static final TooltipFactory TARGET = (type, tooltip) -> (TARGET_FOCUSED_ENTITY.get(type.traits()) != false ? TARGET_FOCUSED_ENTITY : ShieldSpell.TARGET).appendTooltip(type, tooltip);
    static final TooltipFactory TOOLTIP = TooltipFactory.of(TIME, RANGE, TARGET, STICK_TO_TARGET, CAST_ON);
    private final EntityReference<class_1297> target;
    private final TimedSpell.Timer timer;

    protected AttractiveSpell(CustomisedSpellType<?> type) {
        super(type);
        this.target = this.dataTracker.startTracking(new EntityReference());
        this.timer = new TimedSpell.Timer((Integer)TIME.get(this.getTraits()));
    }

    @Override
    public TimedSpell.Timer getTimer() {
        return this.timer;
    }

    @Override
    public boolean tick(Caster<?> caster, Situation situation) {
        this.timer.tick();
        if (this.timer.getTicksRemaining() <= 0) {
            return false;
        }
        this.target.getOrEmpty(caster.asWorld()).filter(entity -> (double)entity.method_5739(caster.asEntity()) > this.getDrawDropOffRange(caster)).ifPresent(entity -> {
            class_243 pos = caster.getOriginVector();
            entity.method_5859(pos.field_1352, pos.field_1351, pos.field_1350);
        });
        return super.tick(caster, situation);
    }

    @Override
    public void generateParticles(Caster<?> source) {
        double range = this.getDrawDropOffRange(source);
        class_243 origin = this.getOrigin(source);
        source.spawnParticles(origin, new Sphere(false, range), 7, p -> source.addParticle(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, origin, 0.4f).withChild((class_2394)class_2398.field_11245), (class_243)p, class_243.field_1353));
    }

    @Override
    protected boolean isValidTarget(Caster<?> source, class_1297 entity) {
        return this.target.referenceEquals(entity) || super.isValidTarget(source, entity);
    }

    @Override
    protected void applyRadialEffect(Caster<?> source, class_1297 target, double distance, double radius) {
        double force = 2.5 * distance;
        boolean isGood = this.isFriendlyTogether(source);
        if (isGood) {
            force *= AttractionUtils.getForceAdjustment(target);
        }
        if (!isGood && source.asWorld().field_9229.method_43048(4500) == 0) {
            source.asEntity().method_5643((class_1282)source.damageOf(UDamageTypes.GAVITY_WELL_RECOIL, source), 4.0f);
        }
        AttractionUtils.applyForce(this.getOrigin(source), target, -force, 0.0, false);
        float maxVel = !this.isFriendlyTogether(source) ? 1.0f : 1.6f;
        class_243 vel = target.method_18798();
        double x = class_3532.method_15350((double)vel.field_1352, (double)(-maxVel), (double)maxVel);
        double y = class_3532.method_15350((double)vel.field_1351, (double)(-maxVel), (double)maxVel);
        double z = class_3532.method_15350((double)vel.field_1350, (double)(-maxVel), (double)maxVel);
        if (distance < 0.5) {
            z += (double)(maxVel * 2.0f);
        }
        if (distance < 2.0) {
            x = 0.0;
            z = 0.0;
        }
        if (this.target.referenceEquals(target)) {
            target.field_6017 = 0.0f;
            if (target.method_24828()) {
                target.method_33574(target.method_19538().method_1031(0.0, 0.3, 0.0));
                target.method_24830(false);
            }
        }
        target.method_18800(x, y, z);
        Living.updateVelocity(target);
    }

    @Override
    public boolean setTarget(class_1297 target) {
        if (TARGET_FOCUSED_ENTITY.get(this.getTraits()).booleanValue()) {
            this.target.set(target);
            target.method_5834(true);
            return true;
        }
        return false;
    }

    @Override
    protected void onDestroyed(Caster<?> caster) {
        super.onDestroyed(caster);
        this.target.getOrEmpty(caster.asWorld()).ifPresent(target -> target.method_5834(false));
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        if (!this.isDead() && STICK_TO_TARGET.get(this.getTraits()).booleanValue()) {
            this.setDead();
            Caster.of(hit.method_17782()).ifPresent(caster -> this.getTypeAndTraits().apply((Caster<?>)caster, CastingMethod.INDIRECT));
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10566("target", (class_2520)this.target.toNBT(lookup));
        this.timer.toNBT(compound, lookup);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.target.fromNBT(compound.method_10562("target"), lookup);
        this.timer.fromNBT(compound, lookup);
    }
}

