/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.AttributeContainer;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.mob.UEntityAttributes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.shape.Sphere;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_7225;

public class BubbleSpell
extends AbstractSpell
implements TimedSpell,
ProjectileDelegate.EntityHitListener {
    private static final class_2960 EFFECT_ID = Unicopia.id("bubble_floating_modifier");
    private static final class_1322 GRAVITY_MODIFIER = new class_1322(EFFECT_ID, -0.98, class_1322.class_1323.field_6331);
    private static final class_1322 SPEED_MODIFIER = new class_1322(EFFECT_ID, -0.99, class_1322.class_1323.field_6331);
    private static final Map<class_6880<class_1320>, class_1322> MODIFIERS = Map.of(UEntityAttributes.ENTITY_GRAVITY_MODIFIER, GRAVITY_MODIFIER, UEntityAttributes.EXTENDED_REACH_DISTANCE, GRAVITY_MODIFIER, UEntityAttributes.EXTENDED_ATTACK_DISTANCE, GRAVITY_MODIFIER, class_5134.field_23719, SPEED_MODIFIER, class_5134.field_23720, SPEED_MODIFIER);
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.FOCUS, 6.0f).with(Trait.POWER, 1.0f).build();
    private static final SpellAttribute<Integer> SOAPINESS = SpellAttribute.create(SpellAttributeType.SOAPINESS, AttributeFormat.REGULAR, Trait.POWER, power -> (int)(power * 2.0f));
    static final TooltipFactory TOOLTIP = TooltipFactory.of(TimedSpell.TIME, SOAPINESS);
    private final TimedSpell.Timer timer = new TimedSpell.Timer((Integer)TIME.get(this.getTraits()));
    private float prevRadius;
    private DataTracker.Entry<Float> radius = this.dataTracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(0.0f));
    private DataTracker.Entry<Integer> struggles = this.dataTracker.startTracking(TrackableDataType.INT, SOAPINESS.get(this.getTraits()));

    protected BubbleSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public TimedSpell.Timer getTimer() {
        return this.timer;
    }

    public float getRadius(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevRadius, (float)this.radius.get().floatValue());
    }

    @Override
    public boolean apply(Caster<?> source) {
        if (source.getSpellSlot().removeWhere(this.getType())) {
            return false;
        }
        Object entity = source.asEntity();
        if (source instanceof AttributeContainer) {
            AttributeContainer l = (AttributeContainer)((Object)source);
            l.applyAttributeModifiers(MODIFIERS, false, true);
        }
        this.radius.set(Float.valueOf(Math.max(entity.method_17682(), entity.method_17681()) * 1.2f));
        source.playSound(USounds.ENTITY_PLAYER_UNICORN_TELEPORT, 1.0f);
        entity.method_5762(0.0, (double)(0.2f * (float)source.getPhysics().getGravitySignum()), 0.0);
        Living.updateVelocity(entity);
        return super.apply(source);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        Pony pony;
        if (situation == Situation.PROJECTILE) {
            source.spawnParticles((class_2394)UParticles.BUBBLE, 2);
            return true;
        }
        this.timer.tick();
        boolean done = this.timer.getTicksRemaining() <= 0;
        source.spawnParticles(source.getOriginVector().method_1031(0.0, 1.0, 0.0), new Sphere(true, this.radius.get().floatValue() * (done ? 0.25f : 0.5f)), done ? 13 : 1, pos -> source.addParticle((class_2394)(done ? class_2398.field_11241 : UParticles.BUBBLE), (class_243)pos, class_243.field_1353));
        if (done) {
            return false;
        }
        source.asEntity().method_5762((double)(class_3532.method_15374((float)((float)((class_1297)source.asEntity()).field_6012 / 6.0f)) / 50.0f), (double)(class_3532.method_15374((float)((float)((class_1297)source.asEntity()).field_6012 / 6.0f)) / 50.0f), (double)(class_3532.method_15374((float)((float)((class_1297)source.asEntity()).field_6012 / 6.0f)) / 50.0f));
        ((class_1297)source.asEntity()).field_6017 = 0.0f;
        this.prevRadius = this.radius.get().floatValue();
        if (source instanceof Pony && (pony = (Pony)source).sneakingChanged() && ((class_1657)pony.asEntity()).method_5715()) {
            this.radius.set(Float.valueOf(this.radius.get().floatValue() + 0.5f));
            source.playSound(USounds.SPELL_BUBBLE_DISTURB, 1.0f);
            int s = this.struggles.get() - 1;
            this.struggles.set(s);
            if (s <= 0) {
                this.setDead();
                return false;
            }
        }
        return !this.isDead();
    }

    @Override
    protected void onDestroyed(Caster<?> source) {
        super.onDestroyed(source);
        if (source instanceof AttributeContainer) {
            AttributeContainer l = (AttributeContainer)((Object)source);
            l.applyAttributeModifiers(MODIFIERS, false, false);
        }
        source.playSound(USounds.ENTITY_PLAYER_UNICORN_TELEPORT, 1.0f);
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        Caster.of(hit.method_17782()).ifPresent(caster -> this.getTypeAndTraits().apply((Caster<?>)caster, CastingMethod.INDIRECT));
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10569("struggles", this.struggles.get().intValue());
        compound.method_10548("radius", this.radius.get().floatValue());
        this.timer.toNBT(compound, lookup);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.struggles.set(compound.method_10550("struggles"));
        this.radius.set(Float.valueOf(compound.method_10583("radius")));
        this.timer.fromNBT(compound, lookup);
    }
}

