/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.client.TextHelper;
import com.minelittlepony.unicopia.entity.effect.EffectUtils;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1271;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_9299;
import org.jetbrains.annotations.Nullable;

public record CustomisedSpellType<T extends Spell>(SpellType<T> type, SpellTraits traits, Supplier<SpellTraits> traitsDifferenceSupplier) implements SpellPredicate<T>,
class_9299
{
    public boolean isEmpty() {
        return this.type.isEmpty();
    }

    public boolean isStackable() {
        return this.type().isStackable();
    }

    public SpellTraits relativeTraits() {
        return this.traitsDifferenceSupplier.get();
    }

    @Nullable
    public T create() {
        try {
            return this.type.getFactory().create(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public T create(class_2487 compound, class_7225.class_7874 lookup) {
        T spell = this.create();
        if (spell != null) {
            spell.fromNBT(compound, lookup);
        }
        return spell;
    }

    @Nullable
    public T apply(Caster<?> caster, CastingMethod method) {
        Spell s;
        if (this.isEmpty()) {
            return null;
        }
        T spell = this.create();
        if (spell != null && (s = spell.prepareForCast(caster, method)) != null && s.apply(caster)) {
            return spell;
        }
        return null;
    }

    @Override
    public boolean test(@Nullable Spell spell) {
        return spell != null && spell.getTypeAndTraits().equals(this);
    }

    public class_1799 getDefaultStack() {
        return this.traits.applyTo(this.type.getDefualtStack());
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        if (this.isEmpty()) {
            return;
        }
        class_5250 lore = class_2561.method_43471((String)(this.type().getTranslationKey() + ".lore")).method_27692(this.type().getAffinity().getColor());
        if (!InteractionManager.getInstance().getClientSpecies().canCast()) {
            lore = lore.method_27692(class_124.field_1051);
        }
        TextHelper.wrap((class_2561)lore, 180).forEach(tooltip);
        float corruption = (int)this.traits().getCorruption() * 10 + this.type().getAffinity().getCorruption();
        ArrayList<class_2561> modifiers = new ArrayList<class_2561>();
        this.type().getTooltip().appendTooltip(this, modifiers);
        if (corruption != 0.0f) {
            modifiers.add(EffectUtils.formatModifierChange("affinity.unicopia.corruption", corruption, true));
        }
        if (!modifiers.isEmpty()) {
            tooltip.accept((class_2561)class_2561.method_43473());
            tooltip.accept((class_2561)class_2561.method_43471((String)"affinity.unicopia.when_cast").method_27692(class_124.field_1080));
            modifiers.forEach(tooltip);
        }
    }

    public class_1271<CustomisedSpellType<?>> toAction() {
        return this.isEmpty() ? class_1271.method_22431((Object)this) : class_1271.method_22430((Object)this);
    }

    public class_2487 toNbt(class_2487 compound) {
        this.type.toNbt(compound);
        compound.method_10566("traits", (class_2520)this.traits.toNbt());
        return compound;
    }

    public static <T extends Spell> CustomisedSpellType<T> fromNBT(class_2487 compound) {
        SpellType type = SpellType.getKey(compound);
        return type.withTraits(SpellTraits.fromNbt(compound.method_10562("traits")).orElse(type.getTraits()));
    }
}

