/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AttractionUtils;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CatapultSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.TargetSelecter;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.mob.CastSpellEntity;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.LightningBoltParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.projectile.MagicBeamEntity;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.server.world.UGameRules;
import com.minelittlepony.unicopia.util.Lerp;
import com.minelittlepony.unicopia.util.shape.Sphere;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class DarkVortexSpell
extends AbstractSpell
implements ProjectileDelegate.BlockHitListener {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.CHAOS, 5.0f).with(Trait.KNOWLEDGE, 1.0f).with(Trait.STRENGTH, 70.0f).with(Trait.DARKNESS, 100.0f).build();
    private final DataTracker.Entry<Float> accumulatedMass;
    private final TargetSelecter targetSelecter;
    private final Lerp radius;

    protected DarkVortexSpell(CustomisedSpellType<?> type) {
        super(type);
        this.accumulatedMass = this.dataTracker.startTracking(TrackableDataType.FLOAT, Float.valueOf(0.0f));
        this.targetSelecter = new TargetSelecter(this).setFilter(this::isValidTarget).setTargetowner(true).setTargetAllies(true);
        this.radius = new Lerp(0.0f);
    }

    private double getMass() {
        return 0.1f + this.accumulatedMass.get().floatValue() / 10.0f;
    }

    public double getEventHorizonRadius() {
        return this.radius.getValue();
    }

    public double getDrawDropOffRange() {
        return this.getEventHorizonRadius() * 20.0;
    }

    private double getAttractiveForce(Caster<?> source, class_1297 target) {
        return AttractionUtils.getAttractiveForce(this.getMass(), this.getOrigin(source), target);
    }

    @Override
    public Spell prepareForCast(Caster<?> caster, CastingMethod method) {
        return method == CastingMethod.STAFF ? this.toThrowable() : this.toPlaceable();
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (situation == Situation.PROJECTILE) {
            return false;
        }
        if (situation == Situation.BODY) {
            return true;
        }
        class_243 origin = this.getOrigin(source);
        double mass = this.getMass() * 0.1;
        double logarithm = 1.0 - 1.0 / (1.0 + mass * mass);
        this.radius.update((float)Math.max(0.01, logarithm * (double)source.asWorld().method_8450().method_8356(UGameRules.MAX_DARK_VORTEX_SIZE)), 200L);
        if (((class_1297)source.asEntity()).field_6012 % 20 == 0) {
            source.asWorld().method_8396(null, source.getOrigin(), USounds.AMBIENT_DARK_VORTEX_ADDITIONS, class_3419.field_15256, 1.0f, 1.0f);
        }
        double eventHorizon = this.getEventHorizonRadius();
        if (source.isClient()) {
            if (eventHorizon > 0.3) {
                double range = eventHorizon * 2.0;
                source.spawnParticles(origin, new Sphere(false, range), 50, p -> source.addParticle(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, origin, 0.4f).withChild((class_2394)(source.asWorld().method_22347(class_2338.method_49638((class_2374)p)) ? class_2398.field_11251 : class_2398.field_17431)), (class_243)p, class_243.field_1353));
            }
            if (source.asWorld().field_9229.method_43048(300) == 0) {
                ParticleUtils.spawnParticle(source.asWorld(), LightningBoltParticleEffect.DEFAULT, origin, class_243.field_1353);
            }
        } else if (eventHorizon > 2.0) {
            new Sphere(false, eventHorizon + 3.0).translate(origin).randomPoints(10, source.asWorld().field_9229).forEach(i -> {
                class_2338 pos = class_2338.method_49638((class_2374)i);
                if (!source.asWorld().method_22347(pos)) {
                    new Sphere(false, 3.0).translate((class_243)i).getBlockPositions().forEach(p -> this.affectBlock(source, (class_2338)p, origin));
                    ParticleUtils.spawnParticle(source.asWorld(), new LightningBoltParticleEffect(true, 10, 6, 3.0f, Optional.of(i)), this.getOrigin(source), class_243.field_1353);
                }
            });
        }
        for (class_1297 insideEntity : source.findAllEntitiesInRange(eventHorizon * 0.5).toList()) {
            insideEntity.method_18799(class_243.field_1353);
            Living.updateVelocity(insideEntity);
            if (!(insideEntity instanceof CastSpellEntity)) continue;
            CastSpellEntity s = (CastSpellEntity)insideEntity;
            if (!this.getType().isOn(insideEntity)) continue;
            this.setDead();
            s.getSpellSlot().clear();
            source.asWorld().method_8437(source.asEntity(), origin.field_1352, origin.field_1351, origin.field_1350, 12.0f, class_1937.class_7867.field_40888);
            source.asWorld().method_8437(source.asEntity(), insideEntity.method_23317(), insideEntity.method_23318(), insideEntity.method_23321(), 12.0f, class_1937.class_7867.field_40888);
            return false;
        }
        this.targetSelecter.getEntities(source, this.getDrawDropOffRange()).forEach(i -> {
            try {
                this.affectEntity(source, (class_1297)i, origin);
            }
            catch (Throwable e) {
                Unicopia.LOGGER.error("Error updating radial effect", e);
            }
        });
        if (!source.subtractEnergyCost(0.01)) {
            this.setDead();
            source.asWorld().method_8437(source.asEntity(), origin.field_1352, origin.field_1351, origin.field_1350, 3.0f, class_1937.class_7867.field_40888);
        }
        return true;
    }

    @Override
    public void tickDying(Caster<?> source) {
        float m = this.accumulatedMass.get().floatValue() - 0.8f;
        this.accumulatedMass.set(Float.valueOf(m));
        double mass = this.getMass() * 0.1;
        double logarithm = 1.0 - 1.0 / (1.0 + mass * mass);
        this.radius.update((float)Math.max(0.1, logarithm * (double)source.asWorld().method_8450().method_8356(UGameRules.MAX_DARK_VORTEX_SIZE)), 200L);
        if (m < 1.0f) {
            super.tickDying(source);
        }
        class_243 origin = this.getOrigin(source);
        ParticleUtils.spawnParticle(source.asWorld(), (class_2394)class_2398.field_11251, origin, new class_243(0.0, (double)0.2f, 0.0));
        ParticleUtils.spawnParticle(source.asWorld(), (class_2394)class_2398.field_11251, origin, new class_243(0.0, (double)-0.2f, 0.0));
        if (!source.isClient() && source.asWorld().method_8409().method_43048(10) == 0) {
            class_2248.method_9577((class_1937)source.asWorld(), (class_2338)class_2338.method_49638((class_2374)origin), (class_1799)(source.asWorld().method_8409().method_43048(75) == 0 ? class_1802.field_22019 : class_1802.field_8675).method_7854());
        }
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3965 hit) {
        if (!projectile.isClient() && projectile instanceof MagicBeamEntity) {
            MagicBeamEntity source = (MagicBeamEntity)projectile;
            class_243 pos = hit.method_17784();
            projectile.method_37908().method_8437((class_1297)projectile, pos.field_1352, pos.field_1351, pos.field_1350, 12.0f, class_1937.class_7867.field_40888);
            this.toPlaceable().tick(source, Situation.BODY);
        }
    }

    @Override
    public boolean isFriendlyTogether(Affine other) {
        return this.accumulatedMass.get().floatValue() < 4.0f;
    }

    private boolean isValidTarget(Caster<?> source, class_1297 entity) {
        return class_1301.field_6156.test(entity) && this.getAttractiveForce(source, entity) > 0.0;
    }

    public class_243 getOrigin(Caster<?> source) {
        return source.asEntity().method_19538().method_1031(0.0, this.getYOffset(), 0.0);
    }

    public double getYOffset() {
        return 2.0;
    }

    private boolean canAffect(Caster<?> source, class_2338 pos) {
        return source.canModifyAt(pos) && source.asWorld().method_8320(pos).method_26214((class_1922)source.asWorld(), pos) >= 0.0f && !source.asWorld().method_8320(pos).method_26164(UTags.Blocks.CATAPULT_IMMUNE);
    }

    private void affectBlock(Caster<?> source, class_2338 pos, class_243 origin) {
        if (!this.canAffect(source, pos)) {
            if (source.asWorld().method_8320(pos).method_27852(class_2246.field_9987)) {
                source.asWorld().method_8501(pos, class_2246.field_10499.method_9564());
            }
            return;
        }
        if (pos.method_19769((class_2374)origin, this.getEventHorizonRadius())) {
            source.asWorld().method_22352(pos, false);
            this.updateStatePostRemoval(source, pos);
        } else {
            CatapultSpell.createBlockEntity(source.asWorld(), pos, e -> {
                this.updateStatePostRemoval(source, pos);
                e.method_5762(0.0, 0.1, 0.0);
            });
        }
    }

    private void updateStatePostRemoval(Caster<?> source, class_2338 pos) {
        if (!source.asWorld().method_8316(pos).method_15769()) {
            source.asWorld().method_8501(pos, class_2246.field_10124.method_9564());
        }
    }

    private void affectEntity(Caster<?> source, class_1297 target, class_243 origin) {
        double eventHorizonRadius;
        double distance = target.method_19538().method_1022(origin);
        if (distance <= (eventHorizonRadius = this.getEventHorizonRadius()) + 0.5) {
            target.method_18799(target.method_18798().method_1021(distance < 1.0 ? distance : distance / (2.0 * eventHorizonRadius)));
            Living.updateVelocity(target);
            @Nullable E master = source.getMaster();
            if (target instanceof MagicProjectileEntity) {
                MagicProjectileEntity projectile = (MagicProjectileEntity)target;
                class_1792 item = projectile.method_7495().method_7909();
                if (item instanceof ProjectileDelegate.EntityHitListener) {
                    ProjectileDelegate.EntityHitListener p = (ProjectileDelegate.EntityHitListener)item;
                    if (master != null) {
                        p.onImpact(projectile, new class_3966(master));
                    }
                }
            } else if (target instanceof class_1665) {
                if (master != null) {
                    master.method_5643(master.method_48923().method_48811(target, ((class_1665)target).method_24921()), 4.0f);
                }
                target.method_31472();
                return;
            }
            double massOfTarget = AttractionUtils.getMass(target);
            if (!source.isClient() && massOfTarget != 0.0) {
                this.accumulatedMass.set(Float.valueOf((float)((double)this.accumulatedMass.get().floatValue() + massOfTarget)));
            }
            target.method_5643((class_1282)source.damageOf(UDamageTypes.GAVITY_WELL_RECOIL, source), 2.1474836E9f);
            if (!(target instanceof class_1657)) {
                target.method_31472();
                source.asWorld().method_8396(null, target.method_24515(), USounds.AMBIENT_DARK_VORTEX_MOOD, class_3419.field_15256, 2.0f, 0.002f);
            }
            if (target.method_5805()) {
                target.method_5643(source.asEntity().method_48923().method_48829(), 2.1474836E9f);
            }
            source.subtractEnergyCost(-massOfTarget * 10.0);
            if (target instanceof class_1657 && distance < eventHorizonRadius + 5.0) {
                source.asWorld().method_8396(null, target.method_24515(), USounds.AMBIENT_DARK_VORTEX_MOOD, class_3419.field_15256, 2.0f, 0.02f);
            }
        } else {
            double force = this.getAttractiveForce(source, target);
            AttractionUtils.applyForce(origin, target, -force, 0.0, true);
        }
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10548("accumulatedMass", this.accumulatedMass.get().floatValue());
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.accumulatedMass.set(Float.valueOf(compound.method_10583("accumulatedMass")));
    }
}

