/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.Owned;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AbstractSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.block.state.StateMaps;
import com.minelittlepony.unicopia.block.state.StatePredicate;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import com.minelittlepony.unicopia.util.shape.Sphere;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1541;
import net.minecraft.class_1924;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_5321;
import net.minecraft.class_8110;
import net.minecraft.class_8111;

public class IceSpell
extends AbstractSpell {
    public static final SpellTraits DEFAULT_TRAITS = new SpellTraits.Builder().with(Trait.ICE, 15.0f).build();
    private static final SpellAttribute<Float> RANGE;
    static final TooltipFactory TOOLTIP;

    protected IceSpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        boolean submerged = source.asEntity().method_5869() || source.asEntity().method_5777(class_3486.field_15518);
        float radius = RANGE.get(this.getTraits()).floatValue();
        long blocksAffected = new Sphere(false, radius).translate((class_2382)source.getOrigin()).getBlockPositions().filter(i -> {
            if (source.canModifyAt((class_2338)i) && this.applyBlockSingle((class_1297)source.asEntity(), source.asWorld(), (class_2338)i, situation)) {
                if (submerged & source.getOrigin().method_19771((class_2382)i, (double)(RANGE.get(this.getTraits()).floatValue() - 1.0f))) {
                    class_2680 state = source.asWorld().method_8320(i);
                    if (state.method_26164(class_3481.field_15467) || state.method_27852(class_2246.field_10540)) {
                        source.asWorld().method_8652(i, class_2246.field_10124.method_9564(), 1);
                    } else if (!state.method_26227().method_15769()) {
                        source.asWorld().method_8652(i, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 1);
                    }
                }
                ParticleUtils.spawnParticle(source.asWorld(), (class_2394)class_2398.field_11202, new class_243((double)((float)i.method_10263() + source.asWorld().field_9229.method_43057()), (double)(i.method_10264() + 1), (double)((float)i.method_10260() + source.asWorld().field_9229.method_43057())), class_243.field_1353);
                return true;
            }
            return false;
        }).count();
        if (!source.subtractEnergyCost(Math.min(10L, blocksAffected / 30L))) {
            this.setDead();
        }
        return this.applyEntities(source, source.getOriginVector()) && situation == Situation.PROJECTILE && !this.isDead();
    }

    protected boolean applyEntities(Caster<?> source, class_243 pos) {
        List<class_1297> entities = VecHelper.findInRange(source.asEntity(), (class_1924)source.asWorld(), pos, 3.0);
        entities.forEach(entity -> this.applyEntitySingle(source, (class_1297)entity));
        return !entities.isEmpty();
    }

    protected void applyEntitySingle(Caster<?> source, class_1297 e) {
        Owned sibling;
        if (source.asEntity() == e || source.isOwnedBy(e) || e instanceof Owned && source.hasCommonOwner(sibling = (Owned)e)) {
            return;
        }
        if (e instanceof class_1541) {
            e.method_5650(class_1297.class_5529.field_26999);
            e.method_5770().method_8501(e.method_24515(), class_2246.field_10375.method_9564());
        } else if (e.method_5809()) {
            e.method_5646();
        } else {
            e.method_5643((class_1282)source.damageOf((class_5321<class_8110>)class_8111.field_42354, source), 2.0f);
        }
    }

    private boolean applyBlockSingle(class_1297 owner, class_1937 world, class_2338 pos, Situation situation) {
        class_2680 state = world.method_8320(pos);
        if (situation == Situation.PROJECTILE && StateMaps.SNOW_PILED.convert(world, pos) || StateMaps.ICE_AFFECTED.convert(world, pos)) {
            return true;
        }
        if (world.method_8515(pos, owner) || state.method_27852(class_2246.field_10477) && (Integer)state.method_11654((class_2769)class_2488.field_11518) == 8 || state.method_26164(class_3481.field_15503)) {
            IceSpell.addSnowLayer(world, pos.method_10084());
            return true;
        }
        if (state.method_26164(class_3481.field_15467) && world.field_9229.method_43048(10) == 0 && IceSpell.isSurroundedByIce(world, pos)) {
            world.method_8501(pos, class_2246.field_10225.method_9564());
            return true;
        }
        return false;
    }

    private static boolean isSurroundedByIce(class_1937 w, class_2338 pos) {
        return PosHelper.adjacentNeighbours(pos).allMatch(i -> w.method_8320(i).method_26164(class_3481.field_15467));
    }

    private static void addSnowLayer(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26215() || StatePredicate.Plants.INSTANCE.test(state)) {
            world.method_8652(pos, class_2246.field_10477.method_9564(), 3);
        }
    }

    static {
        TOOLTIP = RANGE = SpellAttribute.create(SpellAttributeType.RANGE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.POWER, power -> Float.valueOf(Math.max(0.0f, 3.0f + power)));
    }
}

