/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractAreaEffectSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.AttributeFormat;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.Creature;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.projectile.MagicBeamEntity;
import com.minelittlepony.unicopia.projectile.MagicProjectileEntity;
import com.minelittlepony.unicopia.projectile.ProjectileDelegate;
import com.minelittlepony.unicopia.util.Weighted;
import com.minelittlepony.unicopia.util.shape.Sphere;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7225;

public class NecromancySpell
extends AbstractAreaEffectSpell
implements ProjectileDelegate.EntityHitListener,
ProjectileDelegate.BlockHitListener {
    private final Supplier<Optional<class_1299<? extends class_1309>>> spawnPool = new Weighted.Builder<class_1299>().put(7, class_1299.field_6051).put(4, class_1299.field_6071).put(3, class_1299.field_6123).put(2, class_1299.field_6050).put(1, class_1299.field_6054).build();
    static final Map<Predicate<class_1297>, class_1299<? extends class_1308>> NECROMANTIC_CONVERSIONS = Map.of(NecromancySpell.match(class_1299.field_22281), class_1299.field_6050, NecromancySpell.match(class_1299.field_21973), class_1299.field_23696, NecromancySpell.match(class_1299.field_6139), class_1299.field_6048, NecromancySpell.match(class_1299.field_6067), class_1299.field_6075, NecromancySpell.match(class_1299.field_6051), class_1299.field_6071, NecromancySpell.match(class_1299.field_6137), class_1299.field_6076, NecromancySpell.match(class_1299.field_17713), class_1299.field_6145, NecromancySpell.match(class_1299.field_6119), class_1299.field_38095, NecromancySpell.match(class_1299.field_38095), class_1299.field_6140, e -> e instanceof class_1646, class_1299.field_6054);
    static final class_1792[][] GEAR = new class_1792[][]{{class_1802.field_8267, class_1802.field_8090, class_1802.field_8743, class_1802.field_8862, class_1802.field_8805, class_1802.field_22027}, {class_1802.field_8577, class_1802.field_8523, class_1802.field_8678, class_1802.field_8058, class_1802.field_22028}, {class_1802.field_8570, class_1802.field_8396, class_1802.field_8416, class_1802.field_8348, class_1802.field_22029}, {class_1802.field_8370, class_1802.field_8660, class_1802.field_8753, class_1802.field_8285, class_1802.field_22030}, {class_1802.field_8776, class_1802.field_8699, class_1802.field_8322, class_1802.field_8528, class_1802.field_8371, class_1802.field_8845, class_1802.field_8062, class_1802.field_8475, class_1802.field_8825, class_1802.field_8556, class_1802.field_8250, class_1802.field_8802}};
    static final SpellAttribute<Integer> WAVE_SIZE = SpellAttribute.create(SpellAttributeType.WAVE_SIZE, AttributeFormat.REGULAR, AttributeFormat.PERCENTAGE, Trait.CHAOS, chaos -> 10 + (int)class_3532.method_15363((float)chaos, (float)0.0f, (float)10.0f));
    static final TooltipFactory TOOLTIP = TooltipFactory.of(RANGE, WAVE_SIZE);
    private final List<EntityReference<class_1309>> summonedEntities = new ArrayList<EntityReference<class_1309>>();
    private int spawnCountdown;

    static Predicate<class_1297> match(class_1299<?> type) {
        return e -> e.method_5864() == type;
    }

    protected NecromancySpell(CustomisedSpellType<?> type) {
        super(type);
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        float radius = source.getLevel().getScaled(4.0f) * 4.0f + ((Float)RANGE.get(this.getTraits())).floatValue();
        if (radius <= 0.0f) {
            return false;
        }
        boolean rainy = source.asWorld().method_8520(source.getOrigin());
        source.spawnParticles(new Sphere(true, radius * 2.0f), rainy ? 98 : 125, pos -> {
            class_2338 bpos = class_2338.method_49638((class_2374)pos);
            if (source.asWorld().method_22347(bpos) && !source.asWorld().method_22347(bpos.method_10074())) {
                source.addParticle((class_2394)(source.asWorld().method_8520(bpos) ? class_2398.field_11251 : class_2398.field_11240), (class_243)pos, class_243.field_1353);
            }
        });
        if (source.isClient() || source.asWorld().method_8407() == class_1267.field_5801) {
            return true;
        }
        this.summonedEntities.removeIf(ref -> ref.getOrEmpty(source.asWorld()).filter(e -> {
            if (e.method_31481()) {
                return false;
            }
            if (e.method_19538().method_1022(source.getOriginVector()) > (double)(radius * 2.0f)) {
                e.method_37908().method_8421((class_1297)e, (byte)60);
                class_243 pos = source.getOriginVector();
                e.method_23327(pos.field_1352, pos.field_1351, pos.field_1350);
            }
            return true;
        }).isEmpty());
        if (--this.spawnCountdown > 0 && !this.summonedEntities.isEmpty()) {
            return true;
        }
        this.spawnCountdown = 1200 + source.asWorld().field_9229.method_43048(rainy ? 2000 : 1000);
        float additional = source.asWorld().method_8404(source.getOrigin()).method_5457() + (float)WAVE_SIZE.get(this.getTraits()).intValue();
        if ((float)this.summonedEntities.size() > additional) {
            return true;
        }
        Sphere affectRegion = new Sphere(false, radius);
        for (int i = 0; i < 10; ++i) {
            class_243 pos2 = affectRegion.computePoint(source.asWorld().field_9229).method_1019(source.getOriginVector());
            class_2338 loc = class_2338.method_49638((class_2374)pos2);
            if (!source.asWorld().method_22347(loc.method_10084()) || source.asWorld().method_22347(loc)) continue;
            this.spawnPool.get().ifPresent(type -> this.spawnMonster(source, pos2, (class_1299<? extends class_1309>)type));
        }
        return true;
    }

    @Override
    protected void onDestroyed(Caster<?> caster) {
        super.onDestroyed(caster);
        if (caster.isClient()) {
            return;
        }
        class_1309 master = (class_1309)caster.getMaster();
        this.summonedEntities.forEach(ref -> ref.ifPresent(caster.asWorld(), e -> {
            class_1937 patt0$temp = caster.asWorld();
            if (patt0$temp instanceof class_3218) {
                class_3218 sw = (class_3218)patt0$temp;
                class_1890.method_60107((class_3218)sw, (class_1297)e, (class_1282)e.method_48923().method_48815((class_1297)e, (class_1297)master));
            }
            e.method_37908().method_8421((class_1297)e, (byte)60);
            e.method_31472();
        }));
    }

    protected void spawnMonster(Caster<?> source, class_243 pos, class_1299<? extends class_1309> type) {
        class_1309 minion = (class_1309)type.method_5883(source.asWorld());
        if (!source.subtractEnergyCost(3.0)) {
            this.setDead();
        }
        minion.method_5641(pos.field_1352, pos.field_1351, pos.field_1350, 0.0f, 0.0f);
        minion.method_18800(0.0, 0.3, 0.0);
        source.asWorld().method_20290(2006, minion.method_24515(), 0);
        source.playSound(USounds.SPELL_NECROMANCY_ACTIVATE, 1.0f, 0.3f);
        source.spawnParticles((class_2394)class_2398.field_11237, 10);
        int level = source.getLevel().get();
        float levelSqr = class_3532.method_15340((int)(level * level), (int)0, (int)source.getLevel().getMax());
        float powerScale = levelSqr / (float)source.getLevel().getMax();
        for (int i = source.asWorld().field_9229.method_43048(GEAR.length); i < GEAR.length; ++i) {
            class_1799 pick = GEAR[i][(int)(powerScale * (float)GEAR[i].length) % GEAR[i].length].method_7854();
            minion.method_5673(minion.method_32326(pick), pick);
            if (source.asWorld().field_9229.method_43057() > powerScale) break;
        }
        Equine.of(minion).filter(eq -> eq instanceof Creature).ifPresent(eq -> {
            ((Creature)eq).setMaster(source);
            if (source.asWorld().field_9229.method_43057() < source.getCorruption().getScaled(1.0f)) {
                ((Creature)eq).setDiscorded(true);
            }
        });
        source.asWorld().method_8649((class_1297)minion);
        this.summonedEntities.add(new EntityReference<class_1309>(minion));
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10569("spawnCountdown", this.spawnCountdown);
        if (this.summonedEntities.size() > 0) {
            class_2499 list = new class_2499();
            this.summonedEntities.forEach(ref -> list.add((Object)ref.toNBT(lookup)));
            compound.method_10566("summonedEntities", (class_2520)list);
        }
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.spawnCountdown = compound.method_10550("spawnCountdown");
        this.summonedEntities.clear();
        if (compound.method_10545("summonedEntities")) {
            compound.method_10554("summonedEntities", 10).forEach(tag -> this.summonedEntities.add(new EntityReference((class_2487)tag, lookup)));
        }
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3965 hit) {
        if (!(projectile instanceof MagicBeamEntity)) {
            return;
        }
        MagicBeamEntity source = (MagicBeamEntity)projectile;
        Sphere affectRegion = new Sphere(false, 3.0);
        for (int i = 0; i < 10; ++i) {
            class_243 pos = affectRegion.computePoint(source.asWorld().field_9229).method_1019(source.getOriginVector());
            class_2338 loc = class_2338.method_49638((class_2374)pos);
            if (!source.asWorld().method_22347(loc.method_10084()) || source.asWorld().method_22347(loc)) continue;
            this.spawnPool.get().ifPresent(type -> this.spawnMonster(source, pos, (class_1299<? extends class_1309>)type));
        }
        this.summonedEntities.clear();
    }

    @Override
    public void onImpact(MagicProjectileEntity projectile, class_3966 hit) {
        NECROMANTIC_CONVERSIONS.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(hit.method_17782())).findFirst().ifPresent(entry -> {
            class_1308 newEntity = ((class_1308)hit.method_17782()).method_29243((class_1299)entry.getValue(), true);
            if (newEntity != null) {
                newEntity.method_6092(new class_1293(class_1294.field_5916, 200, 0));
            }
        });
    }
}

