/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractAreaEffectSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Situation;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttribute;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.SpellAttributeType;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.entity.damage.MagicalDamageSource;
import com.minelittlepony.unicopia.entity.damage.UDamageTypes;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import com.minelittlepony.unicopia.particle.FollowingParticleEffect;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.particle.UParticles;
import com.minelittlepony.unicopia.util.VecHelper;
import com.minelittlepony.unicopia.util.shape.Sphere;
import it.unimi.dsi.fastutil.floats.Float2ObjectFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class SiphoningSpell
extends AbstractAreaEffectSpell {
    static final int ANGER_TICKS = 100;
    static final int PASSIVE_TICKS = -20;
    static final Predicate<class_1297> TARGET_PREDICATE = class_1301.field_6156.and(class_1301.field_6157);
    static final SpellAttribute<Boolean> INVERTED = SpellAttribute.createConditional(SpellAttributeType.INVERTED, Trait.DARKNESS, (Float2ObjectFunction<Boolean>)((Float2ObjectFunction)darkness -> darkness > 0.0f));
    static final TooltipFactory TOOLTIP = TooltipFactory.of(RANGE, INVERTED);
    private final DataTracker.Entry<Boolean> upset;
    private int ticksUpset;

    protected SiphoningSpell(CustomisedSpellType<?> type) {
        super(type);
        this.upset = this.dataTracker.startTracking(TrackableDataType.BOOLEAN, false);
        this.ticksUpset = -20;
    }

    @Override
    public Affinity getAffinity() {
        return INVERTED.get(this.getTraits()) != false ? Affinity.BAD : Affinity.GOOD;
    }

    @Override
    public boolean tick(Caster<?> source, Situation situation) {
        if (source.isClient()) {
            float radius = source.getLevel().getScaled(5.0f) + ((Float)RANGE.get(this.getTraits())).floatValue();
            int direction = this.isFriendlyTogether(source) ? 1 : -1;
            source.spawnParticles(new Sphere(true, radius, 1.0f, 0.0f, 1.0f), 1, pos -> {
                if (source.asWorld().method_22347(class_2338.method_49638((class_2374)pos))) {
                    pos = pos.method_1031(0.0, -1.5, 0.0);
                    double dist = pos.method_1022(source.getOriginVector());
                    class_243 velocity = pos.method_1020(source.getOriginVector()).method_1029().method_1021((double)direction * dist);
                    source.addParticle((class_2394)(direction == 1 && this.upset.get() != false ? class_2398.field_11231 : class_2398.field_11201), (class_243)pos, velocity);
                }
            });
        } else {
            if (this.ticksUpset > 0 && --this.ticksUpset <= 0) {
                this.upset.set(false);
                this.ticksUpset = -20;
            }
            if (source.asWorld().method_8510() % 10L != 0L) {
                return true;
            }
            if (this.isFriendlyTogether(source)) {
                this.distributeHealth(source);
            } else {
                this.collectHealth(source);
            }
        }
        return !this.isDead();
    }

    private Stream<class_1309> getTargets(Caster<?> source) {
        return VecHelper.findInRange(null, (class_1924)source.asWorld(), source.getOriginVector(), ((Float)RANGE.get(this.getTraits())).floatValue() + source.getLevel().getScaled(6.0f), TARGET_PREDICATE).stream().map(e -> (class_1309)e);
    }

    private void distributeHealth(Caster<?> source) {
        MagicalDamageSource damage = source.damageOf(UDamageTypes.LIFE_DRAINING, source);
        float[] collectedHealth = new float[1];
        ArrayList recipients = new ArrayList();
        List<class_1309> targets = this.getTargets(source).toList();
        targets.forEach(e -> {
            float maxHealthGain = e.method_6063() - e.method_6032();
            if (!source.subtractEnergyCost(0.2f + maxHealthGain)) {
                this.setDead();
            }
            if (e instanceof class_1588) {
                collectedHealth[0] = collectedHealth[0] + e.method_6032() / 4.0f;
                e.method_5643(damage, e.method_6032() / 4.0f);
                source.addParticle(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)e, 0.2f), source.getOriginVector(), class_243.field_1353);
            } else if (this.ticksUpset > 0 || maxHealthGain <= 0.0f) {
                if (source.asWorld().field_9229.method_43048(3000) == 0) {
                    this.setDead();
                } else if (++this.ticksUpset >= 0) {
                    this.ticksUpset = 100;
                    this.upset.set(true);
                    e.method_5643(damage, e.method_6032() / 4.0f);
                }
            } else {
                collectedHealth[0] = collectedHealth[0] + (maxHealthGain * 0.6f + source.getLevel().getScaled(e.method_6032()) / 2.0f);
                recipients.add(e);
            }
        });
        float perTargetHealth = collectedHealth[0] / (float)recipients.size();
        recipients.forEach(recipient -> {
            recipient.method_6025(perTargetHealth);
            source.addParticle(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)recipient, 0.2f), source.getOriginVector(), class_243.field_1353);
        });
    }

    private void collectHealth(Caster<?> source) {
        float maxHealthGain;
        @Nullable class_1309 owner = (class_1309)source.getMaster();
        float f = maxHealthGain = owner == null ? 0.0f : owner.method_6063() - owner.method_6032();
        if (maxHealthGain == 0.0f) {
            return;
        }
        List<class_1309> targets = this.getTargets(source).filter(e -> !source.isOwnerOrFriend((class_1297)e)).toList();
        if (targets.isEmpty()) {
            return;
        }
        float attackAmount = Math.max(maxHealthGain / (float)targets.size(), 0.5f);
        MagicalDamageSource damage = source.damageOf(UDamageTypes.LIFE_DRAINING, source);
        float healthGain = 0.0f;
        for (class_1309 e2 : targets) {
            float dealt = Math.min(e2.method_6032(), attackAmount);
            if (e2 instanceof class_1657) {
                class_1657 p = (class_1657)e2;
                Pony player = Pony.of(p);
                Race.Composite race = player.getCompositeRace();
                if (race.canCast()) {
                    dealt /= 2.0f;
                }
                if (race.canUseEarth()) {
                    dealt *= 2.0f;
                }
            }
            e2.method_5643((class_1282)damage, dealt);
            ParticleUtils.spawnParticles(new FollowingParticleEffect(UParticles.HEALTH_DRAIN, (class_1297)owner, 0.2f), (class_1297)e2, 1);
            healthGain += dealt;
        }
        owner.method_6025(healthGain);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10569("upset", this.ticksUpset);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        this.ticksUpset = compound.method_10550("upset");
        this.upset.set(this.ticksUpset > 0);
    }
}

