/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.effect;

import com.google.common.base.Suppliers;
import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractAreaEffectSpell;
import com.minelittlepony.unicopia.ability.magic.spell.ChangelingFeedingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.DispersableDisguiseSpell;
import com.minelittlepony.unicopia.ability.magic.spell.PlacementControlSpell;
import com.minelittlepony.unicopia.ability.magic.spell.RageAbilitySpell;
import com.minelittlepony.unicopia.ability.magic.spell.RainboomAbilitySpell;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.ThrowableSpell;
import com.minelittlepony.unicopia.ability.magic.spell.TimeControlAbilitySpell;
import com.minelittlepony.unicopia.ability.magic.spell.attribute.TooltipFactory;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AreaProtectionSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AttractiveSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.AwkwardSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.BubbleSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CatapultSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.ChillingBreathSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.ability.magic.spell.effect.DarkVortexSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.DispellEvilSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.DisperseIllusionSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.DisplacementSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.FeatherFallSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.FireBoltSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.FireSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.HydrophobicSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.IceSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.InfernoSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.LightSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.MimicSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.MindSwapSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.NecromancySpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.PortalSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.ScorchSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.ShieldSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SiphoningSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.TransformationSpell;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.item.EnchantableItem;
import com.minelittlepony.unicopia.item.GemstoneItem;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.util.RegistryUtils;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class SpellType<T extends Spell>
implements Affine,
SpellPredicate<T> {
    public static final class_2960 EMPTY_ID = Unicopia.id("none");
    public static final class_2378<SpellType<?>> REGISTRY = RegistryUtils.createSynced(Unicopia.id("spells"), EMPTY_ID.toString());
    public static final class_5321<? extends class_2378<SpellType<?>>> REGISTRY_KEY = REGISTRY.method_30517();
    public static final Codec<SpellType<?>> CODEC = REGISTRY.method_39673();
    public static final class_9139<class_9129, SpellType<?>> PACKET_CODEC = class_9135.method_56365(REGISTRY_KEY);
    public static final SpellType<?> EMPTY_KEY = SpellType.register(EMPTY_ID.method_12832(), SpellType.builder(t -> null).affinity(Affinity.NEUTRAL).color(0xFFFFFF).unobtainable());
    private static final DynamicCommandExceptionType UNKNOWN_SPELL_TYPE_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"spell_type.unknown", (Object[])new Object[]{id}));
    public static final SpellType<PlacementControlSpell> PLACE_CONTROL_SPELL = SpellType.register("place_controller", SpellType.builder(PlacementControlSpell::new).affinity(Affinity.NEUTRAL).unobtainable().stackable().shape(GemstoneItem.Shape.DONUT));
    public static final SpellType<ThrowableSpell> THROWN_SPELL = SpellType.register("thrown", SpellType.builder(ThrowableSpell::new).affinity(Affinity.NEUTRAL).unobtainable().shape(GemstoneItem.Shape.DONUT));
    public static final SpellType<DispersableDisguiseSpell> CHANGELING_DISGUISE = SpellType.register("disguise", SpellType.builder(DispersableDisguiseSpell::new).affinity(Affinity.BAD).color(1696910).unobtainable().shape(GemstoneItem.Shape.ARROW));
    public static final SpellType<ChangelingFeedingSpell> FEED = SpellType.register("feed", SpellType.builder(ChangelingFeedingSpell::new).affinity(Affinity.BAD).color(12434937).unobtainable().shape(GemstoneItem.Shape.ARROW));
    public static final SpellType<RainboomAbilitySpell> RAINBOOM = SpellType.register("rainboom", SpellType.builder(RainboomAbilitySpell::new).color(12434937).unobtainable().shape(GemstoneItem.Shape.ROCKET));
    public static final SpellType<RageAbilitySpell> RAGE = SpellType.register("rage", SpellType.builder(RageAbilitySpell::new).color(12434937).unobtainable().shape(GemstoneItem.Shape.FLAME));
    public static final SpellType<TimeControlAbilitySpell> TIME_CONTROL = SpellType.register("time_control", SpellType.builder(TimeControlAbilitySpell::new).color(12434937).unobtainable().shape(GemstoneItem.Shape.STAR));
    public static final SpellType<IceSpell> FROST = SpellType.register("frost", SpellType.builder(IceSpell::new).color(15383551).shape(GemstoneItem.Shape.TRIANGLE).traits(IceSpell.DEFAULT_TRAITS).tooltip(IceSpell.TOOLTIP));
    public static final SpellType<ChillingBreathSpell> CHILLING_BREATH = SpellType.register("chilling_breath", SpellType.builder(ChillingBreathSpell::new).affinity(Affinity.NEUTRAL).color(0xFFEAFF).shape(GemstoneItem.Shape.TRIANGLE).traits(ChillingBreathSpell.DEFAULT_TRAITS));
    public static final SpellType<ScorchSpell> SCORCH = SpellType.register("scorch", SpellType.builder(ScorchSpell::new).affinity(Affinity.BAD).color(16313375).stackable().shape(GemstoneItem.Shape.FLAME).traits(ScorchSpell.DEFAULT_TRAITS).tooltip(AbstractAreaEffectSpell.TOOLTIP));
    public static final SpellType<FireSpell> FLAME = SpellType.register("flame", SpellType.builder(FireSpell::new).color(0xFFBB99).shape(GemstoneItem.Shape.FLAME).traits(FireSpell.DEFAULT_TRAITS).tooltip(AbstractAreaEffectSpell.TOOLTIP));
    public static final SpellType<InfernoSpell> INFERNAL = SpellType.register("infernal", SpellType.builder(InfernoSpell::new).affinity(Affinity.BAD).color(0xFFAA00).shape(GemstoneItem.Shape.FLAME).traits(InfernoSpell.DEFAULT_TRAITS).tooltip(AbstractAreaEffectSpell.TOOLTIP));
    public static final SpellType<ShieldSpell> SHIELD = SpellType.register("shield", SpellType.builder(ShieldSpell::new).affinity(Affinity.NEUTRAL).color(6737322).shape(GemstoneItem.Shape.SHIELD).traits(ShieldSpell.DEFAULT_TRAITS).tooltip(ShieldSpell.TOOLTIP));
    public static final SpellType<AreaProtectionSpell> ARCANE_PROTECTION = SpellType.register("arcane_protection", SpellType.builder(AreaProtectionSpell::new).affinity(Affinity.BAD).color(10079658).shape(GemstoneItem.Shape.SHIELD).traits(AreaProtectionSpell.DEFAULT_TRAITS).tooltip(AreaProtectionSpell.TOOLTIP));
    public static final SpellType<AttractiveSpell> VORTEX = SpellType.register("vortex", SpellType.builder(AttractiveSpell::new).affinity(Affinity.NEUTRAL).color(16771720).shape(GemstoneItem.Shape.VORTEX).traits(AttractiveSpell.DEFAULT_TRAITS).tooltip(AttractiveSpell.TOOLTIP));
    public static final SpellType<DarkVortexSpell> DARK_VORTEX = SpellType.register("dark_vortex", SpellType.builder(DarkVortexSpell::new).affinity(Affinity.BAD).color(0xA33333).stackable().shape(GemstoneItem.Shape.VORTEX).traits(DarkVortexSpell.DEFAULT_TRAITS));
    public static final SpellType<NecromancySpell> NECROMANCY = SpellType.register("necromancy", SpellType.builder(NecromancySpell::new).affinity(Affinity.BAD).color(0xFA3A3A).shape(GemstoneItem.Shape.SKULL).tooltip(NecromancySpell.TOOLTIP));
    public static final SpellType<SiphoningSpell> SIPHONING = SpellType.register("siphoning", SpellType.builder(SiphoningSpell::new).affinity(Affinity.NEUTRAL).color(0xFFA3AA).shape(GemstoneItem.Shape.LAMBDA).tooltip(SiphoningSpell.TOOLTIP));
    public static final SpellType<DisperseIllusionSpell> REVEALING = SpellType.register("reveal", SpellType.builder(DisperseIllusionSpell::new).color(0xFFFFAF).shape(GemstoneItem.Shape.CROSS).tooltip(DisperseIllusionSpell.TOOLTIP));
    public static final SpellType<AwkwardSpell> AWKWARD = SpellType.register("awkward", SpellType.builder(AwkwardSpell::new).affinity(Affinity.NEUTRAL).color(3824127).shape(GemstoneItem.Shape.ICE));
    public static final SpellType<TransformationSpell> TRANSFORMATION = SpellType.register("transformation", SpellType.builder(TransformationSpell::new).color(1696910).shape(GemstoneItem.Shape.BRUSH));
    public static final SpellType<FeatherFallSpell> FEATHER_FALL = SpellType.register("feather_fall", SpellType.builder(FeatherFallSpell::new).color(61183).shape(GemstoneItem.Shape.LAMBDA).traits(FeatherFallSpell.DEFAULT_TRAITS).tooltip(FeatherFallSpell.TOOLTIP));
    public static final SpellType<CatapultSpell> CATAPULT = SpellType.register("catapult", SpellType.builder(CatapultSpell::new).color(0x22FF00).shape(GemstoneItem.Shape.ROCKET).traits(CatapultSpell.DEFAULT_TRAITS).tooltip(CatapultSpell.TOOLTIP));
    public static final SpellType<FireBoltSpell> FIRE_BOLT = SpellType.register("fire_bolt", SpellType.builder(FireBoltSpell::new).color(0xFF8811).shape(GemstoneItem.Shape.FLAME).traits(FireBoltSpell.DEFAULT_TRAITS).tooltip(FireBoltSpell.TOOLTIP));
    public static final SpellType<LightSpell> LIGHT = SpellType.register("light", SpellType.builder(LightSpell::new).color(0xEEFFAA).shape(GemstoneItem.Shape.STAR).traits(LightSpell.DEFAULT_TRAITS).tooltip(LightSpell.TOOLTIP));
    public static final SpellType<DisplacementSpell> DISPLACEMENT = SpellType.register("displacement", SpellType.builder(DisplacementSpell::new).affinity(Affinity.NEUTRAL).color(0x9900FF).stackable().shape(GemstoneItem.Shape.BRUSH).traits(PortalSpell.DEFAULT_TRAITS).tooltip(DisplacementSpell.TOOLTIP));
    public static final SpellType<PortalSpell> PORTAL = SpellType.register("portal", SpellType.builder(PortalSpell::new).color(0x99FFFF).shape(GemstoneItem.Shape.RING).traits(PortalSpell.DEFAULT_TRAITS));
    public static final SpellType<MimicSpell> MIMIC = SpellType.register("mimic", SpellType.builder(MimicSpell::new).color(0xFFFF00).shape(GemstoneItem.Shape.ARROW).tooltip(MimicSpell.TOOLTIP));
    public static final SpellType<MindSwapSpell> MIND_SWAP = SpellType.register("mind_swap", SpellType.builder(MindSwapSpell::new).affinity(Affinity.BAD).color(0xF9FF99).shape(GemstoneItem.Shape.WAVE).tooltip(MimicSpell.TOOLTIP));
    public static final SpellType<HydrophobicSpell> HYDROPHOBIC = SpellType.register("hydrophobic", SpellType.builder(s -> new HydrophobicSpell(s, (class_6862<class_3611>)class_3486.field_15517)).affinity(Affinity.NEUTRAL).color(0xF999FF).stackable().shape(GemstoneItem.Shape.ROCKET).tooltip(HydrophobicSpell.TOOLTIP));
    public static final SpellType<BubbleSpell> BUBBLE = SpellType.register("bubble", SpellType.builder(BubbleSpell::new).affinity(Affinity.NEUTRAL).color(0xF999FF).shape(GemstoneItem.Shape.DONUT).traits(BubbleSpell.DEFAULT_TRAITS).tooltip(BubbleSpell.TOOLTIP));
    public static final SpellType<DispellEvilSpell> DISPEL_EVIL = SpellType.register("dispel_evil", SpellType.builder(DispellEvilSpell::new).color(65280).shape(GemstoneItem.Shape.CROSS).traits(DispellEvilSpell.DEFAULT_TRAITS).tooltip(DispellEvilSpell.TOOLTIP));
    private final class_2960 id;
    private final Affinity affinity;
    private final int color;
    private final boolean obtainable;
    private final boolean stackable;
    private final GemstoneItem.Shape shape;
    private final Factory<T> factory;
    @Nullable
    private String translationKey;
    private final CustomisedSpellType<T> traited;
    private final SpellTraits traits;
    private final Supplier<class_1799> defaultStack;
    private final TooltipFactory tooltipFunction;

    public static void bootstrap() {
    }

    private SpellType(class_2960 id, Affinity affinity, int color, boolean obtainable, boolean stackable, GemstoneItem.Shape shape, SpellTraits traits, TooltipFactory tooltipFunction, Factory<T> factory) {
        this.id = id;
        this.affinity = affinity;
        this.color = color;
        this.obtainable = obtainable;
        this.shape = shape;
        this.tooltipFunction = tooltipFunction;
        this.factory = factory;
        this.traits = traits;
        this.stackable = stackable;
        this.traited = new CustomisedSpellType(this, traits, SpellTraits::empty);
        this.defaultStack = Suppliers.memoize(() -> EnchantableItem.enchant(UItems.GEMSTONE.method_7854(), this));
    }

    public boolean isObtainable() {
        return this.obtainable;
    }

    public boolean isStackable() {
        return this.stackable;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_1799 getDefualtStack() {
        return this.defaultStack.get();
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    public GemstoneItem.Shape getGemShape() {
        return this.shape;
    }

    public SpellTraits getTraits() {
        return this.traits;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = class_156.method_646((String)"spell", (class_2960)this.getId());
        }
        return this.translationKey;
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)this.getTranslationKey());
    }

    public CustomisedSpellType<T> withTraits() {
        return this.traited;
    }

    public CustomisedSpellType<T> withTraits(SpellTraits traits) {
        return traits.isEmpty() ? this.withTraits() : new CustomisedSpellType(this, traits, (Supplier<SpellTraits>)Suppliers.memoize(() -> traits.map((trait, value) -> Float.valueOf(value.floatValue() - this.getTraits().get((Trait)trait)))));
    }

    public Factory<T> getFactory() {
        return this.factory;
    }

    public TooltipFactory getTooltip() {
        return this.tooltipFunction;
    }

    @Override
    public boolean test(@Nullable Spell spell) {
        return spell != null && spell.getTypeAndTraits().type() == this;
    }

    public void toNbt(class_2487 tag) {
        tag.method_10582("effect_id", this.getId().toString());
    }

    public boolean isEmpty() {
        return this == EMPTY_KEY;
    }

    public String toString() {
        return "SpellType[" + this.getTranslationKey() + "]";
    }

    public static <T extends Spell> SpellType<T> register(String name, Builder<T> builder) {
        return SpellType.register(Unicopia.id(name), builder);
    }

    public static <T extends Spell> SpellType<T> register(class_2960 id, Builder<T> builder) {
        return (SpellType)class_2378.method_10230(REGISTRY, (class_2960)id, builder.build(id));
    }

    public static <T extends Spell> SpellType<T> empty() {
        return EMPTY_KEY;
    }

    public static <T extends Spell> SpellType<T> getKey(class_2487 tag) {
        return SpellType.getKey(class_2960.method_12829((String)tag.method_10558("effect_id")));
    }

    public static <T extends Spell> SpellType<T> getKey(@Nullable class_2960 id) {
        return REGISTRY.method_17966(id).orElse(EMPTY_KEY);
    }

    public static SpellType<?> fromArgument(CommandContext<class_2168> context, String name) throws CommandSyntaxException {
        class_2960 id = ((class_5321)context.getArgument(name, class_5321.class)).method_29177();
        return (SpellType)REGISTRY.method_17966(id).orElseThrow(() -> UNKNOWN_SPELL_TYPE_EXCEPTION.create((Object)id));
    }

    public static <T extends Spell> Builder<T> builder(Factory<T> factory) {
        return new Builder<T>(factory);
    }

    public static interface Factory<T extends Spell> {
        public T create(CustomisedSpellType<T> var1);
    }

    static class Builder<T extends Spell> {
        private final Factory<T> factory;
        private Affinity affinity = Affinity.GOOD;
        private int color;
        private boolean obtainable = true;
        private boolean stackable = false;
        private GemstoneItem.Shape shape = GemstoneItem.Shape.ROUND;
        private SpellTraits traits = SpellTraits.EMPTY;
        private TooltipFactory tooltipFunction = TooltipFactory.EMPTY;

        Builder(Factory<T> factory) {
            this.factory = factory;
        }

        public Builder<T> affinity(Affinity affinity) {
            this.affinity = affinity;
            return this;
        }

        public Builder<T> color(int color) {
            this.color = color;
            return this;
        }

        public Builder<T> unobtainable() {
            this.obtainable = false;
            return this;
        }

        public Builder<T> stackable() {
            this.stackable = true;
            return this;
        }

        public Builder<T> shape(GemstoneItem.Shape shape) {
            this.shape = shape;
            return this;
        }

        public Builder<T> traits(SpellTraits traits) {
            this.traits = traits;
            return this;
        }

        public Builder<T> tooltip(TooltipFactory tooltipFunction) {
            this.tooltipFunction = tooltipFunction;
            return this;
        }

        public SpellType<T> build(class_2960 id) {
            return new SpellType<T>(id, this.affinity, this.color, this.obtainable, this.stackable, this.shape, this.traits, this.tooltipFunction, this.factory);
        }
    }
}

