/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.trait;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.TraitGroup;
import com.minelittlepony.unicopia.command.CommandArgumentEnum;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_7485;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9285;

public enum Trait implements CommandArgumentEnum<Trait>
{
    STRENGTH(TraitGroup.NATURAL),
    FOCUS(TraitGroup.NATURAL),
    KNOWLEDGE(TraitGroup.NATURAL),
    LIFE(TraitGroup.NATURAL),
    POWER(TraitGroup.ELEMENTAL),
    EARTH(TraitGroup.ELEMENTAL),
    FIRE(TraitGroup.ELEMENTAL),
    ICE(TraitGroup.ELEMENTAL),
    WATER(TraitGroup.ELEMENTAL),
    AIR(TraitGroup.ELEMENTAL),
    ORDER(TraitGroup.MAGICAL),
    CHAOS(TraitGroup.MAGICAL),
    KINDNESS(TraitGroup.MAGICAL),
    HAPPINESS(TraitGroup.MAGICAL),
    GENEROSITY(TraitGroup.MAGICAL),
    DARKNESS(TraitGroup.DARKNESS),
    ROT(TraitGroup.DARKNESS),
    FAMINE(TraitGroup.DARKNESS),
    POISON(TraitGroup.DARKNESS),
    BLOOD(TraitGroup.DARKNESS);

    private static final Trait[] VALUES;
    private static final Map<class_2960, Trait> IDS;
    private static final class_3542.class_7292<Trait> NAME_CODEC;
    private static final Codec<Trait> ID_CODEC;
    public static final Codec<Trait> CODEC;
    public static final Codec<Set<Trait>> SET_CODEC;
    public static final class_9139<ByteBuf, Trait> PACKET_CODEC;
    private final class_2960 id = Unicopia.id(this.name().toLowerCase(Locale.ROOT));
    private final class_2960 sprite = Unicopia.id("textures/gui/trait/" + this.name().toLowerCase(Locale.ROOT) + ".png");
    private final TraitGroup group;
    private final class_2561 tooltip;
    private final class_2561 obfuscatedTooltip;
    private final List<class_2561> tooltipLines;

    private Trait(TraitGroup group) {
        this.group = group;
        class_124 corruptionColor = this.getGroup().getCorruption() < -0.01f ? class_124.field_1060 : (this.getGroup().getCorruption() > 0.25f ? class_124.field_1061 : class_124.field_1068);
        this.tooltipLines = List.of(class_2561.method_43469((String)"gui.unicopia.trait.group", (Object[])new Object[]{this.getGroup().name().toLowerCase(Locale.ROOT)}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43473(), class_2561.method_43473(), class_2561.method_43471((String)("trait." + this.getId().method_12836() + "." + this.getId().method_12832() + ".description")).method_27692(class_124.field_1080), class_2561.method_43473(), class_2561.method_43469((String)"gui.unicopia.trait.corruption", (Object[])new Object[]{class_9285.field_49329.format(this.getGroup().getCorruption())}).method_27695(new class_124[]{class_124.field_1056, corruptionColor}));
        class_5250 tooltipText = this.getName().method_27661();
        this.tooltipLines.forEach(line -> tooltipText.method_10852(line).method_27693("\n"));
        this.tooltip = tooltipText;
        this.obfuscatedTooltip = tooltipText.method_27661().method_27692(class_124.field_1051);
    }

    public class_2960 getId() {
        return this.id;
    }

    @Override
    public String method_15434() {
        return this.getId().method_12832();
    }

    public TraitGroup getGroup() {
        return this.group;
    }

    public class_2960 getSprite() {
        return this.sprite;
    }

    public class_2561 getName() {
        return class_2561.method_43469((String)"gui.unicopia.trait.label", (Object[])new Object[]{this.getShortName()}).method_27692(class_124.field_1054);
    }

    public class_2561 getShortName() {
        return class_2561.method_43471((String)("trait." + this.getId().method_12836() + "." + this.getId().method_12832() + ".name"));
    }

    public List<class_2561> getTooltipLines() {
        return this.tooltipLines;
    }

    public class_2561 getTooltip() {
        return this.tooltip;
    }

    public class_2561 getObfuscatedTooltip() {
        return this.obfuscatedTooltip;
    }

    public List<class_1792> getItems() {
        return SpellTraits.ITEMS.getOrDefault(this, List.of());
    }

    public static Collection<Trait> all() {
        return IDS.values();
    }

    public static Stream<Trait> fromNbt(class_2499 nbt) {
        return nbt.stream().map(class_2520::method_10714).map(Trait::of).flatMap(Optional::stream);
    }

    public static Optional<Trait> of(String name) {
        Trait trait = (Trait)NAME_CODEC.method_42633(name);
        if (trait == null) {
            return Optional.ofNullable(class_2960.method_12829((String)name)).map(IDS::get);
        }
        return Optional.ofNullable(trait);
    }

    public static class_7485<Trait> argument() {
        return new ArgumentType();
    }

    static {
        VALUES = Trait.values();
        IDS = Arrays.stream(Trait.values()).collect(Collectors.toMap(Trait::getId, Function.identity()));
        NAME_CODEC = class_3542.method_49454(Trait::values, n -> n.toLowerCase(Locale.ROOT));
        ID_CODEC = class_2960.field_25139.xmap(id -> IDS.get(id), Trait::getId);
        CODEC = Codec.xor(NAME_CODEC, ID_CODEC).xmap(Either::unwrap, Either::right);
        SET_CODEC = CODEC.listOf().xmap(l -> l.stream().distinct().collect(Collectors.toSet()), s -> s.stream().toList());
        PACKET_CODEC = class_9135.method_56375(i -> VALUES[i], Enum::ordinal);
    }

    public static class ArgumentType
    extends class_7485<Trait> {
        protected ArgumentType() {
            super(NAME_CODEC, Trait::values);
        }
    }
}

