/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability.magic.spell.trait;

import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.ability.magic.spell.trait.Trait;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgMarkTraitRead;
import com.minelittlepony.unicopia.network.MsgUnlockTraits;
import com.minelittlepony.unicopia.util.Copyable;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class TraitDiscovery
implements NbtSerialisable,
Copyable<TraitDiscovery> {
    private final Set<Trait> unreadTraits = new HashSet<Trait>();
    private final Set<Trait> traits = new HashSet<Trait>();
    private final Map<class_2960, SpellTraits> items = new HashMap<class_2960, SpellTraits>();
    private final Pony pony;

    public TraitDiscovery(Pony pony) {
        this.pony = pony;
    }

    public void clear() {
        this.unreadTraits.clear();
        this.items.clear();
        this.traits.clear();
        this.pony.sendUpdatePacket();
    }

    @Environment(value=EnvType.CLIENT)
    public void markRead(Trait trait) {
        Channel.MARK_TRAIT_READ.sendToServer((Object)new MsgMarkTraitRead(Set.of(trait)));
    }

    public void markRead(Set<Trait> traits) {
        if (this.unreadTraits.removeAll(traits)) {
            this.pony.sendUpdatePacket();
        }
    }

    public void unlock(class_1792 item) {
        if (item == class_1802.field_8162) {
            return;
        }
        SpellTraits traits = SpellTraits.of(item);
        this.items.put(class_7923.field_41178.method_10221((Object)item), traits);
        HashSet<Trait> newTraits = new HashSet<Trait>();
        traits.entries().forEach(e -> {
            if (this.traits.add((Trait)e.getKey())) {
                newTraits.add((Trait)e.getKey());
            }
        });
        this.unreadTraits.addAll(newTraits);
        this.pony.sendUpdatePacket();
        if (!newTraits.isEmpty()) {
            if (!this.pony.asWorld().field_9236) {
                Channel.UNLOCK_TRAITS.sendToPlayer((Object)new MsgUnlockTraits(newTraits), (class_3222)this.pony.asEntity());
            }
            UCriteria.TRAIT_DISCOVERED.trigger((class_1657)this.pony.asEntity());
        }
    }

    public SpellTraits getKnownTraits(class_1792 item) {
        return this.items.getOrDefault(class_7923.field_41178.method_10221((Object)item), SpellTraits.EMPTY);
    }

    public Stream<class_1792> getKnownItems(Trait trait) {
        return this.items.entrySet().stream().filter(entry -> ((SpellTraits)entry.getValue()).get(trait) > 0.0f).flatMap(entry -> class_7923.field_41178.method_17966((class_2960)entry.getKey()).stream());
    }

    public boolean isUnread() {
        return !this.unreadTraits.isEmpty();
    }

    public boolean isUnread(Trait trait) {
        return this.unreadTraits.contains(trait);
    }

    public boolean isKnown(Trait trait) {
        return this.traits.contains(trait);
    }

    public boolean isKnown(Collection<Trait> traits) {
        return traits.containsAll(traits);
    }

    @Environment(value=EnvType.CLIENT)
    public void appendTooltip(class_1799 stack, List<class_2561> tooltip) {
        SpellTraits.getEmbeddedTraits(stack).orElseGet(() -> this.getKnownTraits(stack.method_7909())).appendTooltip(tooltip);
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        class_2487 disco = new class_2487();
        this.items.forEach((key, val) -> disco.method_10566(key.toString(), (class_2520)val.toNbt()));
        compound.method_10566("items", (class_2520)disco);
        class_2499 a = new class_2499();
        this.traits.forEach(id -> a.add((Object)class_2519.method_23256((String)id.getId().toString())));
        compound.method_10566("traits", (class_2520)a);
        class_2499 b = new class_2499();
        this.unreadTraits.forEach(id -> b.add((Object)class_2519.method_23256((String)id.getId().toString())));
        compound.method_10566("unreadTraits", (class_2520)b);
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        this.clear();
        class_2487 disco = compound.method_10562("items");
        disco.method_10541().forEach(key -> Optional.ofNullable(class_2960.method_12829((String)key)).ifPresent(id -> this.loadTraits((class_2960)id, disco.method_10562(key)).filter(SpellTraits::isPresent).ifPresent(val -> this.items.put((class_2960)id, (SpellTraits)val))));
        Trait.fromNbt(compound.method_10554("traits", 8)).forEach(this.traits::add);
        Trait.fromNbt(compound.method_10554("unreadTraits", 8)).forEach(this.unreadTraits::add);
    }

    private Optional<SpellTraits> loadTraits(class_2960 itemId, class_2487 nbt) {
        if (!this.pony.isClient()) {
            return class_7923.field_41178.method_17966(itemId).flatMap(item -> Optional.of(SpellTraits.of(item))).filter(SpellTraits::isPresent).or(() -> SpellTraits.fromNbt(nbt));
        }
        return SpellTraits.fromNbt(nbt);
    }

    @Override
    public void copyFrom(TraitDiscovery old, boolean alive) {
        this.clear();
        this.unreadTraits.addAll(old.unreadTraits);
        this.traits.addAll(old.traits);
        this.items.putAll(old.items);
    }
}

