/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.block.state.StateUtil;
import com.minelittlepony.unicopia.entity.player.Pony;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2380;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class EdibleBlock
extends class_2380 {
    private static final List<EdibleBlock> REGISTRY = new ArrayList<EdibleBlock>();
    static final class_2746 TOP_NORTH_EAST = class_2746.method_11825((String)"top_north_east");
    static final class_2746 TOP_NORTH_WEST = class_2746.method_11825((String)"top_north_west");
    static final class_2746 TOP_SOUTH_EAST = class_2746.method_11825((String)"top_south_east");
    static final class_2746 TOP_SOUTH_WEST = class_2746.method_11825((String)"top_south_west");
    static final class_2746 BOTTOM_NORTH_EAST = class_2746.method_11825((String)"bottom_north_east");
    static final class_2746 BOTTOM_NORTH_WEST = class_2746.method_11825((String)"bottom_north_west");
    static final class_2746 BOTTOM_SOUTH_EAST = class_2746.method_11825((String)"bottom_south_east");
    static final class_2746 BOTTOM_SOUTH_WEST = class_2746.method_11825((String)"bottom_south_west");
    public static final class_2746[] SEGMENTS = new class_2746[]{BOTTOM_NORTH_WEST, BOTTOM_NORTH_EAST, BOTTOM_SOUTH_WEST, BOTTOM_SOUTH_EAST, TOP_NORTH_WEST, TOP_NORTH_EAST, TOP_SOUTH_WEST, TOP_SOUTH_EAST};
    private static final class_265[] SHAPES = new class_265[]{class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0), class_2248.method_9541((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), class_2248.method_9541((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0), class_2248.method_9541((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), class_2248.method_9541((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0), class_2248.method_9541((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final Function<class_2680, class_265> SHAPE_CACHE = class_156.method_34866(state -> {
        @Nullable class_265 shape = null;
        for (int i = 0; i < SEGMENTS.length; ++i) {
            if (!((Boolean)state.method_11654((class_2769)SEGMENTS[i])).booleanValue()) continue;
            shape = shape == null ? SHAPES[i] : class_259.method_1084((class_265)shape, (class_265)SHAPES[i]);
        }
        return shape == null ? class_259.method_1077() : shape.method_1097();
    });
    private final class_2960 baseBlock;
    private final class_2960 material;

    public static int rotate(class_2350.class_2351 axis, int index) {
        class_2350 x = ((index & 1) == 0 ? class_2350.field_11034 : class_2350.field_11039).method_35833(axis);
        class_2350 y = ((index & 4) == 0 ? class_2350.field_11033 : class_2350.field_11036).method_35833(axis);
        class_2350 z = ((index & 2) == 0 ? class_2350.field_11043 : class_2350.field_11035).method_35833(axis);
        return EdibleBlock.toIndex(x) | EdibleBlock.toIndex(y) | EdibleBlock.toIndex(z);
    }

    private static int toIndex(class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11048) {
            direction = direction.method_10153();
        }
        return direction.method_10171() == class_2350.class_2352.field_11056 ? EdibleBlock.getOffset(direction.method_10166()) : 0;
    }

    private static int getOffset(class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new MatchException(null, null);
            case class_2350.class_2351.field_11048 -> 1;
            case class_2350.class_2351.field_11051 -> 2;
            case class_2350.class_2351.field_11052 -> 4;
        };
    }

    static void bootstrap() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (!Pony.of(player).getSpecies().isEquine() || player.method_21823() && (!player.method_6047().method_7960() || !player.method_6079().method_7960())) {
                return class_1269.field_5811;
            }
            class_2338 pos = hitResult.method_17777();
            class_2680 state = world.method_8320(pos);
            for (EdibleBlock edibleBlock : REGISTRY) {
                class_1269 actionResult;
                class_2248 match = edibleBlock.getBaseBlock();
                if (match == class_2246.field_10124 || !state.method_27852(match)) continue;
                class_2680 copiedState = StateUtil.copyState(state, edibleBlock.method_9564());
                class_9062 result = copiedState.method_55780(player.method_5998(hand), world, player, hand, hitResult);
                if (result.method_55643()) {
                    return result.method_55645();
                }
                if (result != class_9062.field_47731 || hand != class_1268.field_5808 || !(actionResult = copiedState.method_55781(world, player, hitResult)).method_23665()) continue;
                return actionResult;
            }
            return class_1269.field_5811;
        });
    }

    public EdibleBlock(class_2960 baseBlock, class_2960 material, boolean register) {
        super(class_4970.class_2251.method_9630((class_4970)class_2246.field_10359));
        for (class_2746 segment : SEGMENTS) {
            this.method_9590((class_2680)this.method_9564().method_11657((class_2769)segment, (Comparable)Boolean.valueOf(true)));
        }
        this.baseBlock = baseBlock;
        this.material = material;
        if (register) {
            REGISTRY.add(this);
            FlammableBlockRegistry.getDefaultInstance().add((class_2248)this, 60, 20);
        }
    }

    public class_2248 getBaseBlock() {
        return (class_2248)class_7923.field_41175.method_10223(this.baseBlock);
    }

    public String method_9539() {
        return this.getBaseBlock().method_9539();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667((class_2769[])SEGMENTS);
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE_CACHE.apply(state);
    }

    @Deprecated
    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_7325()) {
            return class_9062.field_47733;
        }
        if (!stack.method_7960() && stack.method_31574((class_1792)class_7923.field_41178.method_10223(this.material))) {
            class_2746 segment = EdibleBlock.getHitCorner(hit, 1);
            if (!((Boolean)state.method_11654((class_2769)segment)).booleanValue()) {
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                if (!world.field_9236) {
                    if (SHAPE_CACHE.apply(state = (class_2680)state.method_11657((class_2769)segment, (Comparable)Boolean.valueOf(true))) == class_259.method_1077()) {
                        state = StateUtil.copyState(state, this.getBaseBlock().method_9564());
                    }
                    world.method_8501(pos, state);
                }
                world.method_45447(player, pos, this.method_9573(state).method_10598(), class_3419.field_15245);
                return class_9062.field_47728;
            }
            return class_9062.field_47733;
        }
        class_2746 corner = EdibleBlock.getHitCorner(hit, -1);
        if (!((Boolean)state.method_11654((class_2769)corner)).booleanValue()) {
            return class_9062.field_47731;
        }
        boolean usingHoe = stack.method_31573(class_3489.field_42613);
        if (!(usingHoe || (player.method_7337() || player.method_7344().method_7587()) && player.method_5715())) {
            return class_9062.field_47733;
        }
        if (!world.field_9236) {
            if (SHAPE_CACHE.apply(state = (class_2680)state.method_11657((class_2769)corner, (Comparable)Boolean.valueOf(false))) == class_259.method_1077()) {
                world.method_8650(pos, false);
            } else {
                world.method_8501(pos, state);
            }
        }
        if (usingHoe) {
            stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
            EdibleBlock.method_9577((class_1937)world, (class_2338)pos, (class_1799)((class_1792)class_7923.field_41178.method_10223(this.material)).method_7854());
            player.method_5783(USounds.Vanilla.field_14846, 1.0f, 1.0f);
        } else {
            player.method_5783(USounds.Vanilla.field_20614, 1.0f, 1.0f);
            if (world.field_9229.method_43048(10) == 0) {
                player.method_5783(USounds.Vanilla.field_19149, 1.0f, player.method_6017());
            }
            player.method_7344().method_7585(2, 1.3f);
        }
        return class_9062.field_47728;
    }

    static class_2746 getHitCorner(class_3965 hit, int direction) {
        class_243 pos = hit.method_17784().method_1019(class_243.method_24954((class_2382)hit.method_17780().method_10163()).method_1021((double)((float)direction * 0.001f)));
        class_2338 bPos = hit.method_17777();
        return SEGMENTS[4 * EdibleBlock.getIndex(pos.field_1351, bPos.method_10264()) + 2 * EdibleBlock.getIndex(pos.field_1350, bPos.method_10260()) + EdibleBlock.getIndex(pos.field_1352, bPos.method_10263())];
    }

    static int getIndex(double axisHit, int tile) {
        return Math.abs(axisHit -= (double)tile) > 0.5 ? 1 : 0;
    }
}

