/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.EarthPonyKickAbility;
import com.minelittlepony.unicopia.block.BlockConstructionUtils;
import com.minelittlepony.unicopia.block.TintedBlock;
import com.minelittlepony.unicopia.compat.seasons.FertilizableUtil;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.serialization.CodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class FruitBearingBlock
extends class_2397
implements TintedBlock,
EarthPonyKickAbility.Buckable,
class_2256 {
    public static final MapCodec<FruitBearingBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("overlay").forGetter(b -> b.overlay), (App)CodecUtils.supplierOf(class_7923.field_41175.method_39673()).fieldOf("fruit").forGetter(b -> b.fruit), (App)CodecUtils.supplierOf(class_1799.field_24671).fieldOf("rotten_fruit").forGetter(b -> b.rottenFruitSupplier), (App)class_2244.method_54096()).apply((Applicative)instance, FruitBearingBlock::new));
    public static final class_2758 AGE = class_2741.field_12517;
    public static final int MAX_AGE = 25;
    public static final class_2754<Stage> STAGE = class_2754.method_11850((String)"stage", Stage.class);
    public static final List<FruitBearingBlock> REGISTRY = new ArrayList<FruitBearingBlock>();
    protected final Supplier<class_2248> fruit;
    protected final Supplier<class_1799> rottenFruitSupplier;
    protected final int overlay;

    public FruitBearingBlock(int overlay, Supplier<class_2248> fruit, Supplier<class_1799> rottenFruitSupplier, class_4970.class_2251 settings) {
        super(settings.method_9640().method_22488().method_26235(BlockConstructionUtils::canSpawnOnLeaves).method_26243(BlockConstructionUtils::never).method_26245(BlockConstructionUtils::never));
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657(STAGE, (Comparable)((Object)Stage.IDLE)));
        this.overlay = overlay;
        this.fruit = fruit;
        this.rottenFruitSupplier = rottenFruitSupplier;
        FlammableBlockRegistry.getDefaultInstance().add((class_2248)this, 30, 60);
    }

    public MapCodec<? extends FruitBearingBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{STAGE}).method_11667(new class_2769[]{AGE});
    }

    public boolean method_9542(class_2680 state) {
        return true;
    }

    protected boolean shouldAdvance(class_5819 random) {
        return true;
    }

    public class_2680 getPlacedFruitState(class_5819 random) {
        return this.fruit.get().method_9564();
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9514(state, world, pos, random);
        if (this.method_42311(state) || ((Boolean)state.method_11654((class_2769)field_11200)).booleanValue()) {
            return;
        }
        if (world.method_22335(pos, 0) <= 8) {
            return;
        }
        if (!PosHelper.fastAny(pos, (p, f) -> !world.method_8320(p).method_26206((class_1922)world, p, f.method_10153()), PosHelper.ALL)) {
            return;
        }
        int steps = FertilizableUtil.getGrowthSteps(world, pos, state, random);
        class_2338 fruitPosition = pos.method_10074();
        while (steps-- > 0) {
            if (!this.shouldAdvance(random)) {
                return;
            }
            state = this.cycleStage(state);
            class_2680 fruitState = world.method_8320(fruitPosition);
            switch (((Stage)((Object)state.method_11654(STAGE))).ordinal()) {
                case 4: {
                    this.wither(state, (class_1937)world, pos, fruitPosition, fruitState);
                }
                case 3: {
                    if (fruitState.method_27852(this.fruit.get())) break;
                    state = this.withStage(state, Stage.IDLE);
                    break;
                }
                case 2: {
                    state = this.isPositionValidForFruit(state, pos) ? this.grow(state, (class_1937)world, pos, fruitPosition, fruitState, random) : this.withStage(state, Stage.IDLE);
                    break;
                }
            }
        }
        if (!state.equals(world.method_8320(pos))) {
            world.method_30092(pos, state, 3, 0);
        }
    }

    protected class_2680 withStage(class_2680 state, Stage stage) {
        return (class_2680)((class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657(STAGE, (Comparable)((Object)stage));
    }

    private class_2680 cycleStage(class_2680 state) {
        if ((Integer)(state = (class_2680)state.method_28493((class_2769)AGE)).method_11654((class_2769)AGE) == 0) {
            state = (class_2680)state.method_28493(STAGE);
        }
        return state;
    }

    protected class_2680 grow(class_2680 state, class_1937 world, class_2338 pos, class_2338 fruitPosition, class_2680 fruitState, class_5819 random) {
        if (world.method_22347(fruitPosition)) {
            world.method_8652(fruitPosition, this.getPlacedFruitState(random), 3);
            return this.withStage(state, Stage.BEARING);
        }
        if (!fruitState.method_27852(this.fruit.get())) {
            return this.withStage(state, Stage.IDLE);
        }
        return state;
    }

    protected void wither(class_2680 state, class_1937 world, class_2338 pos, class_2338 fruitPosition, class_2680 fruitState) {
        if (!fruitState.method_27852(this.fruit.get())) {
            if (world.field_9229.method_43048(2) == 0) {
                class_2248.method_9577((class_1937)world, (class_2338)fruitPosition, (class_1799)this.rottenFruitSupplier.get());
            } else {
                class_2248.method_9511((class_2680)fruitState, (class_1937)world, (class_2338)fruitPosition, (class_2586)(fruitState.method_31709() ? world.method_8321(fruitPosition) : null), null, (class_1799)class_1799.field_8037);
            }
            if (world.method_8650(fruitPosition, false)) {
                world.method_43276((class_6880)class_5712.field_28165, pos, class_5712.class_7397.method_43287((class_2680)fruitState));
            }
            class_2498 group = this.method_9573(state);
            world.method_8396(null, pos, USounds.ITEM_APPLE_ROT, class_3419.field_15245, group.method_10597(), group.method_10599());
        }
    }

    @Override
    public List<class_1799> onBucked(class_3218 world, class_2680 state, class_2338 pos) {
        class_2248 class_22482;
        world.method_8501(pos, (class_2680)((class_2680)state.method_11657(STAGE, (Comparable)((Object)Stage.IDLE))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)));
        pos = pos.method_10074();
        state = world.method_8320(pos);
        if (state.method_27852(this.fruit.get()) && (class_22482 = state.method_26204()) instanceof EarthPonyKickAbility.Buckable) {
            EarthPonyKickAbility.Buckable buckable = (EarthPonyKickAbility.Buckable)class_22482;
            return buckable.onBucked(world, state, pos);
        }
        return List.of();
    }

    @Override
    public int getTint(class_2680 state, @Nullable class_1920 world, @Nullable class_2338 pos, int foliageColor) {
        return TintedBlock.blend(foliageColor, this.overlay);
    }

    public boolean isPositionValidForFruit(class_2680 state, class_2338 pos) {
        return state.method_26190(pos) % 3L == 1L;
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return switch (((Stage)((Object)state.method_11654(STAGE))).ordinal()) {
            case 1 -> world.method_22347(pos.method_10074());
            default -> !world.method_8320(pos.method_10074()).method_27852(this.fruit.get());
        };
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return this.method_9651((class_4538)world, pos, state);
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        if ((Integer)(state = (class_2680)state.method_28493((class_2769)AGE)).method_11654((class_2769)AGE) == 0) {
            state = (class_2680)state.method_11657(STAGE, (Comparable)((Object)(switch (((Stage)((Object)state.method_11654(STAGE))).ordinal()) {
                case 0 -> Stage.FLOWERING;
                case 1 -> Stage.FRUITING;
                default -> Stage.FLOWERING;
            })));
        }
        if (state.method_11654(STAGE) == Stage.FRUITING && (Integer)state.method_11654((class_2769)AGE) == 0) {
            state = this.grow(state, (class_1937)world, pos, pos.method_10074(), world.method_8320(pos.method_10074()), random);
        }
        world.method_8501(pos, state);
    }

    public static enum Stage implements class_3542
    {
        IDLE,
        FLOWERING,
        FRUITING,
        BEARING,
        WITHERING;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

