/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.EquineContext;
import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.block.BlockEntityUtil;
import com.minelittlepony.unicopia.block.UBlockEntities;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import com.minelittlepony.unicopia.util.PosHelper;
import com.minelittlepony.unicopia.util.serialization.NbtSerialisable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2429;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5707;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class HiveBlock
extends class_2429
implements class_2343 {
    public static final MapCodec<HiveBlock> CODEC = HiveBlock.method_54094(HiveBlock::new);
    static final class_2746 AWAKE = class_2746.method_11825((String)"awake");
    static final class_2746 CONSUMING = class_2746.method_11825((String)"consuming");
    static final Collection<class_2746> PROPERTIES = field_11329.values();

    public HiveBlock(class_4970.class_2251 settings) {
        super(0.5f, settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)AWAKE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CONSUMING, (Comparable)Boolean.valueOf(false)));
        PROPERTIES.forEach(property -> this.method_9590((class_2680)this.method_9564().method_11657((class_2769)property, (Comparable)Boolean.valueOf(true))));
    }

    protected MapCodec<? extends HiveBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667((class_2769[])PROPERTIES.toArray(class_2769[]::new));
        builder.method_11667(new class_2769[]{AWAKE, CONSUMING});
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        super.method_9496(state, world, pos, random);
        if (random.method_43048(250) == 0) {
            world.method_45446(pos, USounds.BLOCK_CHITIN_AMBIENCE, class_3419.field_15245, 0.13f, 0.2f, true);
            for (int i = 0; i < 9; ++i) {
                world.method_8406((class_2394)(random.method_43048(2) == 0 ? class_2398.field_28803 : class_2398.field_22248), (double)pos.method_10263() + random.method_43058(), (double)pos.method_10264() + 1.1, (double)pos.method_10260() + random.method_43058(), random.method_43058() - 0.5, 0.0, random.method_43058() - 0.5);
            }
        }
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (((Boolean)state.method_11654((class_2769)CONSUMING)).booleanValue()) {
            return state;
        }
        boolean connected = !neighborState.method_26215();
        state = (class_2680)state.method_11657((class_2769)field_11329.get(direction), (Comparable)Boolean.valueOf(connected));
        if (!connected) {
            return (class_2680)state.method_11657((class_2769)AWAKE, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)CONSUMING)).booleanValue() || !((Boolean)state.method_11654((class_2769)AWAKE)).booleanValue()) {
            return;
        }
        for (Map.Entry property : field_11329.entrySet()) {
            if (((Boolean)state.method_11654((class_2769)property.getValue())).booleanValue()) continue;
            class_2338 neighborPos = pos.method_10093((class_2350)property.getKey());
            world.method_8501(neighborPos, UBlocks.CHITIN.method_9564());
            world.method_45447(null, neighborPos, USounds.Vanilla.field_14788, class_3419.field_15245);
            world.method_8396(null, neighborPos, USounds.BLOCK_CHITIN_AMBIENCE, class_3419.field_15245, 0.13f, 0.2f);
            for (int i = 0; i < 9; ++i) {
                ParticleUtils.spawnParticle((class_1937)world, (class_2394)(random.method_43048(2) == 0 ? class_2398.field_28803 : class_2398.field_22248), (double)neighborPos.method_10263() + random.method_43058(), (double)neighborPos.method_10264() + 1.1, (double)pos.method_10260() + random.method_43058(), random.method_43058() - 0.5, 0.0, random.method_43058() - 0.5);
            }
        }
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (EquineContext.of((class_1297)player).getCompositeRace().includes(Race.CHANGELING)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)CONSUMING, (Comparable)Boolean.valueOf(true)));
            if (!world.field_9236) {
                BlockEntityUtil.getOrCreateBlockEntity(world, pos, UBlockEntities.HIVE_STORAGE).ifPresent(data -> {
                    if (data.opening) {
                        data.opening = false;
                        data.closing = true;
                    } else {
                        data.opening = true;
                        data.closing = false;
                    }
                    data.tickNow = true;
                    data.method_5431();
                });
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, class_2338 sourcePos, boolean notify) {
        world.method_39279(pos, (class_2248)this, 15);
        super.method_9612(state, world, pos, sourceBlock, sourcePos, notify);
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return EquineContext.of(context).getCompositeRace().includes(Race.CHANGELING) ? class_259.method_1073() : super.method_9549(state, world, pos, context);
    }

    protected float method_9594(class_2680 state, class_1657 player, class_1922 world, class_2338 pos) {
        float delta = super.method_9594(state, player, world, pos);
        return delta *= Pony.of(player).getCompositeRace().includes(Race.CHANGELING) ? 2.0f : 1.0f;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return (Boolean)state.method_11654((class_2769)CONSUMING) != false ? new TileData(pos, state) : null;
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (!((Boolean)state.method_11654((class_2769)CONSUMING)).booleanValue()) {
            return null;
        }
        return BlockEntityUtil.checkType(type, UBlockEntities.HIVE_STORAGE, TileData::tick);
    }

    static class TileData
    extends class_2586
    implements class_5714.class_8513<Listener> {
        private final Map<class_2338, Entry> storedBlocks = new HashMap<class_2338, Entry>();
        private final List<Set<class_2338>> lastConsumed = new ArrayList<Set<class_2338>>();
        private boolean opening;
        private boolean closing;
        private boolean tickNow;
        private long lastTick;
        private final Listener listener;

        public TileData(class_2338 pos, class_2680 state) {
            super(UBlockEntities.HIVE_STORAGE, pos, state);
            this.listener = new Listener(pos);
        }

        public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
            this.opening = nbt.method_10577("opening");
            this.closing = nbt.method_10577("closing");
            this.storedBlocks.clear();
            NbtSerialisable.decode(Entry.MAP_CODEC, nbt.method_10580("storedBlocks"), lookup).ifPresent(this.storedBlocks::putAll);
        }

        protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
            nbt.method_10556("opening", this.opening);
            nbt.method_10556("closing", this.closing);
            nbt.method_10566("storedBlocks", NbtSerialisable.encode(Entry.MAP_CODEC, this.storedBlocks, lookup));
        }

        static void tick(class_1937 world, class_2338 pos, class_2680 state, TileData data) {
            if (data.tickNow || world.method_8510() > data.lastTick + 2L) {
                data.tickNow = false;
                data.lastTick = world.method_8510();
                if (data.closing) {
                    data.stepClosing(world, pos);
                    if (data.lastConsumed.isEmpty() && ((Boolean)state.method_11654((class_2769)CONSUMING)).booleanValue()) {
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)CONSUMING, (Comparable)Boolean.valueOf(false)));
                    }
                } else if (data.opening) {
                    data.stepOpening(world, pos);
                }
            }
        }

        private void stepOpening(class_1937 world, class_2338 pos) {
            if (this.lastConsumed.size() >= 4) {
                return;
            }
            HashSet consumed = new HashSet();
            for (class_2338 neighbor : this.lastConsumed.isEmpty() ? Set.of(pos) : this.lastConsumed.get(this.lastConsumed.size() - 1)) {
                if (!neighbor.equals((Object)pos) && (!this.storedBlocks.containsKey(neighbor) || !this.storedBlocks.get(neighbor).state().method_27852(UBlocks.CHITIN))) continue;
                PosHelper.adjacentNeighbours(neighbor).forEach(adjacent -> {
                    class_2680 s = world.method_8320(adjacent);
                    if (consumed.add(adjacent.method_10062()) && !this.storedBlocks.containsKey(adjacent)) {
                        class_2586 data = world.method_8321(adjacent);
                        this.storedBlocks.put(adjacent.method_10062(), new Entry(adjacent.method_10062(), s, data instanceof TileData ? Optional.empty() : Optional.ofNullable(data).map(d -> d.method_38243((class_7225.class_7874)world.method_30349()))));
                        if (s.method_27852(UBlocks.CHITIN)) {
                            world.method_22352(adjacent, false);
                        } else if (s.method_27852(UBlocks.HIVE)) {
                            world.method_8501(adjacent, (class_2680)s.method_11657((class_2769)CONSUMING, (Comparable)Boolean.valueOf(true)));
                            TileData next = BlockEntityUtil.getOrCreateBlockEntity(world, adjacent.method_10062(), UBlockEntities.HIVE_STORAGE).orElse(null);
                            if (next != null) {
                                next.opening = this.opening;
                                next.closing = this.closing;
                                next.tickNow = true;
                                next.method_5431();
                            }
                        }
                    }
                });
            }
            this.lastConsumed.add(consumed);
            this.method_5431();
        }

        private void stepClosing(class_1937 world, class_2338 pos) {
            if (this.lastConsumed.isEmpty()) {
                this.closing = false;
                this.method_5431();
                return;
            }
            for (class_2338 neighbor : this.lastConsumed.remove(this.lastConsumed.size() - 1)) {
                @Nullable Entry entry = this.storedBlocks.remove(neighbor);
                if (entry == null || entry.state().method_26215()) continue;
                if (world.method_8320(entry.pos()).method_27852(UBlocks.HIVE)) {
                    BlockEntityUtil.getOrCreateBlockEntity(world, entry.pos(), UBlockEntities.HIVE_STORAGE).ifPresent(data -> {
                        data.closing = this.closing;
                        data.opening = this.opening;
                        data.tickNow = true;
                        data.method_5431();
                    });
                    continue;
                }
                entry.restore(world);
            }
            this.method_5431();
        }

        public Listener getEventListener() {
            return this.listener;
        }

        class Listener
        implements class_5714 {
            private final class_5716 position;

            Listener(class_2338 pos) {
                this.position = new class_5707(pos);
            }

            public class_5716 method_32946() {
                return this.position;
            }

            public int method_32948() {
                return 15;
            }

            public boolean method_32947(class_3218 world, class_6880<class_5712> event, class_5712.class_7397 emitter, class_243 emitterPos) {
                if (this.isImportant(event) || EquinePredicates.IS_PLAYER.test(emitter.comp_713()) && !EquinePredicates.CHANGELING.test(emitter.comp_713())) {
                    TileData.this.closing = true;
                    TileData.this.method_5431();
                    return true;
                }
                return false;
            }

            private boolean isImportant(class_6880<class_5712> event) {
                return event == class_5712.field_28178 || event == class_5712.field_28727 || event == class_5712.field_38244;
            }
        }

        record Entry(class_2338 pos, class_2680 state, Optional<class_2487> data) {
            public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(Entry::pos), (App)class_2680.field_24734.fieldOf("state").forGetter(Entry::state), (App)class_2487.field_25128.optionalFieldOf("data").forGetter(Entry::data)).apply((Applicative)instance, Entry::new));
            public static final Codec<Map<class_2338, Entry>> MAP_CODEC = CODEC.listOf().xmap(entries -> entries.stream().collect(Collectors.toMap(Entry::pos, Function.identity())), entries -> entries.values().stream().toList());

            public void restore(class_1937 world) {
                if (world.method_22347(this.pos)) {
                    world.method_8501(this.pos, this.state);
                    this.data.map(nbt -> class_2586.method_11005((class_2338)this.pos, (class_2680)this.state, (class_2487)nbt, (class_7225.class_7874)world.method_30349())).ifPresent(arg_0 -> ((class_1937)world).method_8438(arg_0));
                }
            }
        }
    }
}

