/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.EarthPonyGrowAbility;
import com.minelittlepony.unicopia.block.ThornBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class ThornBudBlock
extends class_2248
implements EarthPonyGrowAbility.Growable,
class_2256 {
    public static final MapCodec<ThornBudBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2680.field_24734.fieldOf("branch_state").forGetter(b -> b.branchState), (App)class_2244.method_54096()).apply((Applicative)instance, ThornBudBlock::new));
    static final class_2753 FACING = class_2741.field_12525;
    static final int MAX_DISTANCE = 25;
    static final class_2758 DISTANCE = class_2758.method_11867((String)"distance", (int)0, (int)25);
    private final class_2680 branchState;

    public ThornBudBlock(class_2680 branchState, class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11033)).method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf(0)));
        this.branchState = branchState;
    }

    protected MapCodec<? extends ThornBudBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, DISTANCE});
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(50) == 0) {
            this.grow((class_1937)world, state, pos);
        }
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == state.method_11654((class_2769)FACING) && !neighborState.method_27852((class_2248)this) && !neighborState.method_27852(this.branchState.method_26204())) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    @Override
    public boolean grow(class_1937 world, class_2680 state, class_2338 pos) {
        if ((Integer)state.method_11654((class_2769)DISTANCE) >= 25) {
            return false;
        }
        return ThornBudBlock.pickGrowthDirection(world, state, pos).map(randomDirection -> {
            class_2338 p = pos.method_10093(randomDirection);
            if (!this.canReplace(world.method_8320(p))) {
                return false;
            }
            world.method_45447(null, pos, USounds.Vanilla.field_33433, class_3419.field_15245);
            world.method_8501(pos, (class_2680)((class_2680)((class_2680)this.branchState.method_11657((class_2769)FACING, (Comparable)((class_2350)state.method_11654((class_2769)FACING)))).method_11657((class_2769)ThornBlock.field_11329.get(state.method_11654((class_2769)FACING)), (Comparable)Boolean.valueOf(true))).method_11657((class_2769)ThornBlock.field_11329.get(randomDirection), (Comparable)Boolean.valueOf(true)));
            world.method_8501(p, (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)randomDirection.method_10153())).method_11657((class_2769)DISTANCE, (Comparable)Integer.valueOf((Integer)state.method_11654((class_2769)DISTANCE) + 1)));
            return true;
        }).orElse(false);
    }

    protected boolean canReplace(class_2680 state) {
        return state.method_45474();
    }

    private static Optional<class_2350> pickGrowthDirection(class_1937 world, class_2680 state, class_2338 pos) {
        class_2350 excluded = (class_2350)state.method_11654((class_2769)FACING);
        return class_156.method_40083(ThornBlock.field_11329.keySet().stream().filter(direction -> direction != excluded).flatMap(direction -> ThornBudBlock.getByWeight(direction, excluded)).toList(), (class_5819)world.method_8409());
    }

    private static Stream<class_2350> getByWeight(class_2350 input, class_2350 excluded) {
        return Stream.generate(() -> input).limit(input.method_10166() == excluded.method_10166() ? 6L : (input.method_10166() == class_2350.class_2351.field_11052 ? 1L : 3L));
    }

    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return true;
    }

    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        this.grow((class_1937)world, state, pos);
    }
}

