/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.cloud;

import com.minelittlepony.unicopia.EquineContext;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.block.cloud.CloudLike;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2244;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class CloudBlock
extends class_2248
implements CloudLike {
    private static final MapCodec<CloudBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("meltable").forGetter(b -> b.meltable), (App)class_2244.method_54096()).apply((Applicative)instance, CloudBlock::new));
    protected final boolean meltable;

    public CloudBlock(boolean meltable, class_4970.class_2251 settings) {
        super(CloudLike.applyCloudProperties(meltable ? settings.method_9640() : settings));
        this.meltable = meltable;
    }

    public MapCodec<? extends CloudBlock> method_53969() {
        return CODEC;
    }

    protected float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 0.9f;
    }

    protected boolean method_9579(class_2680 state, class_1922 world, class_2338 pos) {
        return true;
    }

    public void method_9502(class_1922 world, class_1297 entity) {
        boolean bounce = Math.abs(entity.method_18798().field_1351) > 0.3;
        super.method_9502(world, entity);
        if (bounce) {
            entity.method_5762(0.0, (double)0.2f, 0.0);
        }
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (world.field_9229.method_43048(150) == 0) {
            this.generateSurfaceParticles(world, state, pos, class_3726.method_16194(), 1);
        }
    }

    public void method_9554(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        entity.method_5747(fallDistance, 0.0f, world.method_48963().method_48827());
        this.generateSurfaceParticles(world, state, pos, class_3726.method_16194(), 9);
        if (!world.field_9236 && fallDistance > 7.0f) {
            world.method_22352(pos, true);
        }
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        if (world.field_9229.method_43048(15) == 0) {
            this.generateSurfaceParticles(world, state, pos, class_3726.method_16194(), 1);
        }
    }

    protected void generateSurfaceParticles(class_1937 world, class_2680 state, class_2338 pos, class_3726 context, int count) {
        class_265 shape = state.method_26201((class_1922)world, pos);
        class_5819 rng = world.field_9229;
        class_238 box = shape.method_1107();
        for (int i = 0; i < count; ++i) {
            world.method_8406((class_2394)class_2398.field_11204, (double)pos.method_10263() + class_3532.method_16436((double)rng.method_43057(), (double)box.field_1323, (double)box.field_1320), (double)pos.method_10264() + box.field_1325, (double)pos.method_10260() + class_3532.method_16436((double)rng.method_43057(), (double)box.field_1321, (double)box.field_1324), 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_11204, (double)pos.method_10263() + (rng.method_43056() ? box.field_1323 : box.field_1320), (double)pos.method_10264() + class_3532.method_16436((double)rng.method_43057(), (double)box.field_1322, (double)box.field_1325), (double)pos.method_10260() + class_3532.method_16436((double)rng.method_43057(), (double)box.field_1321, (double)box.field_1324), 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_11204, (double)pos.method_10263() + class_3532.method_16436((double)rng.method_43057(), (double)box.field_1323, (double)box.field_1320), (double)pos.method_10264() + class_3532.method_16436((double)rng.method_43057(), (double)box.field_1322, (double)box.field_1325), (double)pos.method_10260() + (rng.method_43056() ? box.field_1321 : box.field_1324), 0.0, 0.0, 0.0);
        }
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        float cloudWalking;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (player.method_31549().field_7479 || Pony.of(player).getPhysics().isFlying()) {
                return;
            }
        }
        if (entity.method_18798().field_1351 < 0.0 && (cloudWalking = EquineContext.of(entity).getCloudWalkingStrength()) > 0.0f) {
            entity.method_18799(entity.method_18798().method_18805(1.0, (double)(1.0f - cloudWalking), 1.0));
            entity.method_5762(0.0, 0.07, 0.0);
            entity.method_24830(true);
        }
        entity.method_18799(entity.method_18798().method_18805((double)0.9f, 1.0, (double)0.9f));
    }

    protected final class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        EquineContext equineContext = EquineContext.of(context);
        if (!this.canInteract(state, world, pos, equineContext)) {
            return class_259.method_1073();
        }
        return this.getOutlineShape(state, world, pos, context, equineContext);
    }

    protected final class_265 method_9571(class_2680 state, class_1922 world, class_2338 pos) {
        return this.getOutlineShape(state, world, pos, class_3726.method_16194(), EquineContext.ABSENT);
    }

    protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.field_23159 ? state.method_26172(world, pos, context) : class_259.method_1073();
    }

    @Nullable
    public final class_2680 method_9605(class_1750 context) {
        EquineContext equineContext = EquineContext.of((class_1838)context);
        if (!this.canInteract(this.method_9564(), (class_1922)context.method_8045(), context.method_8037(), equineContext)) {
            return null;
        }
        return this.getPlacementState(context, equineContext);
    }

    protected final boolean method_9616(class_2680 state, class_1750 context) {
        EquineContext equineContext = EquineContext.of((class_1838)context);
        if (this.canInteract(state, (class_1922)context.method_8045(), context.method_8037(), equineContext)) {
            return this.canReplace(state, context, equineContext);
        }
        return true;
    }

    protected boolean method_9522(class_2680 state, class_2680 stateFrom, class_2350 direction) {
        class_265 shape = state.method_26201((class_1922)class_2682.field_12294, class_2338.field_10980);
        class_265 shapeFrom = stateFrom.method_26201((class_1922)class_2682.field_12294, class_2338.field_10980);
        return !shape.method_1110() && !shapeFrom.method_1110() && class_259.method_1083((class_265)shape, (class_265)shapeFrom, (class_2350)direction);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return type != class_10.field_50 || !InteractionManager.getInstance().getPathingEquineContext().collidesWithClouds();
    }

    protected class_265 getOutlineShape(class_2680 state, class_1922 world, class_2338 pos, class_3726 context, EquineContext equineContext) {
        return class_259.method_1077();
    }

    protected boolean canInteract(class_2680 state, class_1922 world, class_2338 pos, EquineContext context) {
        return context.collidesWithClouds() || context.hasFeatherTouch();
    }

    protected boolean canReplace(class_2680 state, class_1750 context, EquineContext equineContext) {
        return super.method_9616(state, context);
    }

    @Nullable
    protected class_2680 getPlacementState(class_1750 placementContext, EquineContext equineContext) {
        return super.method_9605(placementContext);
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.meltable && world.method_8314(class_1944.field_9282, pos) > 11) {
            CloudBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
            world.method_8650(pos, false);
        }
    }
}

