/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.block.state;

import com.minelittlepony.unicopia.block.state.ReversableBlockStateConverter;
import com.minelittlepony.unicopia.block.state.StateMapLoader;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BlockStateConverter {
    public static Named of(class_2960 id) {
        return new Named(id);
    }

    public boolean canConvert(@Nullable class_2680 var1);

    @NotNull
    public Optional<class_2680> getConverted(class_1937 var1, @NotNull class_2680 var2);

    default public boolean convert(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        return this.canConvert(state) && this.getConverted(world, state).filter(newState -> {
            class_2338 other;
            if (state.equals(newState)) {
                return false;
            }
            if (!newState.method_28498((class_2769)class_2741.field_12533)) {
                world.method_8652(pos, newState, 18);
                return true;
            }
            boolean lower = newState.method_11654((class_2769)class_2741.field_12533) == class_2756.field_12607;
            class_2338 class_23382 = other = lower ? pos.method_10084() : pos.method_10074();
            if (world.method_8320(other).method_27852(state.method_26204())) {
                world.method_8652(other, (class_2680)newState.method_11657((class_2769)class_2741.field_12533, (Comparable)(lower ? class_2756.field_12609 : class_2756.field_12607)), 18);
                world.method_8652(pos, newState, 18);
                return true;
            }
            return false;
        }).isPresent();
    }

    public static sealed class Named
    implements ReversableBlockStateConverter {
        private final class_2960 id;
        private final ReversableBlockStateConverter inverse;

        public Named(class_2960 id) {
            this.id = id;
            this.inverse = new Inverted(this, this);
        }

        protected Named(Named inverse) {
            this.id = inverse.getId();
            this.inverse = inverse;
        }

        public class_2960 getId() {
            return this.id;
        }

        @Override
        public boolean canConvert(@Nullable class_2680 state) {
            return this.get().filter(map -> map.canConvert(state)).isPresent();
        }

        @Override
        public Optional<@NotNull class_2680> getConverted(class_1937 world, @NotNull class_2680 state) {
            return this.get().flatMap(map -> map.getConverted(world, state));
        }

        public Optional<ReversableBlockStateConverter> get() {
            return Optional.ofNullable(StateMapLoader.INSTANCE.converters.get(this.id));
        }

        @Override
        public ReversableBlockStateConverter getInverse() {
            return this.inverse;
        }

        private final class Inverted
        extends Named {
            private Inverted(Named named, Named inverse) {
                super(inverse);
            }

            @Override
            public Optional<ReversableBlockStateConverter> get() {
                return super.get().map(ReversableBlockStateConverter::getInverse);
            }
        }
    }
}

