/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.AbilityDispatcher;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.ActivationType;
import com.minelittlepony.unicopia.client.gui.UHud;
import com.minelittlepony.unicopia.entity.player.Pony;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4666;
import net.minecraft.class_6880;

public class KeyBindingsHandler {
    private static final String KEY_CATEGORY = "unicopia.category.name";
    public static final KeyBindingsHandler INSTANCE = new KeyBindingsHandler();
    private final Map<Binding, AbilitySlot> keys = new HashMap<Binding, AbilitySlot>();
    private final Map<AbilitySlot, Binding> reverse = new HashMap<AbilitySlot, Binding>();
    private final Binding pageDown = new Binding(this.create(267, "hud_page_dn"));
    private final Binding pageUp = new Binding(this.create(266, "hud_page_up"));
    private final class_304 singleTapModifier = this.createSticky(class_3675.field_16237.method_1444(), "ability_modifier_tap");
    private final class_304 doubleTapModifier = this.createSticky(class_3675.field_16237.method_1444(), "ability_modifier_double_tap");
    private final class_304 tripleTapModifier = this.createSticky(class_3675.field_16237.method_1444(), "ability_modifier_triple_tap");
    private final Set<class_304> pressed = new HashSet<class_304>();

    static void bootstrap() {
    }

    public KeyBindingsHandler() {
        this.addKeybind(82, AbilitySlot.PRIMARY);
        this.addKeybind(71, AbilitySlot.SECONDARY);
        this.addKeybind(86, AbilitySlot.TERTIARY);
    }

    public Binding getBinding(AbilitySlot slot) {
        return this.reverse.get((Object)slot);
    }

    public boolean isToggleMode() {
        return (Boolean)Unicopia.getConfig().toggleAbilityKeys.get();
    }

    public ActivationType getForcedActivationType() {
        if (this.singleTapModifier.method_1434()) {
            return ActivationType.TAP;
        }
        if (this.doubleTapModifier.method_1434()) {
            return ActivationType.DOUBLE_TAP;
        }
        if (this.tripleTapModifier.method_1434()) {
            return ActivationType.TRIPLE_TAP;
        }
        return ActivationType.NONE;
    }

    public void addKeybind(int code, AbilitySlot slot) {
        Binding binding = new Binding(this.createSticky(code, slot.name().toLowerCase(Locale.ROOT)));
        this.reverse.put(slot, binding);
        this.keys.put(binding, slot);
    }

    class_304 create(int code, String name) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.unicopia." + name, code, KEY_CATEGORY));
    }

    class_304 createSticky(int code, String name) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_4666("key.unicopia." + name, code, KEY_CATEGORY, this::isToggleMode));
    }

    public void tick(class_310 client) {
        if (client.field_1755 != null || client.field_1724 == null) {
            return;
        }
        Pony iplayer = Pony.of((class_1657)client.field_1724);
        AbilityDispatcher abilities = iplayer.getAbilities();
        int maxPage = abilities.getMaxPage();
        int page = class_3532.method_15340((int)((Integer)Unicopia.getConfig().hudPage.get()), (int)0, (int)maxPage);
        if (page > 0 && this.pageDown.getState() == PressedState.PRESSED) {
            this.changePage(client, maxPage, -1);
        } else if (page < maxPage && this.pageUp.getState() == PressedState.PRESSED) {
            this.changePage(client, maxPage, 1);
        } else if (!client.field_1724.method_7325()) {
            for (Binding i : this.keys.keySet()) {
                PressedState state;
                AbilitySlot slot = this.keys.get(i);
                if (slot == AbilitySlot.PRIMARY && client.field_1690.field_1832.method_1434() && abilities.isFilled(AbilitySlot.PASSIVE)) {
                    slot = AbilitySlot.PASSIVE;
                }
                if (slot == AbilitySlot.PRIMARY && !abilities.isFilled(slot)) {
                    slot = AbilitySlot.PASSIVE;
                }
                if ((state = i.getState()) != PressedState.UNCHANGED) {
                    if (state == PressedState.PRESSED) {
                        abilities.activate(slot, page).map(a -> a.getName(iplayer)).ifPresent(UHud.INSTANCE::setMessage);
                        continue;
                    }
                    abilities.clear(slot, ActivationType.NONE, page);
                    continue;
                }
                ActivationType type = i.getType();
                if (!type.isResult()) continue;
                abilities.clear(slot, type, page);
            }
        }
    }

    private void changePage(class_310 client, long max, int sigma) {
        int page = (Integer)Unicopia.getConfig().hudPage.get();
        Unicopia.getConfig().hudPage.set((Object)(page += sigma));
        Unicopia.getConfig().save();
        client.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)USounds.Vanilla.field_15015, (float)(1.75f + 0.25f * (float)sigma)));
        UHud.INSTANCE.setMessage((class_2561)class_2561.method_43469((String)"gui.unicopia.page_num", (Object[])new Object[]{page + 1, max + 1L}));
    }

    public class Binding {
        private final class_304 binding;
        private long nextPhaseTime;
        private final AtomicReference<ActivationType> type = new AtomicReference<ActivationType>(ActivationType.NONE);

        Binding(class_304 binding) {
            this.binding = binding;
        }

        public class_2561 getLabel() {
            return this.binding.method_16007();
        }

        public PressedState getState() {
            PressedState state = this.getNewState();
            long now = System.currentTimeMillis();
            if (state == PressedState.PRESSED) {
                this.nextPhaseTime = now + 200L;
            }
            if (state == PressedState.RELEASED && now < this.nextPhaseTime + 10L) {
                this.nextPhaseTime = now + 200L;
                this.type.set(this.type.get().getNext());
            }
            return state;
        }

        public ActivationType getType() {
            ActivationType t;
            if (this.binding.method_1434() && (t = KeyBindingsHandler.this.getForcedActivationType()).isResult()) {
                class_304.method_52231();
                return t;
            }
            if (!KeyBindingsHandler.this.isToggleMode() && System.currentTimeMillis() > this.nextPhaseTime - 70L) {
                return this.type.getAndSet(ActivationType.NONE);
            }
            return ActivationType.NONE;
        }

        private PressedState getNewState() {
            if (this.binding.method_1434()) {
                return KeyBindingsHandler.this.pressed.add(this.binding) ? PressedState.PRESSED : PressedState.UNCHANGED;
            }
            if (KeyBindingsHandler.this.pressed.remove(this.binding)) {
                return PressedState.RELEASED;
            }
            return PressedState.UNCHANGED;
        }
    }

    static enum PressedState {
        UNCHANGED,
        PRESSED,
        RELEASED;

    }
}

