/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client;

import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.event.ScreenInitCallback;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.ClientInteractionManager;
import com.minelittlepony.unicopia.client.KeyBindingsHandler;
import com.minelittlepony.unicopia.client.URenderers;
import com.minelittlepony.unicopia.client.gui.LanSettingsScreen;
import com.minelittlepony.unicopia.client.gui.ShapingBenchScreen;
import com.minelittlepony.unicopia.client.gui.UHud;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.shader.ViewportShader;
import com.minelittlepony.unicopia.client.render.spell.SpellEffectsRenderDispatcher;
import com.minelittlepony.unicopia.container.UScreenHandlers;
import com.minelittlepony.unicopia.entity.player.PlayerCamera;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.entity.player.SkinFeatures;
import com.minelittlepony.unicopia.network.handler.ClientNetworkHandlerImpl;
import com.minelittlepony.unicopia.server.world.ZapAppleStageStore;
import com.minelittlepony.unicopia.util.Lerp;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_364;
import net.minecraft.class_3929;
import net.minecraft.class_4184;
import net.minecraft.class_436;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class UnicopiaClient
implements ClientModInitializer {
    private static final class_2561 PROGRAMMER_ART_NAME = class_2561.method_43471((String)"resourcepack.unicopia.programmer_art");
    private static UnicopiaClient instance;
    public final Lerp tangentalSkyAngle = new Lerp(0.0f, true);
    public final Lerp skyAngle = new Lerp(0.0f, true);
    private ZapAppleStageStore.Stage zapAppleStage = ZapAppleStageStore.Stage.HIBERNATING;

    public static UnicopiaClient getInstance() {
        return instance;
    }

    @Nullable
    public static Pony getClientPony() {
        return Pony.of((class_1657)class_310.method_1551().field_1724);
    }

    public static PlayerCamera getCamera() {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && class_310.method_1551().field_1719 == player) {
            return Pony.of((class_1657)player).getCamera();
        }
        return PlayerCamera.DEFAULT;
    }

    public static class_243 getAdjustedSoundPosition(class_243 pos) {
        PlayerCamera cam = UnicopiaClient.getCamera();
        if (cam == PlayerCamera.DEFAULT) {
            return pos;
        }
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        Vector3f rotated = pos.method_1020(camera.method_19326()).method_46409();
        rotated = rotated.rotateAxis(cam.calculateRoll() * ((float)Math.PI / 180), 0.0f, 1.0f, 0.0f);
        return new class_243(rotated).method_1019(camera.method_19326());
    }

    public static Race getPreferredRace() {
        Race race;
        if (!((Boolean)Unicopia.getConfig().ignoreMineLP.get()).booleanValue() && class_310.method_1551().field_1724 != null && (race = MineLPDelegate.getInstance().getPlayerPonyRace()).isEquine()) {
            return race;
        }
        return (Race)Unicopia.getConfig().preferredRace.get();
    }

    public UnicopiaClient() {
        instance = this;
    }

    public void setZapAppleStage(ZapAppleStageStore.Stage stage) {
        this.zapAppleStage = stage;
    }

    public ZapAppleStageStore.Stage getZapAppleStage() {
        return this.zapAppleStage;
    }

    public float getSkyAngleDelta(float tickDelta) {
        if (class_310.method_1551().field_1687 == null) {
            return 0.0f;
        }
        float skyAngle = class_310.method_1551().field_1687.method_30274(tickDelta);
        this.skyAngle.update(skyAngle, 200L);
        return this.skyAngle.getValue() - skyAngle;
    }

    public void onInitializeClient() {
        new ClientInteractionManager();
        new ClientNetworkHandlerImpl();
        KeyBindingsHandler.bootstrap();
        URenderers.bootstrap();
        class_3929.method_17542(UScreenHandlers.SPELL_BOOK, SpellbookScreen::new);
        class_3929.method_17542(UScreenHandlers.SHAPING_BENCH, ShapingBenchScreen::new);
        Unicopia.getConfig().skinFeatures.onChanged(features -> {
            Pony pony = Pony.of((class_1657)class_310.method_1551().field_1724);
            if (pony != null) {
                pony.setSkinFeatures((SkinFeatures)features);
            }
        });
        Unicopia.getConfig().onChangedExternally(config -> {
            Pony pony = Pony.of((class_1657)class_310.method_1551().field_1724);
            if (pony != null) {
                pony.setSkinFeatures((SkinFeatures)Unicopia.getConfig().skinFeatures.get());
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        ClientTickEvents.END_WORLD_TICK.register(this::onWorldTick);
        ScreenInitCallback.EVENT.register(this::onScreenInit);
        FabricLoader.getInstance().getModContainer("unicopia").ifPresent(container -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)Unicopia.id("unicopia_programmer_art"), (ModContainer)container, (class_2561)PROGRAMMER_ART_NAME, (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ViewportShader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)SpellEffectsRenderDispatcher.INSTANCE);
    }

    private void onTick(class_310 client) {
        KeyBindingsHandler.INSTANCE.tick(client);
        UHud.INSTANCE.tick();
    }

    private void onWorldTick(class_638 world) {
    }

    private void onScreenInit(class_437 screen, ScreenInitCallback.ButtonList buttons) {
        if (screen instanceof class_436) {
            ((Button)buttons.addButton((class_364)new Button(screen.field_22789 / 2 - 155, 130, 150, 20))).onClick(b -> class_310.method_1551().method_1507((class_437)new LanSettingsScreen(screen))).getStyle().setText((class_2561)class_2561.method_43471((String)"unicopia.options.title"));
        }
    }
}

