/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.google.common.base.MoreObjects;
import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.AbstractDelegatingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.PlacementControlSpell;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.CustomisedSpellType;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.render.model.SphereModel;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgRemoveSpell;
import java.util.ArrayList;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7833;
import org.joml.Vector4f;

public class DismissSpellScreen
extends GameGui {
    private final Pony pony;
    private int relativeMouseX;
    private int relativeMouseY;

    public DismissSpellScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.unicopia.dismiss_spell"));
        this.pony = Pony.of((class_1657)class_310.method_1551().field_1724);
    }

    protected void method_25426() {
        double azimuth = 0.0;
        double ring = 2.0;
        ArrayList<PlacementControlSpell> placeableSpells = new ArrayList<PlacementControlSpell>();
        for (Spell spell : this.pony.getSpellSlot().stream().filter(SpellPredicate.IS_VISIBLE).toList()) {
            PlacementControlSpell placeable2;
            if (spell instanceof PlacementControlSpell && (placeable2 = (PlacementControlSpell)spell).getPosition().isPresent()) {
                placeableSpells.add(placeable2);
                continue;
            }
            this.method_37063(new Entry(spell).ofRadial(75.0 * ring - 25.0, azimuth));
            ring *= 1.0 + 0.03 / ring;
            azimuth += Math.PI / (8.0 * ring);
        }
        double minimalDistance = 75.0 * (ring - 1.0) - 25.0;
        class_243 origin = ((class_1657)this.pony.asEntity()).method_19538();
        placeableSpells.forEach(placeable -> placeable.getPosition().ifPresent(position -> {
            class_243 relativePos = position.method_1020(origin).method_18805(1.0, 0.0, 1.0);
            float yaw = this.field_22787.field_1773.method_19418().method_19330();
            class_243 cartesian = relativePos.method_1029().method_1021(minimalDistance + relativePos.method_37267()).method_1024((180.0f + yaw) * ((float)Math.PI / 180));
            this.method_37063(new Entry((Spell)placeable).ofCartesian(cartesian));
        }));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790 / 2, -267382768, -2146430960);
        context.method_25296(0, this.field_22790 / 2, this.field_22789, this.field_22790, -2146430960, -267382768);
        this.relativeMouseX = -this.field_22789 + mouseX * 2;
        this.relativeMouseY = -this.field_22790 + mouseY * 2;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(this.field_22789 - mouseX), (float)(this.field_22790 - mouseY), 0.0f);
        super.method_25394(context, mouseX, mouseY, delta);
        DrawableUtil.drawLine(matrices, 0, 0, this.relativeMouseX, this.relativeMouseY, -120);
        DrawableUtil.renderRaceIcon(context, this.pony.getObservedSpecies(), 0, 0, 16);
        matrices.method_22909();
        DrawableUtil.drawLine(matrices, mouseX, mouseY - 4, mouseX, mouseY + 4, -5570663);
        DrawableUtil.drawLine(matrices, mouseX - 4, mouseY, mouseX + 4, mouseY, -5570663);
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.0f, 300.0f);
        class_5250 cancel = class_2561.method_43471((String)"gui.unicopia.dispell_screen.cancel");
        context.method_51439(this.getFont(), (class_2561)cancel, (this.field_22789 - this.getFont().method_27525((class_5348)cancel)) / 2, this.field_22790 - 30, -1, true);
        matrices.method_22909();
    }

    public void method_52752(class_332 context) {
    }

    protected void method_57735(class_332 context) {
        DrawableUtil.drawArc(context.method_51448(), 40.0, 80.0, 0.0, Math.PI * 2, 16);
        DrawableUtil.drawArc(context.method_51448(), 160.0, 1600.0, 0.0, Math.PI * 2, 32);
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25422() {
        return true;
    }

    static void playClickEffect() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)USounds.Vanilla.field_15015.comp_349()), (float)6.0f, (float)0.3f));
    }

    static double squareDistance(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        return dx * dx + dy * dy;
    }

    class Entry
    extends Vector4f
    implements class_364,
    class_4068,
    class_6379 {
        private final Spell spell;
        private final Spell actualSpell;
        private boolean lastMouseOver;
        private final Vector4f copy = new Vector4f();

        public Entry(Spell spell) {
            this.spell = spell;
            this.actualSpell = this.getActualSpell();
        }

        public Entry ofRadial(double radius, double azimuth) {
            SphereModel.convertToCartesianCoord(this, radius, azimuth, azimuth);
            this.add(0.0f, -((float)radius) / 2.0f, 0.0f, 0.0f);
            return this;
        }

        public Entry ofCartesian(class_243 pos) {
            this.add((float)pos.field_1352, (float)pos.field_1350, (float)pos.field_1351, 1.0f);
            return this;
        }

        private Spell getActualSpell() {
            Spell spell;
            Spell spell2 = this.spell;
            if (spell2 instanceof AbstractDelegatingSpell) {
                AbstractDelegatingSpell s = (AbstractDelegatingSpell)spell2;
                spell = (Spell)MoreObjects.firstNonNull((Object)s.getDelegate(), (Object)s);
            } else {
                spell2 = this.spell;
                if (spell2 instanceof PlacementControlSpell) {
                    PlacementControlSpell s = (PlacementControlSpell)spell2;
                    spell = (Spell)MoreObjects.firstNonNull((Object)s.getDelegate(), (Object)s);
                } else {
                    spell = this.spell;
                }
            }
            return spell;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(DismissSpellScreen.this.relativeMouseX, DismissSpellScreen.this.relativeMouseY)) {
                DismissSpellScreen.this.method_37066(this);
                DismissSpellScreen.this.pony.getSpellSlot().removeIf(spell -> spell == this.spell);
                Channel.REMOVE_SPELL.sendToServer((Object)new MsgRemoveSpell(this.spell));
                DismissSpellScreen.playClickEffect();
                return true;
            }
            return false;
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return DismissSpellScreen.squareDistance(mouseX, mouseY, this.x, this.y) < 75.0;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
            class_4587 matrices = context.method_51448();
            CustomisedSpellType<?> type = this.actualSpell.getTypeAndTraits();
            this.copy.set((float)mouseX - (float)DismissSpellScreen.this.field_22789 * 0.5f - this.x * 0.5f, (float)mouseY - (float)DismissSpellScreen.this.field_22790 * 0.5f - this.y * 0.5f, 0.0f, 0.0f);
            DrawableUtil.drawLine(matrices, 0, 0, (int)this.x, (int)this.y, this.actualSpell.getAffinity().getColor().method_532());
            int color = type.type().getColor() << 2;
            matrices.method_22903();
            matrices.method_46416(this.x, this.y, 0.0f);
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40718.rotationDegrees(((float)class_310.method_1551().field_1724.field_6012 + tickDelta) * 2.0f % 360.0f));
            DrawableUtil.renderItemIcon(context, this.actualSpell.isDead() ? UItems.BOTCHED_GEM.method_7854() : type.getDefaultStack(), -8.0, -8.0, 1.0f);
            matrices.method_22909();
            boolean hovered = this.method_25405(DismissSpellScreen.this.relativeMouseX, DismissSpellScreen.this.relativeMouseY);
            double radius = hovered ? 9.0f + class_3532.method_15374((float)(((float)class_310.method_1551().field_1724.field_6012 + tickDelta) / 9.0f)) : 7.0f;
            DrawableUtil.drawArc(matrices, radius, radius + 1.0, 0.0, Math.PI * 2, color | 0x88);
            if (hovered) {
                DrawableUtil.drawArc(matrices, 0.0, 8.0, 0.0, Math.PI * 2, color | 0xFF);
                ArrayList<class_2561> tooltip = new ArrayList<class_2561>();
                class_5250 name = type.type().getName().method_27661();
                color = type.type().getColor();
                name.method_10862(name.method_10866().method_36139(color == 0 ? -5592406 : color));
                tooltip.add((class_2561)class_2561.method_43469((String)"gui.unicopia.dispell_screen.spell_type", (Object[])new Object[]{name}));
                type.traits().appendTooltip(tooltip);
                tooltip.add(class_5244.field_39003);
                type.method_57409(class_1792.class_9635.method_59528((class_1937)((DismissSpellScreen)DismissSpellScreen.this).field_22787.field_1687), tooltip::add, (class_1836)class_1836.field_41070);
                tooltip.add(class_5244.field_39003);
                Spell spell = this.spell;
                if (spell instanceof TimedSpell) {
                    TimedSpell timed = (TimedSpell)spell;
                    tooltip.add(class_5244.field_39003);
                    float tickRate = class_310.method_1551().field_1687.method_54719().method_54748();
                    tooltip.add((class_2561)class_2561.method_43469((String)"gui.unicopia.dispell_screen.time_left", (Object[])new Object[]{class_3544.method_15439((int)timed.getTimer().getTicksRemaining(), (float)tickRate)}));
                }
                tooltip.add(class_5244.field_39003);
                tooltip.add((class_2561)class_2561.method_43471((String)"gui.unicopia.dispell_screen.discard"));
                context.method_51434(DismissSpellScreen.this.getFont(), tooltip, 0, 0);
                if (!this.lastMouseOver) {
                    this.lastMouseOver = true;
                    DismissSpellScreen.playClickEffect();
                }
            } else {
                this.lastMouseOver = false;
            }
            matrices.method_22909();
        }

        public void method_37020(class_6382 builder) {
        }

        public class_6379.class_6380 method_37018() {
            return class_6379.class_6380.field_33785;
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25370() {
            return false;
        }
    }
}

