/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui;

import com.minelittlepony.unicopia.Race;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public interface DrawableUtil {
    public static final double PI = Math.PI;
    public static final double TAU = Math.PI * 2;
    public static final double NUM_RINGS = 300.0;
    public static final double INCREMENT = 0.020943951023931952;

    public static void drawScaledText(class_332 context, class_2561 text, int x, int y, float size, int color) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 0.0f);
        matrices.method_22905(size, size, 1.0f);
        context.method_51439(class_310.method_1551().field_1772, text, 0, 0, color, false);
        matrices.method_22909();
    }

    public static void renderItemIcon(class_332 context, class_1799 stack, double x, double y, float scale) {
        class_4587 modelStack = context.method_51448();
        modelStack.method_22903();
        modelStack.method_22904(x, y, 0.0);
        if (scale != 1.0f) {
            modelStack.method_22905(scale, scale, 1.0f);
        }
        context.method_51427(stack, 0, 0);
        modelStack.method_22909();
    }

    public static void renderRaceIcon(class_332 context, Race race, int x, int y, int size) {
        context.method_25291(race.getIcon(), x - size / 2, y - size / 2, 0, 0.0f, 0.0f, size, size, size, size);
    }

    public static void drawLine(class_4587 matrices, int x1, int y1, int x2, int y2, int color) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        Matrix4f matrix = matrices.method_23760().method_23761();
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, k);
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, k);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        RenderSystem.disableBlend();
    }

    public static void drawNotchedArc(class_4587 matrices, double innerRadius, double outerRadius, double startAngle, double arcAngle, double notchAngle, double notchSpacing, int color) {
        double endAngle = startAngle + arcAngle;
        for (double notchBegin = startAngle; notchBegin < endAngle; notchBegin += notchAngle + notchSpacing) {
            double notchEnd = Math.min(notchBegin + notchAngle, endAngle);
            if (notchEnd <= notchBegin) {
                return;
            }
            DrawableUtil.drawArc(matrices, innerRadius, outerRadius, notchBegin, notchEnd - notchBegin, color);
        }
    }

    public static void drawArc(class_4587 matrices, double innerRadius, double outerRadius, double startAngle, double arcAngle, int color) {
        if (Math.abs(arcAngle) < 0.020943951023931952) {
            return;
        }
        float r = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float b = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        arcAngle = Math.min(arcAngle, 6.262241356155655);
        double maxAngle = startAngle + arcAngle;
        Matrix4f model = matrices.method_23760().method_23761();
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        boolean shouldDraw = false;
        for (double angle = -startAngle; angle >= -maxAngle; angle -= 0.020943951023931952) {
            shouldDraw = true;
            DrawableUtil.cylendricalVertex(bufferBuilder, model, innerRadius, angle, r, g, b, k);
            DrawableUtil.cylendricalVertex(bufferBuilder, model, outerRadius, angle, r, g, b, k);
            DrawableUtil.cylendricalVertex(bufferBuilder, model, outerRadius, angle + 0.020943951023931952, r, g, b, k);
            DrawableUtil.cylendricalVertex(bufferBuilder, model, innerRadius, angle + 0.020943951023931952, r, g, b, k);
        }
        if (shouldDraw) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        }
    }

    private static void cylendricalVertex(class_287 bufferBuilder, Matrix4f model, double radius, double angle, float r, float g, float b, float k) {
        bufferBuilder.method_22918(model, (float)(radius * (double)class_3532.method_15374((float)((float)angle))), (float)(radius * (double)class_3532.method_15362((float)((float)angle))), 0.0f).method_22915(r, g, b, k).method_22914(2.0f, 2.0f, 2.0f);
    }
}

