/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook;

import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.gui.MagicText;
import com.minelittlepony.unicopia.client.gui.TribeButton;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookChapterList;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookCraftingPageContent;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.entity.player.ExperienceGroup;
import com.minelittlepony.unicopia.entity.player.MagicReserves;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.sollace.romanizer.api.Romanizer;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5348;

public class SpellbookProfilePageContent
implements SpellbookChapterList.Content {
    private static final class_2561 MANA_LABEL = class_2561.method_43471((String)"gui.unicopia.spellbook.page.mana");
    private final class_310 client = class_310.method_1551();
    private final Pony pony;
    private final class_327 font;
    private final SpellbookScreen screen;

    public SpellbookProfilePageContent(SpellbookScreen screen) {
        this.pony = Pony.of((class_1657)this.client.field_1724);
        this.font = this.client.field_1772;
        this.screen = screen;
    }

    @Override
    public void init(SpellbookScreen screen, class_2960 pageId) {
        Bounds bounds = screen.getFrameBounds();
        int size = 32;
        int x = screen.getX() + bounds.left + bounds.width / 4 - size + 5;
        int y = screen.getY() + bounds.top + bounds.height / 2 + 3;
        screen.method_37060(new SpellbookScreen.ImageButton(x, y, size, size)).getStyle().setIcon(TribeButton.createSprite(this.pony.getSpecies(), 0, 0, size)).setTooltip(() -> List.of(class_2561.method_43470((String)String.format("Level %d ", this.pony.getLevel().get() + 1)).method_10852(this.pony.getSpecies().getDisplayName()).method_27692(this.pony.getSpecies().getAffinity().getColor()), class_2561.method_43470((String)String.format("Mana: %d%%", (int)(this.pony.getMagicalReserves().getMana().getPercentFill() * 100.0f))), class_2561.method_43470((String)String.format("Corruption: %s%d%%", this.pony.getCorruptionhandler().hasCorruptingMagic() ? "^" : "", (int)this.pony.getCorruption().getScaled(100.0f))), class_2561.method_43470((String)String.format("Experience: %d", (int)(this.pony.getMagicalReserves().getXp().getPercentFill() * 100.0f))), class_2561.method_43470((String)String.format("Next level in: %dxp", 100 - (int)(this.pony.getMagicalReserves().getXp().getPercentFill() * 100.0f)))));
        Race inherited = this.pony.getCompositeRace().collapsed();
        if (inherited != this.pony.getSpecies()) {
            int halfSize = size / 2;
            screen.method_37060(new SpellbookScreen.ImageButton(x + halfSize, y + halfSize, halfSize, halfSize)).getStyle().setIcon(TribeButton.createSprite(inherited, 0, 0, halfSize));
        }
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, IViewRoot container) {
        int y = 20;
        float tickDelta = this.client.method_60646().method_60637(false);
        float delta = (float)((class_1657)this.pony.asEntity()).field_6012 + tickDelta;
        int currentLevel = this.pony.getLevel().get();
        float currentScaledLevel = this.pony.getLevel().getScaled(1.0f);
        float currentCorruption = this.pony.getCorruption().getScaled(1.0f);
        DrawableUtil.drawScaledText(context, ((class_1657)this.pony.asEntity()).method_5477(), 30, y, 1.3f, MagicText.getColor());
        DrawableUtil.drawScaledText(context, ExperienceGroup.forLevel(currentScaledLevel, currentCorruption), 30, y + 13, 0.8f, class_5253.class_5254.method_48780((float)currentCorruption, (int)class_5253.class_5254.method_48780((float)currentScaledLevel, (int)-1442823937, (int)-1432311232), (int)-1426128896));
        MagicReserves reserves = this.pony.getMagicalReserves();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(this.screen.getBackgroundWidth() / 2 + 30 - 10), (float)y, 0.0f);
        matrices.method_22905(1.3f, 1.3f, 1.0f);
        context.method_51439(this.font, SpellbookCraftingPageContent.INVENTORY_TITLE, 0, 0, MagicText.getColor(), false);
        matrices.method_22909();
        Bounds bounds = this.screen.getFrameBounds();
        matrices.method_22903();
        matrices.method_46416((float)(bounds.left + bounds.width / 4 - 10), (float)(bounds.top + bounds.height / 2 + 20), 0.0f);
        double growth = class_3532.method_15374((float)(delta / 9.0f)) * 2.0f;
        double radius = 40.0 + growth;
        float xpPercentage = reserves.getXp().getPercentFill(tickDelta);
        float manaPercentage = reserves.getMana().getPercentFill(tickDelta);
        float alphaF = (class_3532.method_15374((float)(delta / 9.0f)) + 1.0f) / 2.0f;
        int alpha = (int)(alphaF * 16.0f) & 0xFF;
        int color = 0x10404000 | alpha;
        int xpColor = 0xAA0040FF | ((int)((0.3f + 0.7f * xpPercentage) * 255.0f) & 0xFF) << 16;
        int manaColor = -16715712;
        if (this.pony.getSpellSlot().get(SpellPredicate.IS_CORRUPTING).isPresent()) {
            manaColor = class_5253.class_5254.method_48780((float)Math.abs(class_3532.method_15374((float)((float)((class_1657)this.pony.asEntity()).field_6012 / 15.0f))), (int)manaColor, (int)-16764688);
        }
        manaColor |= (int)((0.3f + 0.7f * alphaF) * 64.0f) << 16;
        DrawableUtil.drawArc(matrices, 0.0, radius + 24.0, 0.0, Math.PI * 2, color);
        DrawableUtil.drawArc(matrices, radius / 3.0, radius + 6.0, 0.0, Math.PI * 2, color);
        if (currentLevel >= this.pony.getLevel().getMax()) {
            int rayCount = 6;
            float raySeparation = (float)Math.PI * 2 / (float)rayCount;
            float rotate = delta / 120.0f % ((float)Math.PI * 2 / (float)(rayCount / 2));
            growth = class_3532.method_15374((float)(delta / 10.0f)) * 2.0f;
            int bandAColor = class_5253.class_5254.method_48780((float)currentCorruption, (int)-1426085280, (int)-16777168);
            int bandBColor = class_5253.class_5254.method_48780((float)currentCorruption, (int)-192, (int)32);
            float glowSize = class_5253.class_5254.method_48780((float)currentCorruption, (int)8, (int)-8);
            for (int i = 0; i < rayCount; ++i) {
                double rad = (radius + (double)glowSize) * (double)0.8f + growth - (double)(i % 2 * 5);
                float rot = (rotate + raySeparation * (float)i) % ((float)Math.PI * 2);
                DrawableUtil.drawArc(matrices, 0.0, rad, rot, 0.2f, bandAColor);
                DrawableUtil.drawArc(matrices, 0.0, rad + (double)0.3f, rot + 0.37f, 0.25, bandBColor);
            }
        }
        DrawableUtil.drawArc(matrices, radius / 3.0, radius + 6.0, 0.0, (double)xpPercentage * (Math.PI * 2), xpColor);
        DrawableUtil.drawArc(matrices, radius += 8.0, radius + 6.0 + growth, 0.0, (double)manaPercentage * (Math.PI * 2), manaColor);
        String manaString = (int)reserves.getMana().get() + "/" + (int)reserves.getMana().getMax();
        y = 15;
        context.method_51439(this.font, MANA_LABEL, -this.font.method_27525((class_5348)MANA_LABEL) / 2, y, -12566464, false);
        int n = -this.font.method_1727(manaString) / 2;
        Objects.requireNonNull(this.font);
        context.method_51433(this.font, manaString, n, y += 9, -12566464, false);
        class_5250 levelString = class_2561.method_43470((String)Romanizer.romanize((Number)(currentLevel + 1)));
        matrices.method_46416((float)(-this.font.method_27525((class_5348)levelString)), -35.0f, 0.0f);
        matrices.method_22905(2.0f, 2.0f, 1.0f);
        context.method_51439(this.font, (class_2561)levelString, 0, 0, -12566464, false);
        matrices.method_22909();
        matrices.method_22903();
        matrices.method_46416((float)(-this.screen.getX()), (float)(-this.screen.getY()), 0.0f);
        this.screen.drawSlots(context, mouseX, mouseY, 0.0f);
        matrices.method_22909();
    }

    static void drawBar(class_332 context, int x, int y, float value, int color) {
        int barWidth = 40;
        int midpoint = x + (int)((float)barWidth * value);
        context.method_25294(x, y, midpoint, y + 5, -5570561);
        context.method_25294(midpoint, y, x + barWidth, y + 5, color);
    }
}

