/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.gui.spellbook.element;

import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.unicopia.client.gui.DrawableUtil;
import com.minelittlepony.unicopia.client.gui.MagicText;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookChapterList;
import com.minelittlepony.unicopia.client.gui.spellbook.SpellbookScreen;
import com.minelittlepony.unicopia.client.gui.spellbook.element.PageElement;
import com.minelittlepony.unicopia.client.gui.spellbook.element.Panel;
import com.minelittlepony.unicopia.client.gui.spellbook.element.TextBlock;
import com.minelittlepony.unicopia.container.SpellbookState;
import com.minelittlepony.unicopia.container.spellbook.Flow;
import com.minelittlepony.unicopia.entity.player.Pony;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8824;

public class DynamicContent
implements SpellbookChapterList.Content {
    private static final class_2561 UNKNOWN = class_2561.method_30163((String)"???");
    private SpellbookState.PageState state = new SpellbookState.PageState();
    private final List<Page> pages;
    private Bounds bounds = Bounds.empty();
    private final Panel leftPanel = new Panel(this);
    private final Panel rightPanel = new Panel(this);

    public DynamicContent(class_2540 buffer) {
        this.pages = buffer.method_34066(x$0 -> new Page(this, (class_2540)x$0));
    }

    @Override
    public void draw(class_332 context, int mouseX, int mouseY, IViewRoot container) {
        int pageIndex = this.state.getOffset() * 2;
        class_310 client = class_310.method_1551();
        class_5250 pageText = class_2561.method_43469((String)"%s/%s", (Object[])new Object[]{pageIndex / 2 + 1, (int)Math.ceil((float)this.pages.size() / 2.0f)});
        context.method_51439(client.field_1772, (class_2561)pageText, (int)(337.0f - (float)client.field_1772.method_27525((class_5348)pageText) / 2.0f), 190, MagicText.getColor(), false);
    }

    @Override
    public void copyStateFrom(SpellbookChapterList.Content old) {
        if (old instanceof DynamicContent) {
            DynamicContent o = (DynamicContent)old;
            if (this.state.getOffset() == o.state.getOffset()) {
                this.leftPanel.verticalScrollbar.getScrubber().scrollTo(o.leftPanel.verticalScrollbar.getScrubber().getPosition(), false);
                this.rightPanel.verticalScrollbar.getScrubber().scrollTo(o.rightPanel.verticalScrollbar.getScrubber().getPosition(), false);
            }
            this.state = o.state;
            this.setBounds(o.bounds);
        }
    }

    Optional<Page> getPage(int index) {
        if (index < 0 || index >= this.pages.size()) {
            return Optional.empty();
        }
        return Optional.of(this.pages.get(index));
    }

    private void setBounds(Bounds bounds) {
        this.bounds = bounds;
        this.pages.forEach(page -> {
            page.reset();
            int oldHeight = page.bounds.height;
            page.bounds.copy(bounds);
            page.bounds.left = 0;
            page.bounds.top = 0;
            page.bounds.width /= 2;
            page.bounds.height = oldHeight;
        });
        this.leftPanel.setBounds(bounds);
    }

    @Override
    public void init(SpellbookScreen screen, class_2960 pageId) {
        this.state = screen.getState().getState(pageId);
        this.setBounds(screen.getFrameBounds());
        screen.addPageButtons(187, 30, 350, incr -> this.state.swap(incr, (int)Math.ceil((float)this.pages.size() / 2.0f)));
        int pageIndex = this.state.getOffset() * 2;
        this.leftPanel.init(screen, pageIndex);
        this.rightPanel.init(screen, pageIndex + 1);
    }

    public class Page
    implements SpellbookChapterList.Drawable {
        private final class_2561 title;
        private final int level;
        private final int color;
        private final List<PageElement> elements;
        private boolean compiled;
        private Bounds bounds = Bounds.empty();

        public Page(DynamicContent this$0, class_2540 buffer) {
            this.title = (class_2561)class_8824.field_49668.decode((Object)buffer);
            this.level = buffer.readInt();
            this.color = buffer.readInt();
            this.elements = buffer.method_34066(r -> PageElement.read(this, r));
        }

        protected int getLineLimitAt(int yPosition) {
            return this.bounds.width - 10 - this.elements.stream().filter(PageElement::isFloating).map(PageElement::bounds).filter(b -> b.containsY((double)yPosition)).mapToInt(b -> b.width).sum();
        }

        protected int getLeftMarginAt(int yPosition) {
            return this.elements.stream().filter(p -> p.flow() == Flow.LEFT).map(PageElement::bounds).filter(b -> b.containsY((double)yPosition)).mapToInt(b -> b.width).sum();
        }

        protected int getLevel() {
            return this.level;
        }

        protected Bounds getBounds() {
            return this.bounds;
        }

        public int getColor() {
            return this.color == 0 ? MagicText.getColor() : this.color;
        }

        public void reset() {
            this.compiled = false;
        }

        public void drawHeader(class_332 context, int mouseX, int mouseY) {
            if (this.elements.isEmpty()) {
                return;
            }
            boolean needsMoreXp = this.level < 0 || Pony.of((class_1657)class_310.method_1551().field_1724).getLevel().get() < this.level;
            int x = this.bounds.left;
            int y = this.bounds.top - 16;
            DrawableUtil.drawScaledText(context, needsMoreXp ? UNKNOWN : this.title, x, y, 1.3f, MagicText.getColor());
            DrawableUtil.drawScaledText(context, (class_2561)class_2561.method_43469((String)"gui.unicopia.spellbook.page.level_requirement", (Object[])new Object[]{this.level < 0 ? "???" : "" + (this.level + 1)}).method_27692(class_124.field_1077), x, y + 12, 0.8f, MagicText.getColor());
        }

        @Override
        public void draw(class_332 context, int mouseX, int mouseY, IViewRoot container) {
            if (this.elements.isEmpty()) {
                return;
            }
            if (!this.compiled) {
                this.compiled = true;
                int relativeY = 0;
                int textHeight = 0;
                for (PageElement element2 : this.elements.stream().filter(PageElement::isInline).toList()) {
                    element2.compile(relativeY, container);
                    relativeY += element2.bounds().height;
                    if (!(element2 instanceof TextBlock)) continue;
                    textHeight += element2.bounds().height;
                }
                this.bounds.height = textHeight == 0 ? 0 : relativeY;
            }
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416(0.0f, -8.0f, 0.0f);
            this.elements.stream().filter(PageElement::isFloating).forEach(element -> {
                matrices.method_22903();
                element.bounds().translate(matrices);
                element.draw(context, mouseX, mouseY, container);
                matrices.method_22909();
            });
            matrices.method_22903();
            this.elements.stream().filter(PageElement::isInline).forEach(element -> {
                element.draw(context, mouseX, mouseY, container);
                matrices.method_46416(0.0f, (float)element.bounds().height, 0.0f);
            });
            matrices.method_22909();
            matrices.method_22909();
        }

        public String toString() {
            return "DynamicContents$Page[title=" + String.valueOf(this.title) + ",elements=" + String.valueOf(this.elements) + "]";
        }
    }
}

