/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.google.common.base.MoreObjects;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.client.FirstPersonRendererOverrides;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.client.render.AccessoryFeatureRenderer;
import com.minelittlepony.unicopia.entity.behaviour.Disguise;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1439;
import net.minecraft.class_156;
import net.minecraft.class_1642;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5597;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

public class DisguisedArmsFeatureRenderer<E extends class_1309>
implements AccessoryFeatureRenderer.Feature<E> {
    private final class_310 client = class_310.method_1551();
    private static final Map<class_1299<?>, class_2960> OVERLAY_TEXTURES = Map.of(class_1299.field_6123, class_2960.method_60656((String)"textures/entity/zombie/drowned_outer_layer.png"), class_1299.field_6098, class_2960.method_60656((String)"textures/entity/skeleton/stray_overlay.png"));
    private final Function<class_1299<?>, Set<Pair<class_630, class_630>>> overlayModelCache = class_156.method_34866(type -> class_5602.method_32076().filter(layer -> layer.method_35743().equals((Object)class_1299.method_5890((class_1299)type)) && !"main".equals(layer.method_35744())).map(arg_0 -> ((class_5599)class_310.method_1551().method_31974()).method_32072(arg_0)).map(model -> {
        class_630 arms = DisguisedArmsFeatureRenderer.getPart(model, "arms").orElse(null);
        class_630 leftArm = DisguisedArmsFeatureRenderer.getPart(model, "left_arm").or(() -> DisguisedArmsFeatureRenderer.getPart(model, "left_front_leg")).orElse(arms);
        class_630 rightArm = DisguisedArmsFeatureRenderer.getPart(model, "right_arm").or(() -> DisguisedArmsFeatureRenderer.getPart(model, "right_front_leg")).orElse(arms);
        return leftArm != null && rightArm != null ? Pair.of((Object)leftArm, (Object)rightArm) : null;
    }).filter(Objects::nonNull).collect(Collectors.toSet()));

    private static Optional<class_630> getPart(class_630 part, String childName) {
        return part.method_41919(childName) ? Optional.of(part.method_32086(childName)) : Optional.empty();
    }

    public DisguisedArmsFeatureRenderer(class_3883<E, ? extends class_572<E>> context) {
    }

    @Override
    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, E entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
    }

    @Override
    public boolean beforeRenderArms(FirstPersonRendererOverrides.ArmRenderer sender, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, E entity, int light) {
        class_1297 appearance = this.getAppearance(entity);
        if (appearance instanceof class_1309) {
            boolean bothHands;
            class_1309 l = (class_1309)appearance;
            float swingProgress = entity.method_6055(tickDelta);
            class_1268 hand = (class_1268)MoreObjects.firstNonNull((Object)((class_1309)entity).field_6266, (Object)class_1268.field_5808);
            boolean bl = bothHands = l instanceof class_1642 || l instanceof class_1439;
            if ((bothHands || hand == class_1268.field_5808) && entity.method_6047().method_7960()) {
                matrices.method_22903();
                this.renderArmHoldingItem(l, matrices, vertexConsumers, light, 1.0f - sender.getEquipProgress(class_1268.field_5808, tickDelta), hand == class_1268.field_5808 ? swingProgress : 0.0f, entity.method_6068());
                matrices.method_22909();
            }
            if ((bothHands || hand == class_1268.field_5810) && entity.method_6079().method_7960()) {
                matrices.method_22903();
                this.renderArmHoldingItem(l, matrices, vertexConsumers, light, 1.0f - sender.getEquipProgress(class_1268.field_5810, tickDelta), hand == class_1268.field_5810 ? swingProgress : 0.0f, entity.method_6068().method_5928());
                matrices.method_22909();
            }
        }
        return false;
    }

    private class_1297 getAppearance(E entity) {
        return Caster.of(entity).flatMap(caster -> caster.getSpellSlot().get(SpellPredicate.IS_DISGUISE)).map(Disguise.class::cast).flatMap(Disguise::getAppearance).map(EntityAppearance::getAppearance).orElse(null);
    }

    @Nullable
    private class_630 getArmModel(@Nullable class_583<?> model, boolean right) {
        if (model instanceof class_572) {
            class_572 bipedModel = (class_572)model;
            return right ? bipedModel.field_3401 : bipedModel.field_27433;
        }
        if (model instanceof class_5597) {
            class_5597 quad = (class_5597)model;
            class_630 arms = quad.method_41909("arms").orElse(null);
            return quad.method_41909(right ? "right_arm" : "left_arm").or(() -> quad.method_41909(right ? "right_front_leg" : "left_front_leg")).orElse(arms);
        }
        return null;
    }

    private void renderArmHoldingItem(class_1309 entity, class_4587 matrices, class_4597 vertexConsumers, int light, float equipProgress, float swingProgress, class_1306 arm) {
        class_1439 golem;
        int attackTicks;
        class_897 class_8972 = this.client.method_1561().method_3953((class_1297)entity);
        if (!(class_8972 instanceof class_922)) {
            return;
        }
        class_922 renderer = (class_922)class_8972;
        boolean right = arm != class_1306.field_6182;
        class_583 model = renderer.method_4038();
        @Nullable class_630 part = this.getArmModel(model, right);
        if (part == null) {
            return;
        }
        model.method_2816((class_1297)entity, 0.0f, 0.0f, 0.0f);
        model.method_2819((class_1297)entity, 0.0f, 0.0f, 0.0f, 0.0f, this.client.method_60646().method_60637(false));
        float signum = right ? 1.0f : -1.0f;
        float srtSwingProgress = class_3532.method_15355((float)swingProgress);
        float xOffset = -0.3f * class_3532.method_15374((float)(srtSwingProgress * (float)Math.PI));
        float yOffset = 0.4f * class_3532.method_15374((float)(srtSwingProgress * ((float)Math.PI * 2)));
        float swingAmount = -0.4f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
        matrices.method_46416(signum * (xOffset + 0.64000005f), yOffset + -0.6f + equipProgress * -0.6f, swingAmount + -0.71999997f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(signum * 45.0f));
        float zRot = class_3532.method_15374((float)(swingProgress * swingProgress * (float)Math.PI));
        float yRot = class_3532.method_15374((float)(srtSwingProgress * (float)Math.PI));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(signum * yRot * 70.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(signum * zRot * -20.0f));
        matrices.method_46416(signum * -1.0f, 3.6f, 3.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(signum * 120.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(200.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(signum * -135.0f));
        matrices.method_46416(signum * 5.6f, 0.0f, 0.0f);
        if (entity instanceof class_1439 && (attackTicks = (golem = (class_1439)entity).method_6501()) > 0) {
            matrices.method_22907(class_7833.field_40718.rotationDegrees(-signum * part.field_3654 * 57.295776f - 90.0f * signum));
        }
        part.field_3654 = 0.0f;
        if (MineLPDelegate.getInstance().getRace((class_1297)entity).isEquine()) {
            matrices.method_46416(0.0f, -part.field_3656 / 16.0f, 0.0f);
        }
        class_2960 texture = renderer.method_3931((class_1297)entity);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        part.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)texture)), light, class_4608.field_21444);
        class_2960 overlayTexture = OVERLAY_TEXTURES.get(entity.method_5864());
        if (overlayTexture != null) {
            this.overlayModelCache.apply(entity.method_5864()).forEach(arms -> {
                class_630 armPart = right ? (class_630)arms.getSecond() : (class_630)arms.getFirst();
                armPart.method_17138(part);
                RenderSystem.setShaderTexture((int)0, (class_2960)overlayTexture);
                part.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_23580((class_2960)overlayTexture)), light, class_4608.field_21444);
            });
        }
    }
}

