/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.minelittlepony.unicopia.EquinePredicates;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.entity.behaviour.Disguise;
import com.minelittlepony.unicopia.entity.behaviour.EntityAppearance;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

class EntityReplacementManager
implements Disguise {
    @Nullable
    private class_1299<?> currentType;
    private final EntityAppearance disguise = new EntityAppearance();
    private final List<class_1299<?>> defaultTypes = List.of(class_1299.field_6051, class_1299.field_6046, class_1299.field_6071, class_1299.field_6137, class_1299.field_6099, class_1299.field_6123);
    private final Map<class_1299<?>, List<class_1299<?>>> pools = Map.of(class_1299.field_6077, List.of(class_1299.field_6105), class_1299.field_6097, List.of(class_1299.field_6051), class_1299.field_22281, List.of(class_1299.field_6050, class_1299.field_25751), class_1299.field_6114, List.of(class_1299.field_6123), class_1299.field_6087, List.of(class_1299.field_6123), class_1299.field_6116, List.of(class_1299.field_6132));

    EntityReplacementManager() {
    }

    public Optional<Disguise> getAppearanceFor(Caster<?> caster) {
        if (this.isRageApplicable((class_1297)caster.asEntity()) && EquinePredicates.RAGING.test((class_1297)class_310.method_1551().field_1724)) {
            List<class_1299<?>> mobTypes = this.getMobTypePool(caster.asEntity().method_5864());
            class_1299<?> type = mobTypes.get(Math.abs((int)caster.asEntity().method_5667().getMostSignificantBits()) % mobTypes.size());
            if (type != this.currentType) {
                this.currentType = type;
                this.disguise.setAppearance(type.method_5883(caster.asWorld()));
            }
            return Optional.of(this);
        }
        return caster.getSpellSlot().get(SpellPredicate.IS_DISGUISE).map(Disguise.class::cast);
    }

    private List<class_1299<?>> getMobTypePool(class_1299<?> type) {
        return this.pools.getOrDefault(type, this.defaultTypes);
    }

    private boolean isRageApplicable(class_1297 entity) {
        return entity != class_310.method_1551().field_1724 && (entity instanceof class_1296 || entity instanceof class_1657 || this.pools.containsKey(entity.method_5864()));
    }

    @Override
    public EntityAppearance getDisguise() {
        return this.disguise;
    }

    @Override
    public boolean isDead() {
        return false;
    }
}

