/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;

public class ModelPartHooks {
    private static final float PIXEL_SCALE = 0.0625f;
    private static Stack<Set<EnqueudHeadRender>> renderCalls = new Stack();

    public static void startCollecting() {
        renderCalls.push(new LinkedHashSet());
    }

    public static Set<EnqueudHeadRender> stopCollecting() {
        return renderCalls.isEmpty() ? Set.of() : renderCalls.pop();
    }

    public static void onHeadRendered(class_630 part, class_4587 matrices) {
        if (part.field_38456 || !part.field_3665 || renderCalls.isEmpty()) {
            return;
        }
        Set<EnqueudHeadRender> head = renderCalls.peek();
        if (head.size() > 5) {
            renderCalls.pop();
            return;
        }
        EnqueudHeadRender bestCandidate = new EnqueudHeadRender();
        part.method_35745(matrices, (entry, name, index, cube) -> {
            float x = cube.field_3648 - cube.field_3645;
            float y = cube.field_3647 - cube.field_3644;
            float z = cube.field_3646 - cube.field_3643;
            float volume = ModelPartHooks.div(Math.abs(x * y * z), Math.abs(x + y + z)) * 3.0f;
            if (volume > 0.0f && volume > bestCandidate.volume) {
                bestCandidate.cube = cube;
                bestCandidate.transformation = entry;
                bestCandidate.volume = volume;
                bestCandidate.maxSideLength = Math.max(Math.max(x, z), y);
            }
        });
        if (bestCandidate.transformation != null) {
            head.add(bestCandidate);
        }
    }

    static float div(float a, float b) {
        return b == 0.0f ? 0.0f : a / b;
    }

    public static final class EnqueudHeadRender {
        private class_630.class_628 cube;
        private class_4587.class_4665 transformation;
        private float volume;
        private float maxSideLength;

        public void transform(class_4587 matrices, float cubeSize) {
            matrices.method_23760().method_23762().set((Matrix3fc)this.transformation.method_23762());
            matrices.method_23760().method_23761().set((Matrix4fc)this.transformation.method_23761());
            float x = class_3532.method_16439((float)0.5f, (float)this.cube.field_3645, (float)this.cube.field_3648);
            float y = class_3532.method_16439((float)0.5f, (float)this.cube.field_3644, (float)this.cube.field_3647);
            float z = class_3532.method_16439((float)0.5f, (float)this.cube.field_3643, (float)this.cube.field_3646);
            float scale = this.maxSideLength / cubeSize * 0.0625f;
            matrices.method_46416(x * 0.0625f, y * 0.0625f, z * 0.0625f);
            matrices.method_22905(scale, scale, scale);
        }
    }
}

