/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.client.minelittlepony.MineLPDelegate;
import com.minelittlepony.unicopia.command.CommandArgumentEnum;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.item.GlassesItem;
import com.minelittlepony.unicopia.util.AnimationUtil;
import com.minelittlepony.unicopia.util.serialization.PacketCodecUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4587;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_7485;
import net.minecraft.class_7833;
import net.minecraft.class_9139;
import net.minecraft.class_9334;

public class PlayerPoser {
    public static final PlayerPoser INSTANCE = new PlayerPoser();
    private static final float HEAD_NOD_DURATION = 15.0f;
    private static final float HEAD_NOD_GAP = 5.0f;

    public void applyPosing(class_4587 matrices, class_1657 player, class_572<?> model, Context context) {
        class_2561 name;
        Pony pony = Pony.of(player);
        float tickDelta = class_310.method_1551().method_60646().method_60637(false);
        float progress = pony.getAnimationProgress(class_310.method_1551().method_60646().method_60637(false));
        AnimationInstance animation = pony.getAnimation();
        Race ponyRace = MineLPDelegate.getInstance().getPlayerPonyRace(player);
        class_1306 mainArm = player.method_6068();
        boolean liftLeftArm = mainArm == class_1306.field_6182 || !ponyRace.isEquine();
        boolean liftRightArm = mainArm == class_1306.field_6183 || !ponyRace.isEquine();
        class_1799 glasses = GlassesItem.getForEntity((class_1309)player).stack();
        class_630 head = model.method_2838();
        if (context == Context.THIRD_PERSON && !player.method_5715()) {
            class_1268 leftHand = mainArm == class_1306.field_6182 ? class_1268.field_5808 : class_1268.field_5810;
            class_1268 rightHand = mainArm == class_1306.field_6182 ? class_1268.field_5810 : class_1268.field_5808;
            float pitchChange = -0.5f;
            float yawChange = 0.8f;
            if (player.method_5998(rightHand).method_31573(UTags.Items.POLEARMS) && (!ponyRace.isEquine() || model.field_3401.field_3654 != 0.0f)) {
                model.field_3401.field_3654 += pitchChange;
                model.field_3401.field_3675 += yawChange;
                if (player.field_6279 > 0 && rightHand == class_1268.field_5808) {
                    model.field_3401.field_3675 -= 0.5f;
                    model.field_3401.field_3654 += 1.5f;
                }
            }
            if (player.method_5998(leftHand).method_31573(UTags.Items.POLEARMS) && (!ponyRace.isEquine() || model.field_27433.field_3654 != 0.0f)) {
                model.field_27433.field_3654 += pitchChange;
                model.field_27433.field_3675 -= yawChange;
                if (player.field_6279 > 0 && leftHand == class_1268.field_5808) {
                    model.field_27433.field_3675 -= 0.5f;
                    model.field_27433.field_3654 += 1.5f;
                }
            }
        }
        if ((name = (class_2561)glasses.method_57824(class_9334.field_49631)) != null && "Cool Shades".equals(name.getString())) {
            float bop = AnimationUtil.beat(player.field_6012, 15.0f, 5.0f) * 3.0f;
            head.field_3654 += bop / 10.0f;
            float beat30 = bop / 30.0f;
            if (ponyRace.isEquine()) {
                float beat50 = bop / 50.0f;
                float beat20 = bop / 20.0f;
                model.field_27433.field_3674 -= beat50;
                model.field_3401.field_3674 += beat50;
                model.field_3397.field_3674 -= beat30;
                model.field_3397.field_3654 -= beat20;
                model.field_3392.field_3674 += beat30;
                model.field_3392.field_3654 += beat20;
            } else {
                model.field_27433.field_3674 -= beat30;
                model.field_3401.field_3674 += beat30;
            }
        }
        if (animation.canPlay(ponyRace.isEquine())) {
            switch (animation.animation().ordinal()) {
                case 12: {
                    head.field_3675 += 3.0f;
                    head.field_3654 *= -1.0f;
                    break;
                }
                case 1: {
                    float roll = class_3532.method_15374((float)((float)player.field_6012 / 10.0f));
                    float yaw = class_3532.method_15362((float)((float)player.field_6012 / 10.0f));
                    if (liftLeftArm) {
                        this.rotateArm(model.field_27433, 1.0f, yaw, -roll);
                    }
                    if (!liftRightArm) break;
                    this.rotateArm(model.field_27433, 1.0f, yaw, roll);
                    break;
                }
                case 2: {
                    float roll = (progress + 1.0f) / 2.0f;
                    float pitch = 1.5f * roll;
                    float yaw = -0.5f * roll;
                    if (liftLeftArm) {
                        this.rotateArm(model.field_27433, pitch, -yaw, 0.0f);
                    }
                    if (!liftRightArm) break;
                    this.rotateArm(model.field_3401, pitch, yaw, 0.0f);
                    break;
                }
                case 8: {
                    float saw = class_3532.method_15374((float)player.field_42108.method_48569());
                    float pitch = 0.8f * saw;
                    float basePitch = 3.25f;
                    if (context == Context.THIRD_PERSON) {
                        if (ponyRace.isEquine()) {
                            this.rearUp(matrices, model, 1.0f);
                            model.field_3398.field_3654 += 0.8f;
                            basePitch = 2.25f;
                        }
                        this.rotateArm(model.field_27433, basePitch - pitch, -0.3f, 0.0f);
                        this.rotateArm(model.field_3401, basePitch + pitch, 0.3f, 0.0f);
                        this.rotateArm(model.field_3397, 0.0f, 0.1f, 0.0f);
                        this.rotateArm(model.field_3392, 0.0f, -0.1f, 0.0f);
                        break;
                    }
                    float x = ponyRace.isEquine() ? 9.0f : 10.0f;
                    float y = ponyRace.isEquine() ? -3.0f : -1.0f;
                    float z = ponyRace.isEquine() ? -8.0f : -6.0f;
                    float cameraPitch = player.method_5695(tickDelta) * ((float)Math.PI / 180);
                    this.rotateArm(model.field_27433, 0.0f, 0.0f, -0.4f + (pitch *= 0.5f));
                    this.rotateArm(model.field_3401, 0.0f, 0.0f, 0.4f + pitch);
                    model.field_27433.field_3657 += x;
                    model.field_27433.field_3656 += y;
                    model.field_27433.field_3655 += z;
                    model.field_27433.field_3674 -= cameraPitch;
                    model.field_3401.field_3657 -= x;
                    model.field_3401.field_3656 += y;
                    model.field_3401.field_3655 += z;
                    model.field_3401.field_3674 += cameraPitch;
                    break;
                }
                case 3: {
                    float saw = AnimationUtil.seesaw(progress);
                    float pitch = 3.0f * saw;
                    float yaw = 0.5f * saw;
                    if (ponyRace.isEquine()) {
                        this.rearUp(matrices, model, saw);
                        model.field_3398.field_3654 += saw * 0.5f;
                        pitch = saw * 2.0f;
                    }
                    if (liftLeftArm) {
                        this.rotateArm(model.field_27433, pitch, -yaw, yaw);
                    } else if (ponyRace.isEquine()) {
                        model.field_27433.field_3654 -= saw / 4.0f;
                        model.field_27433.field_3674 -= saw / 4.0f;
                    }
                    if (liftRightArm) {
                        this.rotateArm(model.field_3401, pitch, yaw, -yaw);
                        break;
                    }
                    if (!ponyRace.isEquine()) break;
                    model.field_3401.field_3654 += saw / 4.0f;
                    model.field_3401.field_3674 += saw / 4.0f;
                    break;
                }
                case 7: {
                    float saw = AnimationUtil.seesaw(progress);
                    float pitch = class_3532.method_15363((float)(3.0f * saw), (float)1.0f, (float)2.0f);
                    float yaw = 0.5f * saw;
                    if (context == Context.THIRD_PERSON) {
                        if (ponyRace.isEquine()) {
                            this.rearUp(matrices, model, 1.0f);
                            pitch = saw * 2.0f;
                            model.field_3398.field_3654 += saw * 0.5f;
                            this.rotateArm(model.field_27433, pitch, -yaw, yaw / 2.0f);
                            this.rotateArm(model.field_3392, pitch / 2.0f, yaw, 0.0f);
                            saw = AnimationUtil.seesaw(progress + 0.5f);
                            yaw = 0.5f * -saw;
                            this.rotateArm(model.field_3401, pitch, yaw, -yaw / 2.0f);
                            this.rotateArm(model.field_3397, pitch / 2.0f, -yaw, 0.0f);
                            break;
                        }
                        this.rotateArm(model.field_27433, pitch, -yaw, yaw / 2.0f);
                        this.rotateArm(model.field_3392, pitch / 2.0f, yaw, 0.0f);
                        saw = AnimationUtil.seesaw((progress + 0.5f) % 1.0f);
                        pitch = class_3532.method_15363((float)(3.0f * saw), (float)1.0f, (float)2.0f) * (float)(ponyRace.isEquine() ? 2 : 1);
                        yaw = 0.5f * saw;
                        this.rotateArm(model.field_3401, pitch, yaw, -yaw / 2.0f);
                        this.rotateArm(model.field_3397, pitch / 2.0f, -yaw, 0.0f);
                        break;
                    }
                    float x = ponyRace.isEquine() ? 9.0f : 0.0f;
                    float y = ponyRace.isEquine() ? -3.0f : 0.0f;
                    float z = ponyRace.isEquine() ? -8.0f : -2.0f;
                    float cameraPitch = player.method_5695(tickDelta) * ((float)Math.PI / 180);
                    pitch = class_3532.method_15374((float)(progress * 2.0f * (float)Math.PI)) * 0.6f;
                    this.rotateArm(model.field_27433, 0.0f, 0.0f, pitch);
                    this.rotateArm(model.field_3401, 0.0f, 0.0f, pitch);
                    model.field_27433.field_3657 += x;
                    model.field_27433.field_3656 += y;
                    model.field_27433.field_3655 += z;
                    model.field_27433.field_3674 -= cameraPitch;
                    model.field_3401.field_3657 -= x;
                    model.field_3401.field_3656 += y;
                    model.field_3401.field_3655 += z;
                    model.field_3401.field_3674 += cameraPitch;
                    break;
                }
                case 4: 
                case 5: {
                    progress = AnimationUtil.seesaw(progress);
                    if (animation.isOf(Animation.WAVE_TWO) && ponyRace.isEquine()) {
                        this.rearUp(matrices, model, progress);
                        model.field_3398.field_3654 += progress * 0.5f;
                    }
                    float wave = 2.5f + progress * class_3532.method_15374((float)((float)player.field_6012 / 3.0f));
                    if (animation.isOf(Animation.WAVE_TWO) || mainArm == class_1306.field_6182) {
                        model.field_27433.field_3674 = -wave;
                    }
                    if (!animation.isOf(Animation.WAVE_TWO) && mainArm != class_1306.field_6183) break;
                    model.field_3401.field_3674 = wave;
                    break;
                }
                case 6: {
                    if (ponyRace.isEquine()) {
                        float roll = (progress + 1.0f) / 2.0f;
                        model.field_3392.field_3654 = roll * 1.5f;
                        model.field_3392.field_3675 = -roll / 7.0f;
                        model.field_3397.field_3654 = roll * 1.5f;
                        model.field_3397.field_3675 = roll / 7.0f;
                        model.field_27433.field_3654 = 0.0f;
                        model.field_27433.field_3674 = class_3532.method_16439((float)progress, (float)model.field_27433.field_3674, (float)0.0f);
                        model.field_3401.field_3654 = 0.0f;
                        model.field_3401.field_3674 = class_3532.method_16439((float)progress, (float)model.field_3401.field_3674, (float)0.0f);
                        break;
                    }
                    float roll = (progress + 1.0f) / 2.0f;
                    model.field_3401.field_3654 += roll / 5.0f;
                    model.field_27433.field_3674 -= roll / 5.0f;
                    model.field_3401.field_3674 += roll / 5.0f;
                    if (player.method_6068() == class_1306.field_6182) {
                        model.field_3392.field_3654 = -roll * 1.5f;
                        model.field_3392.field_3674 = roll / 10.0f;
                        break;
                    }
                    model.field_3397.field_3654 = -roll * 1.5f;
                    model.field_3397.field_3674 = -roll / 10.0f;
                    break;
                }
                case 9: {
                    progress = AnimationUtil.seesaw(progress);
                    if (!ponyRace.isEquine()) {
                        if (mainArm == class_1306.field_6182) {
                            model.field_3392.field_3674 = -progress / 9.0f;
                            model.field_3392.field_3656 -= progress * 5.0f;
                            break;
                        }
                        model.field_3397.field_3674 = -progress / 9.0f;
                        model.field_3397.field_3656 -= progress * 5.0f;
                        break;
                    }
                    this.rearUp(matrices, model, progress);
                    model.field_3398.field_3654 += progress * 0.5f;
                    model.field_27433.field_3654 += progress / 2.0f;
                    model.field_3401.field_3654 += progress / 2.0f;
                    break;
                }
                case 10: {
                    if (!ponyRace.isEquine()) break;
                    model.method_2838().method_32086((String)"mare").field_3656 = progress = AnimationUtil.seesaw(progress) * class_3532.method_15374((float)player.field_6012) / 7.0f;
                    model.method_2838().method_32086((String)"stallion").field_3656 = progress;
                    break;
                }
            }
        }
        if (pony.getEntityInArms().isPresent()) {
            if (ponyRace.isEquine() && pony.getPhysics().isFlying()) {
                model.field_3397.field_3654 = 1.0f;
                model.field_3392.field_3654 = 1.0f;
                model.field_3397.field_3675 = 0.3f;
                model.field_3392.field_3675 = -0.3f;
            } else {
                model.field_27433.field_3654 = -1.0f;
                model.field_3401.field_3654 = -1.0f;
            }
            model.field_27433.field_3675 = -0.3f;
            model.field_3401.field_3675 = 0.3f;
            model.field_27433.field_3674 = 0.0f;
            model.field_3401.field_3674 = 0.0f;
        }
        if (model instanceof class_591) {
            class_591 m = (class_591)model;
            m.field_3484.method_17138(m.field_27433);
            m.field_3486.method_17138(m.field_3401);
            m.field_3482.method_17138(m.field_3397);
            m.field_3479.method_17138(m.field_3392);
        }
        model.field_3394.method_17138(model.field_3398);
    }

    private void rotateArm(class_630 arm, float pitch, float yaw, float roll) {
        arm.field_3654 -= pitch;
        arm.field_3674 = roll;
        arm.field_3675 = yaw;
    }

    private void rearUp(class_4587 matrices, class_572<?> model, float progress) {
        matrices.method_22904(0.0, 0.0, 0.5);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-45.0f * progress));
        matrices.method_22904(0.0, 0.0, -0.5);
        float roll = progress / 2.0f;
        model.field_3392.field_3654 = roll * 1.5f;
        model.field_3392.field_3675 = -roll / 7.0f;
        model.field_3397.field_3654 = roll * 1.5f;
        model.field_3397.field_3675 = roll / 7.0f;
    }

    public record AnimationInstance(Animation animation, Animation.Recipient recipient) {
        public static final AnimationInstance NONE = new AnimationInstance(Animation.NONE, Animation.Recipient.ANYONE);
        public static final class_9139<ByteBuf, AnimationInstance> PACKET_CODEC = class_9139.method_56435(PacketCodecUtils.ofEnum(Animation.class), AnimationInstance::animation, PacketCodecUtils.ofEnum(Animation.Recipient.class), AnimationInstance::recipient, AnimationInstance::new);

        public boolean isOf(Animation animation) {
            return this.animation() == animation;
        }

        public boolean canPlay(boolean isPony) {
            return !this.isOf(Animation.NONE) && (this.recipient == Animation.Recipient.ANYONE || isPony == (this.recipient == Animation.Recipient.PONY));
        }

        public boolean renderBothArms() {
            return this.isOf(Animation.HANG) || this.isOf(Animation.CLIMB);
        }
    }

    public static enum Context {
        FIRST_PERSON_LEFT,
        FIRST_PERSON_RIGHT,
        THIRD_PERSON;

    }

    public static enum Animation implements CommandArgumentEnum<Animation>
    {
        NONE(0),
        WOLOLO(USounds.ENTITY_PLAYER_WOLOLO, 40),
        ARMS_FORWARD(5),
        ARMS_UP(5),
        WAVE_ONE(USounds.ENTITY_PLAYER_WHISTLE, 20),
        WAVE_TWO(USounds.ENTITY_PLAYER_WHISTLE, 20),
        KICK(USounds.ENTITY_PLAYER_KICK, 5),
        CLIMB(20),
        HANG(20),
        STOMP(5),
        WIGGLE_NOSE(6),
        SPREAD_WINGS(6),
        NECK_SNAP(50);

        private final int duration;
        private final Optional<class_3414> sound;

        private Animation(int duration) {
            this.duration = duration;
            this.sound = Optional.empty();
        }

        private Animation(class_3414 sound, int duration) {
            this.duration = duration;
            this.sound = Optional.of(sound);
        }

        public int getDuration() {
            return this.duration;
        }

        public Optional<class_3414> getSound() {
            return this.sound;
        }

        public static class_7485<Animation> argument() {
            return new ArgumentType();
        }

        public static final class ArgumentType
        extends class_7485<Animation> {
            static final Codec<Animation> CODEC = class_3542.method_28140(Animation::values);

            protected ArgumentType() {
                super(CODEC, Animation::values);
            }
        }

        public static enum Recipient implements CommandArgumentEnum<Recipient>
        {
            HUMAN,
            PONY,
            ANYONE;


            public static class_7485<Recipient> argument() {
                return new ArgumentType();
            }

            public static final class ArgumentType
            extends class_7485<Recipient> {
                static final Codec<Recipient> CODEC = class_3542.method_28140(Recipient::values);

                protected ArgumentType() {
                    super(CODEC, Recipient::values);
                }
            }
        }
    }
}

