/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render;

import com.minelittlepony.unicopia.FlightType;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.client.render.AccessoryFeatureRenderer;
import com.minelittlepony.unicopia.entity.AmuletSelectors;
import com.minelittlepony.unicopia.entity.player.Pony;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public class WingsFeatureRenderer<E extends class_1309>
implements AccessoryFeatureRenderer.Feature<E> {
    protected static final int FEATHER_COUNT = 8;
    private static final class_2960 PEGASUS_WINGS = Unicopia.id("textures/models/wings/pegasus.png");
    private static final class_2960 PEGASUS_WINGS_OVERLAY = Unicopia.id("textures/models/wings/pegasus_overlay.png");
    private final WingsModel model;
    private final class_3883<E, ? extends class_572<E>> context;

    public WingsFeatureRenderer(class_3883<E, ? extends class_572<E>> context) {
        this.context = context;
        this.model = new WingsModel(this.createModel(class_5605.field_27715).method_32109());
    }

    @Override
    public void render(class_4587 matrices, class_4597 renderContext, int lightUv, E entity, float limbDistance, float limbAngle, float tickDelta, float age, float headYaw, float headPitch) {
        if (this.canRender(entity)) {
            this.model.setAngles((class_1309)entity, (class_572<?>)((class_572)this.context.method_4038()));
            this.model.method_2828(matrices, this.getBuffer(renderContext, this.getTexture(entity)), lightUv, class_4608.field_21444, -1);
            class_2960 overlayTexture = this.getOverlayTexture(entity);
            if (overlayTexture != null) {
                this.model.method_2828(matrices, this.getBuffer(renderContext, overlayTexture), lightUv, class_4608.field_21444, -1);
            }
        }
    }

    protected class_4588 getBuffer(class_4597 vertices, class_2960 texture) {
        return vertices.getBuffer(class_1921.method_23580((class_2960)texture));
    }

    protected boolean canRender(E entity) {
        class_1657 player;
        return entity instanceof class_1657 && Pony.of(player = (class_1657)entity).getObservedSpecies().flightType() == FlightType.AVIAN && Pony.of(player).getObservedSpecies() != Race.BAT && Pony.of(player).getSkinFeatures().showWings() && !AmuletSelectors.PEGASUS_AMULET.test((class_1309)entity);
    }

    protected class_2960 getTexture(E entity) {
        return PEGASUS_WINGS;
    }

    @Nullable
    protected class_2960 getOverlayTexture(E entity) {
        return PEGASUS_WINGS_OVERLAY;
    }

    private class_5607 createModel(class_5605 dilation) {
        class_5609 data = new class_5609();
        this.createWing("left_wing", data.method_32111(), dilation, -1);
        this.createWing("right_wing", data.method_32111(), dilation, 1);
        return class_5607.method_32110((class_5609)data, (int)24, (int)23);
    }

    protected void createWing(String name, class_5610 parent, class_5605 dilation, int k) {
        class_5610 base = parent.method_32117(name, class_5606.method_32108().method_32098(0.0f, 0.0f, 0.0f, 2.0f, 10.0f, 2.0f, dilation), class_5603.method_32090((float)(k * 2), (float)2.0f, (float)(2.0f + (float)k * 0.5f)));
        for (int i = 0; i < 8; ++i) {
            int texX = i % 2 * 8;
            int featherLength = 21 - i * 2;
            base.method_32117("feather_" + i, class_5606.method_32108().method_32101(8 + texX, 0).method_32098((float)(-k * (i % 2)) / 90.0f, 0.0f, 0.0f, 2.0f, (float)featherLength, 2.0f, dilation), class_5603.method_32090((float)0.0f, (float)9.0f, (float)0.0f));
        }
    }

    private static class WingsModel
    extends class_3879 {
        private final class_630 root;
        private final Wing leftWing;
        private final Wing rightWing;

        public WingsModel(class_630 tree) {
            super(class_1921::method_23580);
            this.root = tree;
            this.leftWing = new Wing(tree.method_32086("left_wing"), -1);
            this.rightWing = new Wing(tree.method_32086("right_wing"), 1);
        }

        public void setAngles(class_1309 entity, class_572<?> biped) {
            this.root.method_17138(biped.field_3391);
            this.leftWing.setAngles(entity);
            this.rightWing.setAngles(entity);
        }

        public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, int color) {
            this.root.method_22699(matrices, vertexConsumer, light, overlay, color);
        }

        static class Wing {
            final class_630 base;
            final class_630[] feathers = new class_630[8];
            final int k;

            Wing(class_630 tree, int k) {
                this.k = k;
                this.base = tree;
                for (int i = 0; i < this.feathers.length; ++i) {
                    this.feathers[i] = this.base.method_32086("feather_" + i);
                }
            }

            void setAngles(class_1309 entity) {
                float spreadAmount = entity instanceof class_1657 ? Pony.of((class_1657)entity).getMotion().getWingAngle() : 0.0f;
                this.base.field_3654 = 2.3f - spreadAmount / 9.0f;
                this.base.field_3675 = (float)this.k * (0.8f + spreadAmount / 3.0f);
                spreadAmount /= 7.0f;
                float ratio = 4.0f;
                for (int i = 0; i < this.feathers.length; ++i) {
                    float spread = (float)i / 4.0f + 1.5f;
                    spread -= spreadAmount * 4.0f;
                    this.feathers[i].field_3654 = -(spread += spreadAmount * (float)i / 4.0f);
                    this.feathers[i].field_3675 = (float)this.k * 0.3f;
                }
            }
        }
    }
}

