/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.bezier;

import com.minelittlepony.unicopia.client.render.bezier.BezierSegment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_243;
import org.joml.Vector3f;

public class Trail {
    private final List<Segment> segments = new ArrayList<Segment>();
    public final class_243 pos;
    private final float height;

    public Trail(class_243 pos, float height) {
        this.pos = pos;
        this.height = height;
        this.segments.add(new Segment(pos));
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void update(class_243 newPosition) {
        if (this.segments.isEmpty()) {
            this.segments.add(new Segment(newPosition));
        } else {
            class_243 last = this.segments.get((int)(this.segments.size() - 1)).position;
            if (newPosition.method_1022(last) > 0.2) {
                this.segments.add(new Segment(newPosition));
            }
        }
    }

    public boolean tick() {
        if (this.segments.size() > 1) {
            this.segments.removeIf(Segment::tick);
        }
        return this.segments.isEmpty();
    }

    public final class Segment {
        class_243 position;
        Vector3f offset;
        int age;
        int maxAge;

        Segment(class_243 position) {
            this.position = position;
            this.offset = position.method_1020(Trail.this.pos).method_46409();
            this.maxAge = 90;
        }

        public float getAlpha() {
            return 1.0f - (float)this.age / (float)this.maxAge;
        }

        boolean tick() {
            return Trail.this.segments.indexOf(this) < Trail.this.segments.size() - 1 && this.age++ >= this.maxAge;
        }

        public void getPlane(Segment to, BezierSegment segment) {
            segment.set(this.offset, to.offset, Trail.this.height);
        }
    }
}

