/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.spell;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.spell.TimedSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.DarkVortexSpell;
import com.minelittlepony.unicopia.client.render.RenderLayers;
import com.minelittlepony.unicopia.client.render.model.PlaneModel;
import com.minelittlepony.unicopia.client.render.model.SphereModel;
import com.minelittlepony.unicopia.client.render.spell.SpellRenderer;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_7833;

public class DarkVortexSpellRenderer
extends SpellRenderer<DarkVortexSpell> {
    private static final class_2960 ACCRETION_DISK_TEXTURE = Unicopia.id("textures/spells/dark_vortex/accretion_disk.png");
    private static final int DISTORTION_ZONE_COLOR = class_5253.class_5254.method_58144((int)-16777216, (int)229);
    private static float cameraDistortion;

    public static float getCameraDistortion() {
        cameraDistortion *= 0.9f;
        cameraDistortion = class_3532.method_15363((float)cameraDistortion, (float)0.0f, (float)80.0f);
        return cameraDistortion;
    }

    @Override
    public boolean shouldRenderEffectPass(int pass) {
        return pass < 2;
    }

    @Override
    public void render(class_4587 matrices, class_4597 vertices, DarkVortexSpell spell, Caster<?> caster, int light, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        class_243 ray = camera.method_19326().method_1020(spell.getOrigin(caster));
        float radius = (float)spell.getEventHorizonRadius();
        float absDistance = (float)ray.method_1033();
        matrices.method_22903();
        matrices.method_22904(0.0, spell.getYOffset(), 0.0);
        matrices.method_22907(class_7833.field_40715.rotationDegrees(-caster.asEntity().method_36454()));
        float visualRadius = Math.min(radius * 0.8f, absDistance - 1.0f);
        class_5253.class_5254.method_58144((int)-16777216, (int)229);
        SphereModel.SPHERE.render(matrices, vertices.getBuffer(RenderLayers.method_23577()), light, 1, visualRadius, -16777216);
        SphereModel.SPHERE.render(matrices, vertices.getBuffer(RenderLayers.getMagicColored()), light, 1, visualRadius + 0.05f, DISTORTION_ZONE_COLOR);
        SphereModel.SPHERE.render(matrices, vertices.getBuffer(RenderLayers.getMagicColored()), light, 1, visualRadius + 0.1f, DISTORTION_ZONE_COLOR);
        SphereModel.SPHERE.render(matrices, vertices.getBuffer(RenderLayers.getMagicColored()), light, 1, visualRadius + 0.15f, DISTORTION_ZONE_COLOR);
        matrices.method_22903();
        float distance = 1.0f / class_3532.method_15363((float)(absDistance / (radius + 7.0f)), (float)1.0E-7f, (float)1.0f);
        distance *= distance;
        if (absDistance < radius * 4.0f) {
            cameraDistortion += distance;
        }
        SphereModel.DISK.render(matrices, vertices.getBuffer(RenderLayers.method_23574()), light, 1, radius * 0.5f, 0);
        if (radius > 0.3f && absDistance > radius) {
            double g = Math.sqrt(ray.field_1352 * ray.field_1352 + ray.field_1350 * ray.field_1350);
            float pitch = class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)ray.field_1351, (double)g) * 180.0 / 3.1415927410125732))));
            float yaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)ray.field_1350, (double)ray.field_1352) * 180.0 / 3.1415927410125732) - 90.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(caster.asEntity().method_36454()));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-pitch));
            radius *= Math.min(2.0f, 3.0f + radius);
            float processionSpeed = animationProgress * 0.02f;
            float maxProcessionAngle = 15.0f;
            float cosProcession = class_3532.method_15362((float)processionSpeed);
            float sinProcession = class_3532.method_15374((float)processionSpeed);
            float range = (float)spell.getDrawDropOffRange() / 8.0f;
            matrices.method_22905(range, range, range);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(cosProcession * maxProcessionAngle));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(sinProcession * maxProcessionAngle));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(animationProgress * 18.0f));
            class_4588 buffer = vertices.getBuffer(class_1921.method_23580((class_2960)ACCRETION_DISK_TEXTURE));
            PlaneModel.INSTANCE.render(matrices, buffer, light, 0, 1.0f, -1);
            float secondaryScale = 0.9f + cosProcession * 0.3f;
            matrices.method_46416(0.0f, 0.0f, 1.0E-4f);
            matrices.method_22905(secondaryScale, secondaryScale, secondaryScale);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(33.0f));
            PlaneModel.INSTANCE.render(matrices, buffer, light, 0, 1.0f, -1);
            matrices.method_46416(0.0f, 0.0f, 1.0E-4f);
            matrices.method_22905(0.9f, 0.9f, 0.9f);
            matrices.method_22907(class_7833.field_40718.rotationDegrees(33.0f));
            PlaneModel.INSTANCE.render(matrices, buffer, light, 0, 1.0f, -1);
        }
        matrices.method_22909();
        matrices.method_22909();
    }

    @Override
    protected void renderCountdown(class_4587 matrices, TimedSpell spell, float tickDelta) {
    }
}

