/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.client.render.spell;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.ability.magic.Caster;
import com.minelittlepony.unicopia.ability.magic.SpellPredicate;
import com.minelittlepony.unicopia.ability.magic.spell.Spell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.client.render.spell.BubbleSpellRenderer;
import com.minelittlepony.unicopia.client.render.spell.DarkVortexSpellRenderer;
import com.minelittlepony.unicopia.client.render.spell.PortalSpellRenderer;
import com.minelittlepony.unicopia.client.render.spell.RainboomSpellRenderer;
import com.minelittlepony.unicopia.client.render.spell.ShieldSpellRenderer;
import com.minelittlepony.unicopia.client.render.spell.SpellRenderer;
import com.minelittlepony.unicopia.client.render.spell.SpellRendererFactory;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.mob.CastSpellEntity;
import com.minelittlepony.unicopia.entity.player.Pony;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5498;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SpellEffectsRenderDispatcher
implements class_4013,
IdentifiableResourceReloadListener {
    public static final SpellEffectsRenderDispatcher INSTANCE = new SpellEffectsRenderDispatcher();
    private static final class_2960 ID = Unicopia.id("spell_renderers");
    private static final Map<SpellType<?>, SpellRendererFactory<?>> REGISTRY = new HashMap();
    @Nullable
    private Map<SpellType<?>, SpellRenderer<?>> renderers = Map.of();
    private final class_310 client = class_310.method_1551();

    public static <T extends Spell> void register(SpellType<T> type, SpellRendererFactory<? super T> rendererFactory) {
        REGISTRY.put(type, rendererFactory);
    }

    private SpellEffectsRenderDispatcher() {
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public <S extends Spell> SpellRenderer<S> getRenderer(S spell) {
        return this.renderers.getOrDefault(spell.getTypeAndTraits().type(), SpellRenderer.DEFAULT);
    }

    public void render(class_4587 matrices, class_4597 vertices, Spell spell, Caster<?> caster, int light, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        SpellRenderer<Spell> renderer = this.getRenderer(spell);
        if (renderer != SpellRenderer.DEFAULT) {
            this.client.method_22940().method_23000().method_22993();
            renderer.render(matrices, vertices, spell, caster, light, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
        }
    }

    public void render(class_4587 matrices, class_4597 vertices, int light, Caster<?> caster, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (!((RenderDispatcherAccessor)this.client.method_1561()).shouldRenderShadows()) {
            return;
        }
        caster.getSpellSlot().stream().forEach(spell -> this.render(matrices, vertices, (Spell)spell, caster, light, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch));
        if (this.client.method_1561().method_3958() && !this.client.method_1555() && (caster.asEntity() != this.client.field_1719 || this.client.field_1690.method_31044() != class_5498.field_26664)) {
            if (!(caster instanceof Pony) && !(caster instanceof CastSpellEntity)) {
                return;
            }
            this.renderHotspot(matrices, vertices, caster, animationProgress);
            this.renderSpellDebugInfo(matrices, vertices, caster, light);
        }
    }

    public void method_14491(class_3300 manager) {
        this.renderers = REGISTRY.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((SpellRendererFactory)entry.getValue()).create()));
    }

    private void renderSpellDebugInfo(class_4587 matrices, class_4597 vertices, Caster<?> caster, int light) {
        matrices.method_22903();
        matrices.method_22907(this.client.method_1561().method_24197());
        float scale = 0.0125f;
        if (caster instanceof Living) {
            matrices.method_22905(scale, scale, scale);
        } else {
            matrices.method_22905(-scale, -scale, scale);
        }
        float g = class_310.method_1551().field_1690.method_19343(0.25f);
        int j = (int)(g * 255.0f) << 24;
        List<class_5250> debugLines = Stream.concat(Stream.of(caster.asEntity().method_5476().method_27661().method_27693(" (" + String.valueOf(class_7923.field_41177.method_10221((Object)caster.asEntity().method_5864())) + ")"), caster.getMaster() != null ? class_2561.method_43470((String)"Master: ").method_10852(((class_1309)caster.getMaster()).method_5476()) : class_2561.method_43473()), caster.getSpellSlot().stream(SpellPredicate.ALL).flatMap(spell -> Stream.of(class_2561.method_43470((String)("UUID: " + String.valueOf(spell.getUuid()))), class_2561.method_43470((String)"|>Type: ").method_10852((class_2561)class_2561.method_43470((String)spell.getTypeAndTraits().type().getId().toString()).method_27694(s -> s.method_36139(spell.getTypeAndTraits().type().getColor()))), class_2561.method_30163((String)("|>Traits: " + String.valueOf(spell.getTypeAndTraits().traits()))), class_2561.method_43470((String)"|>HasRenderer: ").method_10852((class_2561)class_2561.method_43470((String)("" + (this.getRenderer(spell) != null))).method_27692(this.getRenderer(spell) != null ? class_124.field_1060 : class_124.field_1061))))).toList();
        Objects.requireNonNull(this.client.field_1772);
        int spacing = 9 + 1;
        int height = spacing * debugLines.size();
        int top = -height;
        int left = (int)caster.asEntity().method_17681() * 64;
        for (class_2561 class_25612 : debugLines) {
            this.client.field_1772.method_30882(class_25612, (float)(++left), (float)(top += spacing), -1, false, matrices.method_23760().method_23761(), vertices, class_327.class_6415.field_33995, j, light);
        }
        matrices.method_22909();
    }

    private void renderHotspot(class_4587 matrices, class_4597 vertices, Caster<?> caster, float animationProgress) {
        class_238 boundingBox = class_238.method_30048((class_243)caster.getOriginVector(), (double)1.0, (double)1.0, (double)1.0);
        class_243 pos = caster.getOriginVector();
        double x = -pos.field_1352;
        double y = -pos.field_1351;
        double z = -pos.field_1350;
        class_4588 buffer = vertices.getBuffer(class_1921.method_23594());
        for (float i = -1.0f; i < 1.0f; i += 0.2f) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40714.rotationDegrees(i * animationProgress));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(i * animationProgress));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(i * animationProgress));
            matrices.method_22905(i, i, i);
            class_761.method_22982((class_4587)matrices, (class_4588)buffer, (class_238)boundingBox.method_989(x, y, z), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            matrices.method_22909();
        }
    }

    static {
        SpellEffectsRenderDispatcher.register(SpellType.SHIELD, ShieldSpellRenderer::new);
        SpellEffectsRenderDispatcher.register(SpellType.DARK_VORTEX, DarkVortexSpellRenderer::new);
        SpellEffectsRenderDispatcher.register(SpellType.BUBBLE, BubbleSpellRenderer::new);
        SpellEffectsRenderDispatcher.register(SpellType.PORTAL, PortalSpellRenderer::new);
        SpellEffectsRenderDispatcher.register(SpellType.RAINBOOM, RainboomSpellRenderer::new);
    }

    public static interface RenderDispatcherAccessor {
        public boolean shouldRenderShadows();
    }
}

