/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.compat.trinkets;

import com.minelittlepony.unicopia.compat.trinkets.SlotKey;
import com.minelittlepony.unicopia.compat.trinkets.SpellbookTrinketSlot;
import com.minelittlepony.unicopia.compat.trinkets.TrinketsDelegate;
import com.minelittlepony.unicopia.compat.trinkets.UnicopiaTrinket;
import com.minelittlepony.unicopia.container.SpellbookScreenHandler;
import com.minelittlepony.unicopia.item.enchantment.EnchantmentUtil;
import com.minelittlepony.unicopia.item.enchantment.UEnchantments;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgTrinketBroken;
import com.minelittlepony.unicopia.util.InventoryUtil;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketItem;
import dev.emi.trinkets.api.TrinketsApi;
import dev.emi.trinkets.api.event.TrinketDropCallback;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_5151;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class TrinketsDelegateImpl
implements TrinketsDelegate {
    public static final TrinketsDelegateImpl INSTANCE = new TrinketsDelegateImpl();

    @Override
    public void bootstrap() {
        TrinketDropCallback.EVENT.register((rule, stack, ref, entity) -> {
            if (EnchantmentUtil.getLevel(UEnchantments.HEART_BOUND, stack) > 0) {
                return TrinketEnums.DropRule.KEEP;
            }
            return rule;
        });
    }

    @Override
    public boolean equipStack(class_1309 entity, class_1799 stack) {
        return TrinketItem.equipItem((class_1309)entity, (class_1799)stack);
    }

    @Override
    public Stream<TrinketsDelegate.EquippedStack> getEquipped(class_1309 entity, SlotKey slot, @Nullable Predicate<class_1799> predicate) {
        return TrinketsDelegateImpl.getInventory(entity, slot).stream().flatMap(inventory -> InventoryUtil.slots((class_1263)inventory).filter(s -> !inventory.method_5438(s.intValue()).method_7960() && (predicate == null || predicate.test(inventory.method_5438(s.intValue())))).map(index -> {
            class_1799 oldStack = inventory.method_5438(index.intValue()).method_7972();
            return new TrinketsDelegate.EquippedStack(inventory.method_5438(index.intValue()), () -> ((TrinketInventory)inventory).markUpdate(), stack -> {
                inventory.method_5447(index.intValue(), stack);
                inventory.markUpdate();
            }, l -> {
                inventory.markUpdate();
                Channel.SERVER_TRINKET_BROKEN.sendToSurroundingPlayers((Object)new MsgTrinketBroken(oldStack, entity.method_5628()), (class_1297)entity);
            });
        }));
    }

    @Override
    public void registerTrinket(class_1792 item) {
        TrinketsApi.registerTrinket((class_1792)item, (Trinket)new UnicopiaTrinket(item));
    }

    @Override
    public Optional<class_1735> createSlot(SpellbookScreenHandler handler, class_1309 entity, SlotKey slotId, int i, int x, int y) {
        return TrinketsDelegateImpl.getGroup(entity, slotId).flatMap(group -> TrinketsDelegateImpl.getInventory(entity, slotId).map(inventory -> new SpellbookTrinketSlot(handler, (TrinketInventory)inventory, i, x, y, (SlotGroup)group)));
    }

    @Override
    public boolean isTrinketSlot(class_1735 slot) {
        return slot instanceof TrinketSlot || slot instanceof SpellbookTrinketSlot;
    }

    private static Optional<TrinketComponent> getTrinketComponent(class_1309 entity) {
        try {
            return TrinketsApi.getTrinketComponent((class_1309)entity);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    private static Optional<TrinketInventory> getInventory(class_1309 entity, SlotKey slot) {
        return TrinketsDelegateImpl.getTrinketComponent(entity).map(component -> component.getInventory().getOrDefault(slot.group(), Map.of()).getOrDefault(slot.name(), null));
    }

    private static Stream<TrinketInventory> getInventories(class_1309 entity) {
        return TrinketsDelegateImpl.getTrinketComponent(entity).stream().map(component -> component.getInventory()).flatMap(groups -> groups.values().stream()).flatMap(group -> group.values().stream());
    }

    private static Optional<SlotGroup> getGroup(class_1309 entity, SlotKey slotId) {
        return TrinketsDelegateImpl.getTrinketComponent(entity).stream().map(component -> (SlotGroup)component.getGroups().get(slotId.group())).findFirst();
    }

    public static boolean equipItem(class_1657 user, class_1799 stack) {
        return TrinketsDelegateImpl.getInventories((class_1309)user).filter(inv -> TrinketsDelegateImpl.tryInsert(inv, stack, user)).findFirst().isPresent();
    }

    public static int getMaxCount(class_1799 stack, SlotReference ref, int normal) {
        Trinket trinket = TrinketsApi.getTrinket((class_1792)stack.method_7909());
        if (trinket instanceof UnicopiaTrinket) {
            UnicopiaTrinket ut = (UnicopiaTrinket)trinket;
            return Math.min(normal, Math.min(stack.method_7914(), ut.getMaxCount(stack, ref)));
        }
        return normal;
    }

    private static boolean tryInsert(TrinketInventory inv, class_1799 stack, class_1657 user) {
        int n;
        class_6880 soundEvent;
        int i = InventoryUtil.getOpenSlot((class_1263)inv);
        if (i == -1) {
            return false;
        }
        SlotReference ref = new SlotReference(inv, i);
        if (!TrinketSlot.canInsert((class_1799)stack, (SlotReference)ref, (class_1309)user)) {
            return false;
        }
        Trinket trinket = TrinketsApi.getTrinket((class_1792)stack.method_7909());
        class_5151 q = class_5151.method_48957((class_1799)stack);
        class_6880 class_68802 = soundEvent = q == null ? null : q.method_31570();
        if (trinket instanceof UnicopiaTrinket) {
            UnicopiaTrinket ut = (UnicopiaTrinket)trinket;
            n = ut.getMaxCount(stack, ref);
        } else {
            n = stack.method_7914();
        }
        inv.method_5447(i, stack.method_7971(n));
        if (!stack.method_7960() && soundEvent != null) {
            user.method_32876((class_6880)class_5712.field_28739);
            user.method_5783((class_3414)soundEvent.comp_349(), 1.0f, 1.0f);
        }
        return true;
    }
}

