/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.container.spellbook;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.minelittlepony.unicopia.Debug;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.container.spellbook.Chapter;
import com.minelittlepony.unicopia.container.spellbook.SpellbookChapter;
import com.minelittlepony.unicopia.network.Channel;
import com.minelittlepony.unicopia.network.MsgServerResources;
import com.minelittlepony.unicopia.util.Resources;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class SpellbookChapterLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 ID = Unicopia.id("spellbook/chapters");
    private static final Executor EXECUTOR = CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS);
    public static final SpellbookChapterLoader INSTANCE = new SpellbookChapterLoader();
    private boolean dirty;
    private Map<class_2960, SpellbookChapter> chapters = new HashMap<class_2960, SpellbookChapter>();

    public SpellbookChapterLoader() {
        super(Resources.GSON, ID.method_12832());
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Map<class_2960, SpellbookChapter> getChapters() {
        return this.chapters;
    }

    public void sendUpdate(MinecraftServer server) {
        if (this.dirty) {
            this.dirty = false;
            Channel.SERVER_RESOURCES.sendToAllPlayers((Object)new MsgServerResources(), server);
        }
    }

    protected void apply(Map<class_2960, JsonElement> data, class_3300 manager, class_3695 profiler) {
        try {
            this.chapters = data.entrySet().stream().map(entry -> Chapter.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).ifError(error -> LOGGER.error("Could not load spellbook chapters due to exception {}", error)).result().map(Pair::getFirst).map(chapter -> new IdentifiableChapter((class_2960)entry.getKey(), (Chapter)chapter)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toMap(IdentifiableChapter::id, Function.identity()));
        }
        catch (JsonParseException | IllegalStateException e) {
            LOGGER.error("Could not load spellbook chapters due to exception", e);
        }
        if (Debug.SPELLBOOK_CHAPTERS) {
            CompletableFuture.runAsync(() -> {
                try {
                    class_156.method_43499(executor -> this.method_25931(CompletableFuture::completedFuture, manager, profiler, profiler, class_156.method_18349(), (Executor)executor)).get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                this.dirty = true;
            }, EXECUTOR);
        }
    }

    record IdentifiableChapter(class_2960 id, Chapter chapter) implements SpellbookChapter
    {
        public void write(class_9129 buffer) {
            buffer.method_10812(this.id);
            this.chapter.write(buffer);
        }
    }
}

