/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.datagen.providers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.unicopia.block.UBlocks;
import com.minelittlepony.unicopia.datagen.DataCollector;
import com.minelittlepony.unicopia.server.world.UTreeGen;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public class SeasonsGrowthRatesProvider
implements class_2405 {
    private final DataCollector collectedData;

    public SeasonsGrowthRatesProvider(FabricDataOutput output) {
        this.collectedData = new DataCollector(output.method_45973(class_7784.class_7490.field_39367, "seasons/crop"));
    }

    public String method_10321() {
        return "Seasons Growth Rates";
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        BiConsumer<class_2960, Supplier<JsonElement>> exporter = this.collectedData.prime();
        this.generate((block, crop) -> exporter.accept(class_7923.field_41175.method_10221(block), crop::toJson));
        return this.collectedData.upload(writer);
    }

    private void generate(BiConsumer<class_2248, Crop> exporter) {
        Crop greenApple = new Crop(0.5f, 0.6f, 1.0f, 0.0f);
        exporter.accept(UBlocks.GREEN_APPLE_LEAVES, greenApple);
        exporter.accept(UBlocks.GREEN_APPLE_SPROUT, greenApple);
        exporter.accept(UTreeGen.GREEN_APPLE_TREE.sapling().get(), greenApple);
        Crop sourApple = new Crop(0.25f, 0.5f, 1.0f, 0.5f);
        exporter.accept(UBlocks.SOUR_APPLE_LEAVES, sourApple);
        exporter.accept(UBlocks.SOUR_APPLE_SPROUT, sourApple);
        exporter.accept(UTreeGen.SOUR_APPLE_TREE.sapling().get(), sourApple);
        Crop sweetApple = new Crop(1.0f, 1.0f, 0.6f, 0.0f);
        exporter.accept(UBlocks.SWEET_APPLE_LEAVES, sweetApple);
        exporter.accept(UBlocks.SWEET_APPLE_SPROUT, sweetApple);
        exporter.accept(UTreeGen.SWEET_APPLE_TREE.sapling().get(), sweetApple);
        Crop goldenOak = new Crop(1.5f, 1.4f, 0.6f, 0.0f);
        exporter.accept(UBlocks.GOLDEN_OAK_LEAVES, goldenOak);
        exporter.accept(UBlocks.GOLDEN_OAK_SPROUT, goldenOak);
        exporter.accept(UTreeGen.GOLDEN_OAK_TREE.sapling().get(), goldenOak);
        Crop palm = new Crop(1.1f, 0.9f, 0.2f, 0.0f);
        exporter.accept(UBlocks.PALM_LEAVES, palm);
        exporter.accept(UBlocks.BANANAS, palm);
        exporter.accept(UTreeGen.BANANA_TREE.sapling().get(), palm);
        Crop mango = new Crop(1.0f, 1.6f, 0.5f, 0.0f);
        exporter.accept(UBlocks.MANGO_LEAVES, mango);
        exporter.accept(UTreeGen.MANGO_TREE.sapling().get(), mango);
        Crop oats = new Crop(0.6f, 1.0f, 1.0f, 0.0f);
        exporter.accept((class_2248)UBlocks.OATS_CROWN, oats);
        exporter.accept((class_2248)UBlocks.OATS_STEM, oats);
        exporter.accept((class_2248)UBlocks.OATS, oats);
        exporter.accept(UBlocks.ROCKS, new Crop(1.0f, 1.0f, 1.0f, 1.0f));
        exporter.accept((class_2248)UBlocks.PINEAPPLE, palm);
    }

    record Crop(float spring, float summer, float fall, float winter) {
        JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("spring", (Number)Float.valueOf(this.spring));
            json.addProperty("summer", (Number)Float.valueOf(this.summer));
            json.addProperty("winter", (Number)Float.valueOf(this.winter));
            json.addProperty("fall", (Number)Float.valueOf(this.fall));
            return json;
        }
    }
}

