/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.datagen.providers;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.UTags;
import com.minelittlepony.unicopia.advancement.CustomEventCriterion;
import com.minelittlepony.unicopia.advancement.RaceChangeCriterion;
import com.minelittlepony.unicopia.advancement.RacePredicate;
import com.minelittlepony.unicopia.advancement.SendViaDragonBreathScrollCriterion;
import com.minelittlepony.unicopia.advancement.UCriteria;
import com.minelittlepony.unicopia.datagen.providers.AdvancementDisplayBuilder;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.item.enchantment.UEnchantments;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_170;
import net.minecraft.class_174;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1887;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2010;
import net.minecraft.class_2022;
import net.minecraft.class_2030;
import net.minecraft.class_2035;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2080;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8129;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import net.minecraft.class_9356;
import net.minecraft.class_9360;
import net.minecraft.class_9361;

public class UAdvancementsProvider
extends FabricAdvancementProvider {
    public UAdvancementsProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(output, registryLookup);
    }

    public void generateAdvancement(class_7225.class_7874 registryLookup, Consumer<class_8779> consumer) {
        AdvancementDisplayBuilder.create((class_1935)UItems.ALICORN_BADGE).criterion("crafting_table", UAdvancementsProvider.hasItems(new class_1935[]{class_1802.field_8465})).build(consumer, "root").children(root -> {
            this.createTribeRootAdvancement(registryLookup, consumer, (AdvancementDisplayBuilder.Parent)root, Race.EARTH, new Race[0]).children(consumer, this::generateEarthTribeAdvancementsTree);
            this.createTribeRootAdvancement(registryLookup, consumer, (AdvancementDisplayBuilder.Parent)root, Race.BAT, new Race[0]).children(consumer, this::generateBatTribeAdvancementsTree);
            this.createTribeRootAdvancement(registryLookup, consumer, (AdvancementDisplayBuilder.Parent)root, Race.PEGASUS, new Race[0]).children(consumer, this::generatePegasusTribeAdvancementsTree);
            this.createTribeRootAdvancement(registryLookup, consumer, (AdvancementDisplayBuilder.Parent)root, Race.UNICORN, Race.ALICORN).children(consumer, this::generateUnicornTribeAdvancementsTree);
            this.createTribeRootAdvancement(registryLookup, consumer, (AdvancementDisplayBuilder.Parent)root, Race.HIPPOGRIFF, Race.SEAPONY).children(consumer, this::generateHippogrifTribeAdvancementsTree);
        });
        this.generateEnchantmentsAdvancementsTree(registryLookup, consumer);
    }

    private AdvancementDisplayBuilder.Parent createTribeRootAdvancement(class_7225.class_7874 registryLookup, Consumer<class_8779> consumer, AdvancementDisplayBuilder.Parent root, Race race, Race ... extra) {
        AdvancementDisplayBuilder builder = root.child((class_1935)class_7923.field_41178.method_10223(race.getId().method_48331("_badge"))).showToast().announce().group(race.getId().method_12832()).criterion("be_" + race.getId().method_12832(), UCriteria.PLAYER_CHANGE_RACE.method_53699((class_184)new RaceChangeCriterion.Conditions(Optional.empty(), race)));
        if (extra.length > 0) {
            for (Race r : extra) {
                builder.criterion("be_" + r.getId().method_12832(), UCriteria.PLAYER_CHANGE_RACE.method_53699((class_184)new RaceChangeCriterion.Conditions(Optional.empty(), r)));
            }
            builder.criteriaMerger(class_8782.class_8797.field_1257);
        }
        return builder.build(consumer, race.getId().method_12832() + "_route");
    }

    private void generateEarthTribeAdvancementsTree(Consumer<class_8779> consumer, AdvancementDisplayBuilder.Parent parent) {
        parent.child((class_1935)UItems.ROCK).criterion("has_rock", UAdvancementsProvider.hasItems(new class_1935[]{UItems.ROCK})).build(consumer, "born_on_a_rock_farm").children(p -> {
            p.child((class_1935)UItems.PEBBLES).criterion("killed_entity_with_rock", UAdvancementsProvider.killWithItems(UTags.DamageTypes.FROM_ROCKS)).build(consumer, "sticks_and_stones");
            p.child((class_1935)UItems.WEIRD_ROCK).hidden().criterion("has_rock", UAdvancementsProvider.hasItems(new class_1935[]{UItems.WEIRD_ROCK})).build(consumer, "thats_unusual");
        });
        parent.child((class_1935)UItems.FRIED_AXOLOTL).criterion("eaten_axolotl", class_2010.class_2012.method_8828((class_1935)UItems.FRIED_AXOLOTL)).build(consumer, "tastes_like_chicken");
        parent.child((class_1935)UItems.OATS).criterion("has_oats", UAdvancementsProvider.hasItems(new class_1935[]{UItems.OATS})).build(consumer, "oats_so_easy");
        parent.child((class_1935)class_1802.field_17528).criterion("eat_hay", class_2010.class_2012.method_8828((class_1935)class_1802.field_17528)).build(consumer, "what_the_hay");
        parent.child((class_1935)UItems.COPPER_HORSE_SHOE).criterion("has_horseshoe", UAdvancementsProvider.hasItems(UTags.Items.HORSE_SHOES)).build(consumer, "blacksmith").children(p -> {
            p.child((class_1935)UItems.IRON_HORSE_SHOE).criterion("has_iron_horseshoe", UAdvancementsProvider.hasItems(new class_1935[]{UItems.IRON_HORSE_SHOE})).build(consumer, "change_of_shoes").child((class_1935)UItems.GOLDEN_HORSE_SHOE).criterion("has_gold_horseshoe", UAdvancementsProvider.hasItems(new class_1935[]{UItems.GOLDEN_HORSE_SHOE})).build(consumer, "fashionably_expensive").child((class_1935)UItems.NETHERITE_HORSE_SHOE).criterion("has_netherite_horseshoe", UAdvancementsProvider.hasItems(new class_1935[]{UItems.NETHERITE_HORSE_SHOE})).build(consumer, "overkill");
            p.child((class_1935)UItems.IRON_HORSE_SHOE).hidden().frame(class_189.field_1250).criterion("killed_entity_with_horseshoe", UAdvancementsProvider.killWithItems(UTags.DamageTypes.FROM_HORSESHOES)).build(consumer, "dead_ringer");
        });
        parent.child((class_1935)UItems.PINECONE).frame(class_189.field_1250).criterion("eat_pinecone", class_2010.class_2012.method_8828((class_1935)UItems.PINECONE)).build(consumer, "eat_pinecone");
        parent.child((class_1935)UItems.OAK_BASKET).doNotAnnounce().criterion("has_basket", UAdvancementsProvider.hasItems(UTags.Items.BASKETS)).build(consumer, "basket_case").child((class_1935)class_1802.field_16539).criterion("construct_balloon", CustomEventCriterion.create("construct_balloon")).build(consumer, "aeronaut").child((class_1935)UItems.GIANT_BALLOON).announce().frame(class_189.field_1250).criterion("ride_balloon", CustomEventCriterion.create("ride_balloon")).build(consumer, "travelling_in_style");
        parent.child((class_1935)UItems.MUFFIN).hidden().criterion("has_muffin", UAdvancementsProvider.hasItems(new class_1935[]{UItems.MUFFIN})).build(consumer, "baked_bads");
        parent.child((class_1935)UItems.HORSE_SHOE_FRIES).criterion("has_horse_shoe_fries", UAdvancementsProvider.hasItems(new class_1935[]{UItems.HORSE_SHOE_FRIES})).build(consumer, "lucky");
        parent.child((class_1935)UItems.TOAST).criterion("has_toast", UAdvancementsProvider.hasItems(new class_1935[]{UItems.TOAST})).build(consumer, "toast").child((class_1935)UItems.BURNED_TOAST).hidden().criterion("has_burned_toast", UAdvancementsProvider.hasItems(new class_1935[]{UItems.BURNED_TOAST})).build(consumer, "burn_toast");
        parent.child((class_1935)UItems.GREEN_APPLE).criterion("has_apple", UAdvancementsProvider.hasItems(UTags.Items.FRESH_APPLES)).build(consumer, "apple_route").children(p -> {
            this.requireAllItems(p.child((class_1935)UItems.SWEET_APPLE), new class_1935[]{class_1802.field_8279, UItems.GREEN_APPLE, UItems.SWEET_APPLE, UItems.SOUR_APPLE, UItems.ROTTEN_APPLE, UItems.ZAP_APPLE, UItems.COOKED_ZAP_APPLE, class_1802.field_8463}).build(consumer, "sweet_apple_acres");
            p.child((class_1935)UItems.ZAP_BULB).criterion("has_zap_apple", UAdvancementsProvider.hasItems(new class_1935[]{UItems.ZAP_APPLE})).build(consumer, "trick_apple").children(pp -> {
                pp.child((class_1935)UItems.ZAP_APPLE).hidden().criterion("eat_trick_apple", CustomEventCriterion.createFlying("eat_trick_apple")).build(consumer, "eat_trick_apple");
                pp.child((class_1935)UItems.ZAP_APPLE).hidden().criterion("feed_trick_apple", CustomEventCriterion.createFlying("feed_trick_apple")).build(consumer, "feed_trick_apple");
            });
            p.child((class_1935)UItems.JUICE).criterion("has_juice", UAdvancementsProvider.hasItems(new class_1935[]{UItems.JUICE})).build(consumer, "juice").child((class_1935)UItems.BURNED_JUICE).hidden().criterion("has_burned_juice", UAdvancementsProvider.hasItems(new class_1935[]{UItems.BURNED_JUICE})).build(consumer, "burn_juice").child((class_1935)UItems.CIDER).visible().criterion("has_cider", UAdvancementsProvider.hasItems(new class_1935[]{UItems.CIDER})).rewards(class_170.class_171.method_750((int)12)).build(consumer, "brew_cider");
        });
    }

    private void generatePegasusTribeAdvancementsTree(Consumer<class_8779> consumer, AdvancementDisplayBuilder.Parent parent) {
        parent.child((class_1935)class_1802.field_8614).hidden().frame(class_189.field_1250).criterion("deter_phantom", CustomEventCriterion.createFlying("kill_phantom_while_flying")).rewards(class_170.class_171.method_750((int)100)).build(consumer, "deter_phantom");
        parent.child((class_1935)class_1802.field_8141).criterion("break_window", CustomEventCriterion.createFlying("break_window")).rewards(class_170.class_171.method_750((int)10)).build(consumer, "rainbow_crash");
        parent.child((class_1935)UItems.PEGASUS_BADGE).criterion("fly_through_the_pain", CustomEventCriterion.createFlying("second_wind")).rewards(class_170.class_171.method_750((int)10)).build(consumer, "second_wind");
        parent.child((class_1935)UItems.EMPTY_JAR).criterion("has_empty_jar", UAdvancementsProvider.hasItems(new class_1935[]{UItems.EMPTY_JAR})).build(consumer, "jar").child((class_1935)UItems.RAIN_CLOUD_JAR).criterion("has_cloud_jar", UAdvancementsProvider.hasItems(UTags.Items.CLOUD_JARS)).rewards(class_170.class_171.method_750((int)55)).build(consumer, "gotcha");
        parent.child((class_1935)UItems.LIGHTNING_JAR).frame(class_189.field_1250).criterion("lightning_strike", CustomEventCriterion.createFlying("lightning_strike")).rewards(class_170.class_171.method_750((int)30)).build(consumer, "mid_flight_interruption").children(p -> {
            p.child((class_1935)UItems.LIGHTNING_JAR).hidden().frame(class_189.field_1250).apply(d -> this.applyLightningBugCriterions((AdvancementDisplayBuilder)d, RacePredicate.of(Set.of(Race.CHANGELING), Set.of()), 10, 90)).build(consumer, "lightning_bug");
            p.child((class_1935)UItems.LIGHTNING_JAR).hidden().frame(class_189.field_1250).apply(d -> this.applyLightningBugCriterions((AdvancementDisplayBuilder)d, RacePredicate.of(Set.of(), Set.of(Race.CHANGELING)), 10, 90)).build(consumer, "wonder_bolt");
        });
        parent.child((class_1935)UItems.PEGASUS_FEATHER).hidden().frame(class_189.field_1254).criterion("shed_feather", CustomEventCriterion.createFlying("shed_feather")).rewards(class_170.class_171.method_750((int)1)).build(consumer, "molting_season_1").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 2, 2)).build(consumer, "molting_season_2").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 4, 8)).build(consumer, "molting_season_3").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 8, 20)).build(consumer, "molting_season_4").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 16, 40)).build(consumer, "molting_season_5").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 32, 80)).build(consumer, "molting_season_6").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 64, 200)).build(consumer, "molting_season_7").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 128, 500)).frame(class_189.field_1250).build(consumer, "molting_season_8").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 256, 1000)).frame(class_189.field_1250).build(consumer, "molting_season_9").child((class_1935)UItems.PEGASUS_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 512, 2280)).frame(class_189.field_1250).build(consumer, "molting_season_10").child((class_1935)UItems.GOLDEN_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 1024, 4560)).frame(class_189.field_1250).build(consumer, "molting_season_11").child((class_1935)UItems.GOLDEN_FEATHER).apply(d -> this.applyShedFeatherCriterions((AdvancementDisplayBuilder)d, 2048, 10000)).frame(class_189.field_1249).build(consumer, "dedicated_flier");
    }

    private AdvancementDisplayBuilder requireAllItems(AdvancementDisplayBuilder builder, class_1935 ... items) {
        List.of(items).forEach(item -> builder.criterion("has_" + class_7923.field_41178.method_10221((Object)item.method_8389()).method_12832(), UAdvancementsProvider.hasItems(item)));
        return builder.criteriaMerger(class_8782.class_8797.field_16882);
    }

    private AdvancementDisplayBuilder applyShedFeatherCriterions(AdvancementDisplayBuilder builder, int repeats, int experience) {
        for (int i = 1; i <= repeats; ++i) {
            builder.criterion("shed_feather_" + i, CustomEventCriterion.createFlying("shed_feather", i));
        }
        return builder.criteriaMerger(class_8782.class_8797.field_16882).rewards(class_170.class_171.method_750((int)experience));
    }

    private AdvancementDisplayBuilder applyLightningBugCriterions(AdvancementDisplayBuilder builder, RacePredicate race, int repeats, int experience) {
        for (int i = 1; i <= repeats; ++i) {
            builder.criterion("lightning_struck_player_" + i, UCriteria.CUSTOM_EVENT.method_53699((class_184)new CustomEventCriterion.Conditions(Optional.empty(), "lightning_struck_player", race, TriState.TRUE, i)));
        }
        return builder.criteriaMerger(class_8782.class_8797.field_16882).rewards(class_170.class_171.method_750((int)experience));
    }

    private void generateUnicornTribeAdvancementsTree(Consumer<class_8779> consumer, AdvancementDisplayBuilder.Parent parent) {
        parent.child((class_1935)UItems.SPELLBOOK).criterion("has_spellbook", UAdvancementsProvider.hasItems(new class_1935[]{UItems.SPELLBOOK})).build(consumer, "books").children(p -> {
            p.child((class_1935)UItems.CRYSTAL_SHARD).criterion("has_shard", UAdvancementsProvider.hasItems(new class_1935[]{UItems.CRYSTAL_SHARD})).build(consumer, "crystaline").children(pp -> pp.child((class_1935)UItems.CRYSTAL_HEART).criterion("power_up_heart", CustomEventCriterion.create("power_up_heart")).rewards(class_170.class_171.method_750((int)105)).build(consumer, "power_up_heart"));
            p.child((class_1935)UItems.ALICORN_AMULET).criterion("has_alicorn_amulet", UAdvancementsProvider.hasItems(new class_1935[]{UItems.ALICORN_AMULET})).build(consumer, "tempted").child((class_1935)class_1802.field_22421).criterion("light_altar", CustomEventCriterion.create("light_altar")).build(consumer, "hello_darkness_my_old_friend").child((class_1935)UItems.BROKEN_ALICORN_AMULET).frame(class_189.field_1249).criterion("defeat_sombra", CustomEventCriterion.create("defeat_sombra")).rewards(class_170.class_171.method_750((int)2000)).build(consumer, "save_the_day").children(pp -> {
                pp.child((class_1935)UItems.UNICORN_AMULET).frame(class_189.field_1249).criterion("obtain_the_thing", UAdvancementsProvider.hasItems(new class_1935[]{UItems.UNICORN_AMULET})).rewards(class_170.class_171.method_750((int)1100)).build(consumer, "ascension");
                pp.child((class_1935)UItems.BROKEN_ALICORN_AMULET).hidden().frame(class_189.field_1250).criterion("defeat_sombra_again", CustomEventCriterion.create("defeat_sombra", 2)).rewards(class_170.class_171.method_750((int)2000)).build(consumer, "doctor_sombrero");
            });
            p.child((class_1935)class_1802.field_8705).criterion("split_sea", CustomEventCriterion.create("split_sea")).rewards(class_170.class_171.method_750((int)105)).build(consumer, "split_the_sea");
        });
        parent.child((class_1935)UItems.DRAGON_BREATH_SCROLL).showToast().announce().criterion("has_scroll", UAdvancementsProvider.hasItems(new class_1935[]{UItems.DRAGON_BREATH_SCROLL})).build(consumer, "take_a_note").children(p -> {
            p.child((class_1935)UItems.DRAGON_BREATH_SCROLL).criterion("send_book", UAdvancementsProvider.dragonScroll(false, new class_1935[]{class_1802.field_8360})).build(consumer, "dear_princess").child((class_1935)UItems.DRAGON_BREATH_SCROLL).criterion("send_scroll", UAdvancementsProvider.dragonScroll(false, new class_1935[]{UItems.DRAGON_BREATH_SCROLL})).build(consumer, "i_await_your_reply");
            p.child((class_1935)UItems.IMPORTED_OATS).hidden().frame(class_189.field_1250).criterion("send_oats", UAdvancementsProvider.dragonScroll(false, new class_1935[]{UItems.OATS, UItems.IMPORTED_OATS})).criterion("receieve_oats", UAdvancementsProvider.dragonScroll(true, new class_1935[]{UItems.IMPORTED_OATS})).criteriaMerger(class_8782.class_8797.field_1257).build(consumer, "imported_oats");
            p.child((class_1935)class_1802.field_8750).hidden().frame(class_189.field_1250).criterion("ding_sun", UAdvancementsProvider.dingCelestia(Set.of(), Set.of(Race.BAT))).build(consumer, "blasphemy");
            p.child((class_1935)class_1802.field_8750).hidden().frame(class_189.field_1250).criterion("ding_sun", UAdvancementsProvider.dingCelestia(Set.of(Race.BAT), Set.of())).build(consumer, "sweet_sweet_revenge");
        });
        parent.child((class_1935)UItems.PEGASUS_AMULET).hidden().frame(class_189.field_1250).criterion("teleport_above_world", CustomEventCriterion.create("teleport_above_world")).rewards(class_170.class_171.method_750((int)100)).build(consumer, "a_falling_wizard");
    }

    private void generateBatTribeAdvancementsTree(Consumer<class_8779> consumer, AdvancementDisplayBuilder.Parent parent) {
        parent.child((class_1935)class_1802.field_30904).criterion("look_into_sun", CustomEventCriterion.create("look_into_sun")).build(consumer, "praise_the_sun").children(p -> {
            p.child((class_1935)UItems.SUNGLASSES).criterion("wear_shades", CustomEventCriterion.create("wear_shades")).build(consumer, "cool_potato");
            p.child((class_1935)class_1802.field_27062).frame(class_189.field_1250).criterion("screech_twenty_mobs", CustomEventCriterion.createFlying("screech_twenty_mobs")).build(consumer, "screech_twenty_mobs").child((class_1935)class_1802.field_8621).frame(class_189.field_1250).criterion("super_scare_entity", CustomEventCriterion.createFlying("super_scare_entity")).build(consumer, "extra_spooky");
            p.child((class_1935)class_1802.field_27062).frame(class_189.field_1250).criterion("screech_self", CustomEventCriterion.createFlying("screech_self")).build(consumer, "screech_self");
        });
    }

    private void generateHippogrifTribeAdvancementsTree(Consumer<class_8779> consumer, AdvancementDisplayBuilder.Parent parent) {
        parent.child((class_1935)UItems.BAITED_FISHING_ROD).showToast().announce().criterion("has_baited_fishing_rod", UAdvancementsProvider.hasItems(new class_1935[]{UItems.BAITED_FISHING_ROD})).build(consumer, "bait");
        parent.child((class_1935)UItems.PEARL_NECKLACE).showToast().announce().criterion("seapony_transition", UCriteria.CUSTOM_EVENT.method_53699((class_184)new CustomEventCriterion.Conditions(Optional.empty(), "seapony_transition", RacePredicate.of(Set.of(Race.SEAPONY), Set.of()), TriState.DEFAULT, 1))).build(consumer, "shoo_be_doo").child((class_1935)UItems.PEARL_NECKLACE).showToast().announce().criterion("seapony_transition", UCriteria.CUSTOM_EVENT.method_53699((class_184)new CustomEventCriterion.Conditions(Optional.empty(), "seapony_transition", RacePredicate.of(Set.of(), Set.of(Race.SEAPONY)), TriState.DEFAULT, 1))).build(consumer, "shoo_be_done");
    }

    private void generateEnchantmentsAdvancementsTree(class_7225.class_7874 registryLookup, Consumer<class_8779> consumer) {
        class_7225.class_7226 enchantments = registryLookup.method_46762(class_7924.field_41265);
        AdvancementDisplayBuilder.create((class_1935)class_1802.field_22021).showToast().announce().criterion("enchant_with_consumption", UAdvancementsProvider.enchant((class_6880<class_1887>)enchantments.method_46747(UEnchantments.CONSUMPTION))).rewards(class_170.class_171.method_750((int)120)).parent(class_2960.method_60656((String)"story/enchant_item")).group("enchanting").build(consumer, "experimental").child((class_1935)class_1802.field_22024).criterion("use_consumption", CustomEventCriterion.create("use_consumption")).rewards(class_170.class_171.method_750((int)1200)).group("enchanting").hidden().build(consumer, "xp_miner");
        AdvancementDisplayBuilder.create((class_1935)class_1802.field_8463).showToast().announce().criterion("enchant_with_heart_bound", UAdvancementsProvider.enchant((class_6880<class_1887>)enchantments.method_46747(UEnchantments.HEART_BOUND))).rewards(class_170.class_171.method_750((int)120)).parent(class_2960.method_60656((String)"story/enchant_item")).group("enchanting").build(consumer, "hearts_stronger_than_horses").child((class_1935)class_1802.field_8335).criterion("use_soulmate", CustomEventCriterion.create("use_soulmate")).rewards(class_170.class_171.method_750((int)1200)).group("enchanting").hidden().build(consumer, "soulmate");
    }

    public static class_175<?> enchant(class_6880<class_1887> enchantment) {
        return class_174.field_1181.method_53699((class_184)new class_2030.class_2032(Optional.empty(), Optional.of(class_2073.class_2074.method_8973().method_58179(class_9361.field_49807, (class_9360)class_9356.method_58173(List.of(new class_2035(enchantment, class_2096.class_2100.field_9708)))).method_8976()), class_2096.class_2100.field_9708));
    }

    public static class_175<?> dragonScroll(boolean receiving, class_1935 ... items) {
        return UAdvancementsProvider.dragonScroll(receiving, class_2073.class_2074.method_8973().method_8977(items).method_8976());
    }

    public static class_175<?> dragonScroll(boolean receiving, class_2073 items) {
        return UCriteria.SEND_DRAGON_BREATH.method_53699((class_184)new SendViaDragonBreathScrollCriterion.Conditions(Optional.empty(), Optional.of(items), receiving, Optional.empty(), TriState.DEFAULT, Optional.empty(), RacePredicate.EMPTY));
    }

    static class_175<?> hasItems(class_1935 ... items) {
        return class_2066.class_2068.method_8959((class_1935[])items);
    }

    static class_175<?> hasItems(class_6862<class_1792> items) {
        return class_2066.class_2068.method_8957((class_2073[])new class_2073[]{class_2073.class_2074.method_8973().method_8975(items).method_8976()});
    }

    static class_175<?> killWithItems(class_6862<class_8110> tag) {
        return class_2080.class_2083.method_35250(Optional.empty(), Optional.of(class_2022.class_2023.method_8855().method_48785(class_8129.method_48965(tag)).method_8851()));
    }

    static class_175<?> dingCelestia(Set<Race> includeTribes, Set<Race> excludeTribes) {
        return UCriteria.SEND_DRAGON_BREATH.method_53699((class_184)new SendViaDragonBreathScrollCriterion.Conditions(Optional.empty(), Optional.of(class_2073.class_2074.method_8973().method_8975(UTags.Items.IS_DELIVERED_AGGRESSIVELY).method_8976()), false, Optional.of("princess celestia"), TriState.FALSE, Optional.of("dings_on_celestias_head"), RacePredicate.of(includeTribes, excludeTribes)));
    }
}

