/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.datagen.providers.recipe;

import com.minelittlepony.unicopia.ability.magic.spell.crafting.IngredientWithSpell;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.SpellCraftingRecipe;
import com.minelittlepony.unicopia.ability.magic.spell.crafting.TraitIngredient;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.ability.magic.spell.trait.SpellTraits;
import com.minelittlepony.unicopia.advancement.TraitDiscoveredCriterion;
import com.minelittlepony.unicopia.item.EnchantableItem;
import com.minelittlepony.unicopia.item.UItems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class SpellcraftingRecipeJsonBuilder {
    private final Map<String, class_175<?>> criterions = new LinkedHashMap();
    @Nullable
    private String group;
    private final class_7800 category;
    private IngredientWithSpell base = IngredientWithSpell.mundane((class_1935)UItems.GEMSTONE);
    private final SpellType<?> spell;
    private final class_1935 gem;
    private final List<IngredientWithSpell> ingredients = new ArrayList<IngredientWithSpell>();
    private SpellTraits traits = SpellTraits.EMPTY;

    public static SpellcraftingRecipeJsonBuilder create(class_7800 category, class_1935 gem, SpellType<?> spell) {
        return new SpellcraftingRecipeJsonBuilder(category, gem, spell);
    }

    private SpellcraftingRecipeJsonBuilder(class_7800 category, class_1935 gem, SpellType<?> spell) {
        this.category = category;
        this.gem = gem;
        this.spell = spell;
    }

    public SpellcraftingRecipeJsonBuilder base(class_1935 gem, SpellType<?> spell) {
        this.base = IngredientWithSpell.of(gem, spell);
        return this;
    }

    public SpellcraftingRecipeJsonBuilder input(class_1935 gem, SpellType<?> spell) {
        this.ingredients.add(IngredientWithSpell.of(gem, spell));
        return this;
    }

    public SpellcraftingRecipeJsonBuilder traits(SpellTraits.Builder traits) {
        this.traits = traits.build();
        return this;
    }

    public SpellcraftingRecipeJsonBuilder criterion(String name, class_175<?> condition) {
        this.criterions.put(name, condition);
        return this;
    }

    public SpellcraftingRecipeJsonBuilder group(String group) {
        this.group = group;
        return this;
    }

    public void offerTo(class_8790 exporter, class_2960 id) {
        if (!this.traits.isEmpty()) {
            this.criterions.put("has_traits", TraitDiscoveredCriterion.create(this.traits.stream().map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet())));
        }
        Preconditions.checkState((!this.criterions.isEmpty() ? 1 : 0) != 0, (Object)("No way of obtaining recipe " + String.valueOf(id)));
        class_161.class_162 advancementBuilder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)id)).method_703(class_170.class_171.method_753((class_2960)id)).method_704(class_8782.class_8797.field_1257);
        this.criterions.forEach((arg_0, arg_1) -> ((class_161.class_162)advancementBuilder).method_705(arg_0, arg_1));
        exporter.method_53819(id, (class_1860)new SpellCraftingRecipe(this.base, TraitIngredient.of(this.traits), this.ingredients, EnchantableItem.enchant(this.gem.method_8389().method_7854(), this.spell)), advancementBuilder.method_695(id.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    public void offerTo(class_8790 exporter) {
        this.offerTo(exporter, this.spell.getId());
    }

    public void offerTo(class_8790 exporter, String recipePath) {
        class_2960 recipeId = class_2960.method_60654((String)recipePath);
        if (recipeId.equals((Object)this.spell.getId())) {
            throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
        }
        this.offerTo(exporter, recipeId);
    }
}

