/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.diet;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.diet.DietProfile;
import com.minelittlepony.unicopia.diet.FoodGroup;
import com.minelittlepony.unicopia.diet.FoodGroupEffects;
import com.minelittlepony.unicopia.diet.PonyDiets;
import com.minelittlepony.unicopia.util.Resources;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.slf4j.Logger;

public class DietsLoader
implements IdentifiableResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2960 ID = Unicopia.id("diets");

    public class_2960 getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> method_25931(class_3302.class_4045 sync, class_3300 manager, class_3695 prepareProfiler, class_3695 applyProfiler, Executor prepareExecutor, Executor applyExecutor) {
        CompletableFuture<Map> foodGroupsFuture = CompletableFuture.supplyAsync(() -> {
            HashMap foodGroups = new HashMap();
            for (Map.Entry<class_2960, JsonElement> group : DietsLoader.loadData(manager, prepareExecutor, "diet/food_groups").entrySet()) {
                try {
                    FoodGroup.EFFECTS_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)group.getValue()).resultOrPartial(error -> LOGGER.error("Could not load food group {}: {}", group.getKey(), error)).ifPresent(value -> foodGroups.put((class_2960)group.getKey(), new FoodGroup((class_2960)group.getKey(), (FoodGroupEffects)value)));
                }
                catch (Throwable t) {
                    LOGGER.error("Could not load food effects {}", (Object)group.getKey(), (Object)t);
                }
            }
            return foodGroups;
        }, prepareExecutor);
        CompletableFuture<Map> profilesFuture = CompletableFuture.supplyAsync(() -> {
            HashMap profiles = new HashMap();
            for (Map.Entry<class_2960, JsonElement> entry : DietsLoader.loadData(manager, prepareExecutor, "diet/races").entrySet()) {
                class_2960 id = entry.getKey();
                try {
                    Race.REGISTRY.method_17966(id).ifPresentOrElse(race -> DietProfile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue())).resultOrPartial(error -> LOGGER.error("Could not load diet profile {}: {}", (Object)id, error)).ifPresent(profile -> profiles.put(race, profile)), () -> LOGGER.warn("Skipped diet for unknown race: " + String.valueOf(id)));
                }
                catch (Throwable t) {
                    LOGGER.error("Could not load diet profile {}", (Object)id, (Object)t);
                }
            }
            return profiles;
        }, prepareExecutor);
        return ((CompletableFuture)CompletableFuture.allOf(foodGroupsFuture, profilesFuture).thenCompose(arg_0 -> ((class_3302.class_4045)sync).method_18352(arg_0))).thenAcceptAsync(v -> {
            Map<Race, DietProfile> profiles = profilesFuture.getNow(Map.of());
            Map<class_2960, FoodGroup> foodGroups = foodGroupsFuture.getNow(Map.of());
            profiles.entrySet().removeIf(entry -> {
                StringBuilder issueList = new StringBuilder();
                ((DietProfile)entry.getValue()).validate(issue -> issueList.append(System.lineSeparator()).append((String)issue), foodGroups::containsKey);
                if (!issueList.isEmpty()) {
                    LOGGER.error("Could not load diet profile {}. Caused by {}", entry.getKey(), (Object)issueList.toString());
                }
                return !issueList.isEmpty();
            });
            PonyDiets.load(new PonyDiets(profiles, foodGroups));
        }, applyExecutor);
    }

    private static Map<class_2960, JsonElement> loadData(class_3300 manager, Executor prepareExecutor, String path) {
        HashMap<class_2960, JsonElement> results = new HashMap<class_2960, JsonElement>();
        class_4309.method_51148((class_3300)manager, (String)path, (Gson)Resources.GSON, results);
        return results;
    }
}

