/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.diet;

import com.minelittlepony.unicopia.diet.Ailment;
import com.minelittlepony.unicopia.diet.Effect;
import com.minelittlepony.unicopia.diet.FoodAttributes;
import com.minelittlepony.unicopia.diet.FoodGroupKey;
import com.minelittlepony.unicopia.diet.affliction.Affliction;
import com.minelittlepony.unicopia.item.UFoodComponents;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FoodGroupEffects(List<FoodGroupKey> tags, Optional<FoodAttributes> foodAttributes, Ailment ailment) implements Effect
{
    public static Codec<FoodGroupEffects> createCodec(Codec<FoodGroupKey> keyCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)keyCodec.listOf().fieldOf("tags").forGetter(FoodGroupEffects::tags), (App)FoodAttributes.CODEC.optionalFieldOf("food_attributes").forGetter(FoodGroupEffects::foodAttributes), (App)Ailment.CODEC.fieldOf("ailment").forGetter(FoodGroupEffects::ailment)).apply((Applicative)instance, FoodGroupEffects::new));
    }

    public static final class_9139<class_9129, FoodGroupEffects> createPacketCodec(class_9139<ByteBuf, FoodGroupKey> keyCodec) {
        return class_9139.method_56436((class_9139)keyCodec.method_56433(class_9135.method_56363()), FoodGroupEffects::tags, (class_9139)class_9135.method_56382(FoodAttributes.PACKET_CODEC), FoodGroupEffects::foodAttributes, Ailment.PACKET_CODEC, FoodGroupEffects::ailment, FoodGroupEffects::new);
    }

    @Override
    public void appendTooltip(class_1799 stack, Consumer<class_2561> tooltip, class_1836 context) {
        this.tags.forEach(tag -> {
            if (tag.contains(stack)) {
                tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)class_156.method_646((String)"tag", (class_2960)tag.id()))).method_27692(class_124.field_1080));
            }
        });
        Effect.super.appendTooltip(stack, tooltip, context);
    }

    public static final class Builder {
        private final List<FoodGroupKey> tags = new ArrayList<FoodGroupKey>();
        private Optional<FoodAttributes> food = Optional.empty();
        private Ailment ailment = Ailment.EMPTY;

        public Builder tag(class_2960 tag) {
            return this.tag((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tag));
        }

        public Builder tag(class_6862<class_1792> tag) {
            this.tags.add(FoodGroupKey.TAG_LOOKUP.apply(tag));
            return this;
        }

        public Builder ailment(Affliction affliction) {
            this.ailment = new Ailment(affliction);
            return this;
        }

        public Builder food(int hunger, float saturation) {
            return this.food(UFoodComponents.builder(hunger, saturation));
        }

        public Builder food(class_4174.class_4175 food) {
            return this.food(food.method_19242());
        }

        public Builder food(class_4174 food) {
            this.food = Optional.of(new FoodAttributes(food));
            return this;
        }

        public FoodGroupEffects build() {
            return new FoodGroupEffects(this.tags, this.food, this.ailment);
        }
    }
}

