/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity;

import com.minelittlepony.unicopia.Affinity;
import com.minelittlepony.unicopia.InteractionManager;
import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.WeaklyOwned;
import com.minelittlepony.unicopia.ability.magic.Affine;
import com.minelittlepony.unicopia.ability.magic.Levelled;
import com.minelittlepony.unicopia.ability.magic.spell.effect.TargetSelecter;
import com.minelittlepony.unicopia.entity.AmuletSelectors;
import com.minelittlepony.unicopia.entity.EntityPhysics;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.Living;
import com.minelittlepony.unicopia.entity.MagicImmune;
import com.minelittlepony.unicopia.entity.Physics;
import com.minelittlepony.unicopia.entity.ai.BreakHeartGoal;
import com.minelittlepony.unicopia.entity.ai.DynamicTargetGoal;
import com.minelittlepony.unicopia.entity.ai.EatMuffinGoal;
import com.minelittlepony.unicopia.entity.ai.FleeExplosionGoal;
import com.minelittlepony.unicopia.entity.ai.PredicatedGoal;
import com.minelittlepony.unicopia.entity.ai.PrioritizedActiveTargetGoal;
import com.minelittlepony.unicopia.entity.ai.TargettingUtil;
import com.minelittlepony.unicopia.entity.ai.WantItTakeItGoal;
import com.minelittlepony.unicopia.entity.mob.UEntityAttributes;
import com.minelittlepony.unicopia.network.track.DataTracker;
import com.minelittlepony.unicopia.network.track.TrackableDataType;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1452;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Creature
extends Living<class_1309>
implements WeaklyOwned.Mutable<class_1309> {
    private final EntityPhysics<class_1309> physics;
    private final EntityReference<class_1309> owner = new EntityReference();
    private Optional<class_1355> goals = Optional.empty();
    private int eatTimer;
    @Nullable
    private EatMuffinGoal eatMuffinGoal;
    private int smittenTicks;
    private final Predicate<class_1309> targetPredicate = TargetSelecter.validTarget(() -> this.getOriginatingCaster().getAffinity(), this).and(e -> Equine.of(e).filter(eq -> eq instanceof Creature).filter(eq -> this.isDiscorded() != ((Creature)eq).hasCommonOwner(this)).isEmpty());
    protected final DataTracker.Entry<Integer> eating;
    protected final DataTracker.Entry<Boolean> discorded;
    protected final DataTracker.Entry<Boolean> smitten;

    public static void boostrap() {
    }

    public Creature(class_1309 entity) {
        super(entity);
        this.physics = new EntityPhysics<class_1309>(entity);
        this.addTicker(this.physics);
        this.addTicker(this::updateConsumption);
        this.tracker.startTracking(this.owner);
        this.eating = this.tracker.startTracking(TrackableDataType.INT, 0);
        this.discorded = this.tracker.startTracking(TrackableDataType.BOOLEAN, false);
        this.smitten = this.tracker.startTracking(TrackableDataType.BOOLEAN, false);
    }

    @Override
    public void setMaster(class_1309 owner) {
        this.owner.set(owner);
    }

    public boolean isMinion() {
        return this.getMasterReference().isSet();
    }

    public boolean isDiscorded() {
        return this.discorded.get();
    }

    public boolean isSmitten() {
        return this.smitten.get();
    }

    public void setSmitten(boolean smitten) {
        this.smittenTicks = smitten ? 20 : 0;
        this.smitten.set(smitten);
    }

    public void setDiscorded(boolean discorded) {
        this.discorded.set(discorded);
    }

    @Override
    @NotNull
    public class_1309 getMaster() {
        return this.getMasterReference().getOrEmpty(this.asWorld()).orElse(this.entity);
    }

    @Override
    public EntityReference<class_1309> getMasterReference() {
        return this.owner;
    }

    public Optional<class_1355> getGoals() {
        return this.goals;
    }

    public void initAi(class_1355 goals, class_1355 targets) {
        class_1548 mob;
        class_1309 class_13092;
        this.goals = Optional.of(goals);
        if (this.entity instanceof MagicImmune) {
            return;
        }
        DynamicTargetGoal targetter = new DynamicTargetGoal((class_1308)this.entity);
        targets.method_6277(1, (class_1352)targetter);
        if (!InteractionManager.getInstance().getSyncedConfig().wantItNeedItExcludeList().contains(class_1299.method_5890((class_1299)this.entity.method_5864()).toString())) {
            goals.method_6277(1, (class_1352)new WantItTakeItGoal(this, targetter));
        }
        if (this.entity.method_5864().method_5891() == class_1311.field_6302) {
            goals.method_6277(3, (class_1352)new BreakHeartGoal((class_1308)this.entity, targetter));
            if (this.entity instanceof class_1547) {
                targets.method_6277(1, new PrioritizedActiveTargetGoal<class_1657>((class_1308)this.entity, class_1657.class, TargettingUtil.FLYING_PREFERRED, true));
            }
        }
        if ((class_13092 = this.entity) instanceof class_1452) {
            class_1452 pig = (class_1452)class_13092;
            this.eatMuffinGoal = new EatMuffinGoal((class_1308)pig, targetter);
            goals.method_6277(3, (class_1352)this.eatMuffinGoal);
        }
        if ((class_13092 = this.entity) instanceof class_1321) {
            class_1321 tameable = (class_1321)class_13092;
            goals.method_6277(3, (class_1352)new FleeExplosionGoal((class_1314)tameable, 6.0f, 1.0, 1.2));
        }
        if ((class_13092 = this.entity) instanceof class_1548) {
            mob = (class_1548)class_13092;
            goals.method_6277(1, (class_1352)new class_1338((class_1314)mob, class_1309.class, 10.0f, 1.5, 1.9, AmuletSelectors.ALICORN_AMULET));
        }
        if ((class_13092 = this.entity) instanceof class_1296) {
            mob = (class_1296)class_13092;
            goals.method_6277(1, (class_1352)new class_1338((class_1314)mob, class_1309.class, 10.0f, 1.1, 1.7, AmuletSelectors.ALICORN_AMULET_AFTER_1_DAYS));
        }
        BooleanSupplier isMinion = () -> this.getMasterReference().isSet();
        BooleanSupplier isNotMinion = () -> !isMinion.getAsBoolean();
        PredicatedGoal.applyToAll(targets, isNotMinion);
        targets.method_6277(2, (class_1352)new PredicatedGoal((class_1352)new ActiveEnemyGoal<class_1657>(this, class_1657.class), isMinion));
        targets.method_6277(2, (class_1352)new PredicatedGoal((class_1352)new ActiveEnemyGoal<class_1588>(this, class_1588.class), isMinion));
        targets.method_6277(2, (class_1352)new PredicatedGoal((class_1352)new ActiveEnemyGoal<class_1621>(this, class_1621.class), isMinion));
        class_1309 class_13093 = this.entity;
        if (class_13093 instanceof class_1308) {
            class_1308 mob2 = (class_1308)class_13093;
            BooleanSupplier isDiscorded = () -> isNotMinion.getAsBoolean() && this.isDiscorded();
            PredicatedGoal.applyToAll(goals, () -> !isDiscorded.getAsBoolean());
            goals.method_6277(1, (class_1352)new PredicatedGoal((class_1352)new class_1347(mob2), isDiscorded));
            if (mob2 instanceof class_1314) {
                class_1314 pae = (class_1314)mob2;
                goals.method_6277(5, (class_1352)new PredicatedGoal((class_1352)new class_1394(pae, 0.8), isDiscorded));
            }
            goals.method_6277(6, (class_1352)new PredicatedGoal((class_1352)new class_1361(mob2, class_1657.class, 8.0f), isDiscorded));
            goals.method_6277(6, (class_1352)new PredicatedGoal((class_1352)new class_1376(mob2), isDiscorded));
        }
    }

    public static void registerAttributes(class_5132.class_5133 builder) {
        builder.method_26867(class_5134.field_23721);
        builder.method_26867(class_5134.field_23722);
        builder.method_26867(UEntityAttributes.ENTITY_GRAVITY_MODIFIER);
    }

    @Override
    public boolean beforeUpdate() {
        if (this.isDiscorded()) {
            this.spawnParticles((class_2394)class_2398.field_29644, 1);
        }
        if (!this.isClient() && this.smittenTicks > 0 && --this.smittenTicks <= 0) {
            this.setSmitten(false);
        }
        return super.beforeUpdate();
    }

    private void updateConsumption() {
        if (this.isClient()) {
            this.eatTimer = this.eating.get();
        } else if (this.eatMuffinGoal != null) {
            this.eatTimer = this.eatMuffinGoal.getTimer();
            this.eating.set(this.eatTimer);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatTimer <= 0) {
            return 0.0f;
        }
        if (this.eatTimer >= 4 && this.eatTimer <= 36) {
            return 1.0f;
        }
        if (this.eatTimer < 4) {
            return ((float)this.eatTimer - delta) / 4.0f;
        }
        return -((float)(this.eatTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatTimer > 4 && this.eatTimer <= 36) {
            float f = ((float)(this.eatTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * class_3532.method_15374((float)(f * 28.7f));
        }
        if (this.eatTimer > 0) {
            return 0.62831855f;
        }
        return this.entity.method_36455() * ((float)Math.PI / 180);
    }

    @Override
    public Race getSpecies() {
        return Race.HUMAN;
    }

    @Override
    public Physics getPhysics() {
        return this.physics;
    }

    @Override
    public void setSpecies(Race race) {
    }

    @Override
    public Levelled.LevelStore getLevel() {
        return Levelled.ZERO;
    }

    @Override
    public Levelled.LevelStore getCorruption() {
        return Levelled.ZERO;
    }

    @Override
    public boolean subtractEnergyCost(double amount) {
        this.getMaster().method_5643(this.asEntity().method_48923().method_48831(), (float)((int)amount / 2));
        return this.getMaster().method_6032() > 0.0f;
    }

    @Override
    public Affinity getAffinity() {
        if (this.getMaster() instanceof Affine) {
            Affinity affinity = ((Affine)this.getMaster()).getAffinity();
            if (this.isDiscorded()) {
                return affinity == Affinity.BAD ? Affinity.GOOD : (affinity == Affinity.GOOD ? Affinity.BAD : affinity);
            }
            return affinity;
        }
        return Affinity.NEUTRAL;
    }

    @Override
    public void toNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.toNBT(compound, lookup);
        compound.method_10566("master", (class_2520)this.getMasterReference().toNBT(lookup));
        this.physics.toNBT(compound, lookup);
        compound.method_10556("discorded", this.isDiscorded());
    }

    @Override
    public void fromNBT(class_2487 compound, class_7225.class_7874 lookup) {
        super.fromNBT(compound, lookup);
        if (compound.method_10573("master", 10)) {
            this.getMasterReference().fromNBT(compound.method_10562("master"), lookup);
        }
        this.physics.fromNBT(compound, lookup);
        this.setDiscorded(compound.method_10577("discorded"));
    }

    private class ActiveEnemyGoal<T extends class_1309>
    extends class_1400<T> {
        public ActiveEnemyGoal(Creature creature, Class<T> targetClass) {
            super((class_1308)creature.entity, targetClass, true, creature.targetPredicate);
        }

        public boolean method_6266() {
            class_1309 target = this.field_6660.method_5968();
            return target != null && this.field_6642.method_18419((class_1309)this.field_6660, target) && super.method_6266();
        }
    }
}

