/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.entity.behaviour.Guest;
import com.minelittlepony.unicopia.entity.mob.StationaryObjectEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.item.UItems;
import com.minelittlepony.unicopia.particle.ParticleUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_5431;
import org.jetbrains.annotations.Nullable;

public class CrystalShardsEntity
extends StationaryObjectEntity {
    static final byte SHAKE = 1;
    static final int FULL_GROWTH_AGE = 25;
    private static final Set<class_2350> ALL_DIRECTIONS = Set.of(class_2350.values());
    private static final class_2940<class_2350> ATTACHMENT_FACE = class_2945.method_12791(CrystalShardsEntity.class, (class_2941)class_2943.field_13321);
    private static final class_2940<Integer> GROWTH = class_2945.method_12791(CrystalShardsEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DECAYING = class_2945.method_12791(CrystalShardsEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CORRUPT = class_2945.method_12791(CrystalShardsEntity.class, (class_2941)class_2943.field_13323);
    private int prevAge;
    private int ticksShaking;

    public static boolean infestBlock(class_3218 world, class_2338 pos) {
        if (world.method_22347(pos) || !world.method_8316(pos).method_39360(class_3612.field_15906)) {
            return false;
        }
        boolean success = false;
        for (class_2350 face : CrystalShardsEntity.getFreeFaces((class_1937)world, pos)) {
            CrystalShardsEntity shards = (CrystalShardsEntity)UEntities.CRYSTAL_SHARDS.method_5883((class_1937)world);
            shards.method_33574(pos.method_10093(face).method_46558());
            shards.setAttachmentFace(face);
            shards.setCorrupt(true);
            world.method_8649((class_1297)shards);
            success = true;
        }
        return success;
    }

    public static Set<class_2350> getFreeFaces(class_1937 world, class_2338 pos) {
        HashSet<class_2350> freeFaces = new HashSet<class_2350>(ALL_DIRECTIONS);
        freeFaces.removeAll(CrystalShardsEntity.getOccupiedFaces(world, pos));
        freeFaces.removeIf(face -> CrystalShardsEntity.isInvalid(world, pos.method_10093(face), face));
        return freeFaces;
    }

    public static Set<class_2350> getOccupiedFaces(class_1937 world, class_2338 pos) {
        return world.method_8390(CrystalShardsEntity.class, new class_238(pos).method_1014(4.0), class_1301.field_6154).stream().map(e -> e.getAttachmentFace()).distinct().collect(Collectors.toSet());
    }

    static boolean isInvalid(class_1937 world, class_2338 crystalPos, class_2350 attachmentFace) {
        if (!world.method_22347(crystalPos) || world.method_31606(crystalPos)) {
            return true;
        }
        class_2338 attachmentPos = crystalPos.method_10093(attachmentFace.method_10153());
        return !world.method_8320(attachmentPos).method_30368((class_1922)world, attachmentPos, attachmentFace, class_5431.field_25824);
    }

    public CrystalShardsEntity(class_1299<CrystalShardsEntity> type, class_1937 world) {
        super(type, world);
        this.method_36456(world.method_8409().method_43057() * 360.0f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ATTACHMENT_FACE, (Object)class_2350.field_11036);
        builder.method_56912(GROWTH, (Object)0);
        builder.method_56912(DECAYING, (Object)false);
        builder.method_56912(CORRUPT, (Object)false);
    }

    @Override
    public float getMaxHealth() {
        return 15.0f;
    }

    public float getGrowth(float tickDelta) {
        int age = this.getGrowth();
        float lerped = (float)class_3532.method_15340((int)class_3532.method_48781((float)tickDelta, (int)this.prevAge, (int)age), (int)0, (int)25) / 25.0f;
        return lerped * 2.0f * (1.0f + (float)Math.abs(this.method_5667().getLeastSignificantBits() % 20L) / 20.0f);
    }

    public int getGrowth() {
        return (Integer)this.field_6011.method_12789(GROWTH);
    }

    public void setGrowth(int growth) {
        this.field_6011.method_12778(GROWTH, (Object)Math.max(0, growth));
    }

    public void setDecaying(boolean decaying) {
        this.field_6011.method_12778(DECAYING, (Object)decaying);
    }

    public boolean isDecaying() {
        return (Boolean)this.field_6011.method_12789(DECAYING);
    }

    public void setCorrupt(boolean corrupted) {
        this.field_6011.method_12778(CORRUPT, (Object)corrupted);
    }

    public boolean isCorrupt() {
        return (Boolean)this.field_6011.method_12789(CORRUPT);
    }

    public boolean isShaking() {
        return this.ticksShaking > 0;
    }

    public class_2350 getAttachmentFace() {
        return Objects.requireNonNullElse((class_2350)this.field_6011.method_12789(ATTACHMENT_FACE), class_2350.field_11036);
    }

    public void setAttachmentFace(@Nullable class_2350 face) {
        this.field_6011.method_12778(ATTACHMENT_FACE, (Object)(face == null ? class_2350.field_11036 : face));
    }

    public void method_5773() {
        this.prevAge = this.getGrowth();
        if (!this.method_37908().field_9236) {
            int growAmount = 1 + Math.abs((int)this.method_5667().getLeastSignificantBits() % 5);
            this.setGrowth(this.prevAge + (this.isDecaying() ? -growAmount : growAmount));
        }
        this.method_20803(0);
        if (this.isDecaying() && this.getGrowth() == 0) {
            this.method_31472();
        }
        if (this.ticksShaking > 0) {
            --this.ticksShaking;
        }
        this.method_33574(this.method_24515().method_46558());
        super.method_5773();
        if ((this.ticksShaking > 0 || this.getGrowth() < 25) && this.field_6012 % this.field_5974.method_39332(2, 5) == 0) {
            this.method_5783(USounds.ENTITY_CRYSTAL_SHARDS_AMBIENT, 1.0f, 1.0f - class_3532.method_15363((float)this.getGrowth(1.0f), (float)0.0f, (float)1.0f) * 0.5f);
        }
        if (!Guest.of(this).hasHost() && (this.isDead() || CrystalShardsEntity.isInvalid(this.method_37908(), this.method_24515(), this.getAttachmentFace()))) {
            this.method_5768();
            ParticleUtils.spawnParticles((class_2394)class_2398.field_11204, this, 10);
        }
    }

    @Override
    protected void onHurt() {
        this.method_37908().method_8421((class_1297)this, (byte)1);
        this.ticksShaking = 10;
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (reason == class_1297.class_5529.field_26998) {
            this.method_5783(USounds.ENTITY_CRYSTAL_SHARDS_JOSTLE, 1.0f, 1.0f);
            this.method_5775(new class_1799((class_1935)UItems.CRYSTAL_SHARD, 6));
        }
        super.method_5650(reason);
    }

    public void method_5711(byte status) {
        switch (status) {
            case 1: {
                this.ticksShaking = 10;
                break;
            }
            default: {
                super.method_5711(status);
            }
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("yaw", this.method_36454());
        nbt.method_10569("growth", this.getGrowth());
        nbt.method_10582("face", this.getAttachmentFace().method_10151());
        nbt.method_10556("decaying", this.isDecaying());
        nbt.method_10556("corrupt", this.isCorrupt());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("yaw", 5)) {
            this.method_36456(nbt.method_10583("yaw"));
        }
        this.setGrowth(nbt.method_10550("growth"));
        this.setAttachmentFace(class_2350.method_10168((String)nbt.method_10558("face")));
        this.setDecaying(nbt.method_10577("decaying"));
        this.setCorrupt(nbt.method_10577("corrupt"));
        this.prevAge = this.getGrowth();
    }
}

