/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.entity.Creature;
import com.minelittlepony.unicopia.entity.Equine;
import com.minelittlepony.unicopia.entity.ai.FleeExplosionGoal;
import com.minelittlepony.unicopia.entity.behaviour.Guest;
import java.util.Collection;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1451;
import net.minecraft.class_1493;
import net.minecraft.class_1538;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_4582;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5712;
import net.minecraft.class_6019;
import net.minecraft.class_6053;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class FriendlyCreeperEntity
extends class_1321
implements class_4582,
class_5354 {
    private static final class_2940<Integer> FUSE_SPEED = class_2945.method_12791(FriendlyCreeperEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> CHARGED = class_2945.method_12791(FriendlyCreeperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IGNITED = class_2945.method_12791(FriendlyCreeperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ANGER_TIME = class_2945.method_12791(FriendlyCreeperEntity.class, (class_2941)class_2943.field_13327);
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private int lastFuseTime;
    private int currentFuseTime;
    private short fuseTime = (short)30;
    private byte explosionRadius = (byte)3;
    private int headsDropped;
    private short hugTime;
    private short lastHugTime;
    @Nullable
    private UUID angerTarget;

    protected FriendlyCreeperEntity(class_1299<? extends FriendlyCreeperEntity> type, class_1937 world) {
        super(type, world);
        this.method_6173(false, true);
        this.method_5941(class_7.field_33534, -1.0f);
        this.method_5941(class_7.field_36432, -1.0f);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FUSE_SPEED, (Object)-1);
        builder.method_56912(CHARGED, (Object)false);
        builder.method_56912(IGNITED, (Object)false);
        builder.method_56912(ANGER_TIME, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new EscapeGoal(this, 1.5));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new IgniteGoal());
        this.field_6201.method_6277(4, (class_1352)new class_1338((class_1314)this, class_3701.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(4, (class_1352)new class_1338((class_1314)this, class_1451.class, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[]{class_1493.class}));
        this.field_6185.method_6277(7, (class_1352)new class_1400((class_1308)this, class_1547.class, false));
        this.field_6185.method_6277(8, (class_1352)new class_5398((class_1308)this, true));
    }

    public static class_5132.class_5133 createCreeperAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.25);
    }

    protected class_2561 method_23315() {
        return class_1299.field_6046.method_5897();
    }

    public int method_5850() {
        return 3 + (this.method_5968() == null ? 0 : (int)(this.method_6032() - 1.0f));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        boolean bl = super.method_5747(fallDistance, damageMultiplier, damageSource);
        this.currentFuseTime += (int)(fallDistance * 1.5f);
        if (this.currentFuseTime > this.fuseTime - 5) {
            this.currentFuseTime = this.fuseTime - 5;
        }
        return bl;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (((Boolean)this.field_6011.method_12789(CHARGED)).booleanValue()) {
            nbt.method_10556("powered", true);
        }
        nbt.method_10575("Fuse", this.fuseTime);
        nbt.method_10575("Hugged", this.hugTime);
        nbt.method_10567("ExplosionRadius", this.explosionRadius);
        nbt.method_10556("ignited", this.isIgnited());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(CHARGED, (Object)nbt.method_10577("powered"));
        if (nbt.method_10573("Fuse", 99)) {
            this.fuseTime = nbt.method_10568("Fuse");
        }
        if (nbt.method_10573("Hugged", 99)) {
            this.hugTime = nbt.method_10568("Hugged");
        }
        if (nbt.method_10573("ExplosionRadius", 99)) {
            this.explosionRadius = nbt.method_10571("ExplosionRadius");
        }
        if (nbt.method_10577("ignited")) {
            this.ignite();
        }
    }

    public void method_5773() {
        this.method_24346(this.method_6172());
        if (this.method_5805()) {
            int fuseSpeed;
            this.lastFuseTime = this.currentFuseTime;
            if (this.isIgnited()) {
                this.setFuseSpeed(1);
            }
            if ((fuseSpeed = this.getFuseSpeed()) > 0 && this.currentFuseTime == 0) {
                this.method_5783(class_3417.field_15057, 1.0f, 0.5f);
                this.method_32876((class_6880)class_5712.field_28727);
            }
            this.currentFuseTime = Math.max(0, this.currentFuseTime + fuseSpeed);
            if (this.currentFuseTime >= this.fuseTime) {
                this.currentFuseTime = this.fuseTime;
                this.explode();
            }
            this.lastHugTime = this.hugTime;
            if (!this.method_6181() && ((Guest)((Object)this)).getHost() == null) {
                if (this.isConverting()) {
                    this.hugTime = (short)(this.hugTime + 1);
                    if (this.hugTime >= 100 && !this.method_37908().field_9236) {
                        this.method_6170(this.getCreature().getCarrierId().map(arg_0 -> ((class_1937)this.method_37908()).method_18470(arg_0)).orElse(null));
                        this.method_37908().method_8421((class_1297)this, (byte)7);
                    }
                    if (this.hugTime % 5 == 0) {
                        this.method_6013(this.method_48923().method_48830());
                    }
                } else {
                    this.hugTime = 0;
                    if (!this.method_37908().field_9236) {
                        this.method_37908().method_8649((class_1297)this.method_29243(class_1299.field_6046, true));
                        this.method_31472();
                    }
                }
            } else {
                if (this.field_5974.method_43048(30) == 0) {
                    this.spawnHeart();
                }
                this.hugTime = 0;
            }
        }
        super.method_5773();
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
    }

    private void spawnHeart() {
        this.method_37908().method_8406((class_2394)class_2398.field_11201, this.field_5974.method_43385(this.method_23317(), 0.5), this.method_23318() + (double)this.method_17682(), this.field_5974.method_43385(this.method_23321(), 0.5), 0.0, 0.0, 0.0);
    }

    private Creature getCreature() {
        return (Creature)Equine.of(this, c -> c instanceof Creature).get();
    }

    public boolean isConverting() {
        return !this.method_6181() && this.getCreature().isBeingCarried();
    }

    public void method_5980(@Nullable class_1309 target) {
        if (target instanceof class_6053) {
            return;
        }
        super.method_5980(target);
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15192;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14907;
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        class_1548 c;
        super.method_6099(world, source, causedByPlayer);
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1548 && (c = (class_1548)class_12972).method_7008()) {
            c.method_7002();
            this.method_5706((class_1935)class_1802.field_8681);
        }
    }

    public boolean method_6121(class_1297 target) {
        return true;
    }

    public boolean method_6872() {
        return (Boolean)this.field_6011.method_12789(CHARGED);
    }

    public float getClientFuseTime(float timeDelta) {
        return class_3532.method_16439((float)timeDelta, (float)this.lastFuseTime, (float)this.currentFuseTime) / (float)(this.fuseTime - 2) + class_3532.method_16439((float)timeDelta, (float)this.lastHugTime, (float)this.hugTime) / 98.0f;
    }

    public int getFuseSpeed() {
        return (Integer)this.field_6011.method_12789(FUSE_SPEED);
    }

    public void setFuseSpeed(int fuseSpeed) {
        this.field_6011.method_12778(FUSE_SPEED, (Object)fuseSpeed);
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        super.method_5800(world, lightning);
        this.field_6011.method_12778(CHARGED, (Object)true);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8054);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7960() && this.method_6171((class_1309)player)) {
            this.method_24346(!this.method_24345());
            this.method_6179(this.method_24345());
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (stack.method_31573(class_3489.field_41662)) {
            class_3414 soundEvent = stack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().field_9236) {
                this.ignite();
                if (!stack.method_7963()) {
                    stack.method_7934(1);
                } else {
                    stack.method_7970(1, (class_1309)player, FriendlyCreeperEntity.method_56079((class_1268)hand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (stack.method_31574(class_1802.field_8054) && this.method_6032() < this.method_6063()) {
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_16439, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            this.currentFuseTime = this.fuseTime - 1;
            if (!this.method_37908().field_9236) {
                this.method_6025(3.0f);
                this.method_37908().method_8421((class_1297)this, (byte)7);
                if (!stack.method_7963()) {
                    stack.method_7934(1);
                } else {
                    stack.method_7970(1, (class_1309)player, FriendlyCreeperEntity.method_56079((class_1268)hand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    private void explode() {
        if (!this.method_37908().field_9236) {
            this.field_6272 = true;
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), this.getExplosionRadius(), class_1937.class_7867.field_40890);
            this.method_31472();
            this.spawnEffectsCloud();
        }
    }

    public boolean method_5853(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float explosionPower) {
        return false;
    }

    private float getExplosionRadius() {
        return this.explosionRadius * (this.method_6872() ? 2 : 1);
    }

    private void spawnEffectsCloud() {
        Collection effects = this.method_6026();
        if (!effects.isEmpty()) {
            class_1295 cloud = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
            cloud.method_5603(2.5f);
            cloud.method_5609(-0.5f);
            cloud.method_5595(10);
            cloud.method_5604(cloud.method_5605() / 2);
            cloud.method_5596(-cloud.method_5599() / (float)cloud.method_5605());
            effects.forEach(effect -> cloud.method_5610(new class_1293(effect)));
            this.method_37908().method_8649((class_1297)cloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.field_6011.method_12789(IGNITED);
    }

    public void ignite() {
        this.field_6011.method_12778(IGNITED, (Object)true);
        FleeExplosionGoal.notifySurroundings((class_1297)this, this.getExplosionRadius());
    }

    public boolean shouldDropHead() {
        return this.method_6872() && this.headsDropped < 1;
    }

    public void onHeadDropped() {
        ++this.headsDropped;
    }

    public class_1296 method_5613(class_3218 world, class_1296 partner) {
        FriendlyCreeperEntity child = (FriendlyCreeperEntity)this.method_5864().method_5883((class_1937)world);
        UUID uUID = this.method_6139();
        if (uUID != null) {
            child.method_6174(uUID);
            child.method_6173(true, true);
        }
        return child;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int time) {
        this.field_6011.method_12778(ANGER_TIME, (Object)time);
    }

    @Nullable
    public UUID method_29508() {
        return this.angerTarget;
    }

    public void method_29513(UUID target) {
        this.angerTarget = target;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    class EscapeGoal
    extends class_1374 {
        public EscapeGoal(FriendlyCreeperEntity this$0, double speed) {
            super((class_1314)this$0, speed);
        }

        protected boolean method_40072() {
            return this.field_6549.method_40071() || this.field_6549.method_5809();
        }
    }

    class IgniteGoal
    extends class_1352 {
        @Nullable
        private class_1309 target;

        public IgniteGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 livingEntity = FriendlyCreeperEntity.this.method_5968();
            return FriendlyCreeperEntity.this.getFuseSpeed() > 0 || livingEntity != null && FriendlyCreeperEntity.this.method_5858((class_1297)livingEntity) < 9.0;
        }

        public void method_6269() {
            FriendlyCreeperEntity.this.method_5942().method_6340();
            this.target = FriendlyCreeperEntity.this.method_5968();
        }

        public void method_6270() {
            this.target = null;
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            if (this.target == null) {
                FriendlyCreeperEntity.this.setFuseSpeed(-1);
                return;
            }
            if (FriendlyCreeperEntity.this.method_5858((class_1297)this.target) > 49.0) {
                FriendlyCreeperEntity.this.setFuseSpeed(-1);
                return;
            }
            if (!FriendlyCreeperEntity.this.method_5985().method_6369((class_1297)this.target)) {
                FriendlyCreeperEntity.this.setFuseSpeed(-1);
                return;
            }
            FriendlyCreeperEntity.this.setFuseSpeed(1);
        }
    }
}

