/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.entity.mob;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.entity.EntityReference;
import com.minelittlepony.unicopia.entity.mob.TentacleEntity;
import com.minelittlepony.unicopia.entity.mob.UEntities;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class IgnominiousBulbEntity
extends class_1308 {
    private static final class_2940<Boolean> ANGRY = class_2945.method_12791(IgnominiousBulbEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> AGE = class_2945.method_12791(IgnominiousBulbEntity.class, (class_2941)class_2943.field_13327);
    private static final int BABY_AGE = -24000;
    private static final int HAPPY_TICKS = 40;
    private static final List<class_2338> TENTACLE_OFFSETS = List.of(new class_2338(-3, 0, -3), new class_2338(0, 0, -4), new class_2338(3, 0, -3), new class_2338(-4, 0, 0), new class_2338(4, 0, 0), new class_2338(-3, 0, 3), new class_2338(0, 0, 4), new class_2338(3, 0, 4));
    @Nullable
    private Map<class_2338, EntityReference<TentacleEntity>> tentacles;
    private int prevAge;
    private int happyTicks;
    private int angryTicks;

    public IgnominiousBulbEntity(class_1299<? extends IgnominiousBulbEntity> type, class_1937 world) {
        super(type, world);
    }

    public IgnominiousBulbEntity(class_1937 world) {
        super(UEntities.IGNOMINIOUS_BULB, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ANGRY, (Object)false);
        builder.method_56912(AGE, (Object)0);
    }

    public boolean method_6109() {
        return this.getAge() < 0;
    }

    public void method_7217(boolean baby) {
        this.setAge(-24000);
    }

    protected int getAge() {
        return (Integer)this.field_6011.method_12789(AGE);
    }

    protected void setAge(int age) {
        this.field_6011.method_12778(AGE, (Object)age);
    }

    public float getScale(float tickDelta) {
        return Math.max(0.2f, 1.0f - class_3532.method_15363((float)class_3532.method_48781((float)tickDelta, (int)this.prevAge, (int)this.getAge()), (float)-24000.0f, (float)0.0f) / -24000.0f);
    }

    public float method_55693() {
        return super.method_55693() * this.getScale(1.0f);
    }

    public boolean isAngry() {
        return (Boolean)this.field_6011.method_12789(ANGRY);
    }

    public void setAngry(boolean angry) {
        if (angry != this.isAngry()) {
            this.field_6011.method_12778(ANGRY, (Object)angry);
        }
    }

    public void setAngryFor(int angryTicks) {
        this.angryTicks = angryTicks;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.method_6109() && stack.method_31574(class_1802.field_8324)) {
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            this.growUp(10);
            if (!this.method_37908().field_9236) {
                this.method_37908().method_20290(1505, this.method_24515(), 0);
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    protected void method_18249(class_1657 player, class_1308 child) {
        class_243 center = this.method_19538();
        Supplier<class_243> offset = VecHelper.supplier(() -> (this.method_37908().field_9229.method_43056() ? 1 : -1) * 3);
        this.method_33574(center.method_1019(offset.get().method_18805(1.0, 0.0, 1.0)));
        child.method_33574(center.method_1019(offset.get().method_18805(1.0, 0.0, 1.0)));
    }

    public void method_5814(double x, double y, double z) {
        class_243 change = new class_243(x, y, z).method_1020(this.method_19538());
        super.method_5814(x, y, z);
        this.getTentacles().values().forEach(tentacle -> tentacle.ifPresent(this.method_37908(), t -> t.method_33574(t.method_19538().method_1019(change))));
    }

    public void growUp(int age) {
        int currentAge = this.getAge();
        if (currentAge < 0) {
            this.setAge(age * 20 + currentAge);
            this.happyTicks = 40;
        }
    }

    public void method_5773() {
        if (!this.method_37908().field_9236 && !this.method_31481()) {
            class_2338.class_2339 center = new class_2338.class_2339();
            Map<class_2338, EntityReference<TentacleEntity>> tentacles = this.getTentacles();
            if (!this.method_6109() && !this.field_5953) {
                TENTACLE_OFFSETS.forEach(offset -> tentacles.compute(this.adjustForTerrain(center, (class_2338)offset), this::updateTentacle));
            }
            for (EntityReference<TentacleEntity> tentacle2 : tentacles.values()) {
                if (this.method_37908().field_9229.method_43048(this.isAngry() ? 12 : 1200) != 0) continue;
                tentacle2.ifPresent(this.method_37908(), t -> t.addActiveTicks(120));
            }
            @Nullable class_1309 target = this.method_6065();
            if (target == null || !this.method_18395(target)) {
                target = null;
                this.method_6015(null);
            }
            if (this.angryTicks > 0) {
                --this.angryTicks;
            }
            this.setAngry(!this.method_6109() && (this.angryTicks > 0 || target != null));
            float healthPercentage = this.method_6032() / this.method_6063();
            if (this.isAngry() && target != null && this.method_37908().field_9229.method_43048(1 + (int)(healthPercentage * 30.0f)) == 0) {
                if (target instanceof class_1657) {
                    class_1657 player = (class_1657)target;
                    Pony.of(player).getMagicalReserves().getEnergy().add(6.0f);
                }
                class_1309 t2 = target;
                tentacles.values().stream().flatMap(tentacle -> tentacle.getOrEmpty(this.method_37908()).stream()).sorted(Comparator.comparing(a -> Float.valueOf(a.method_5739((class_1297)t2)))).limit(2L).forEach(tentacle -> tentacle.setTarget(t2));
            }
            if (target != null) {
                this.method_5951((class_1297)target, 10.0f, 10.0f);
            }
        }
        super.method_5773();
    }

    public void method_6007() {
        super.method_6007();
        this.prevAge = this.getAge();
        if (this.method_37908().field_9236) {
            if (this.happyTicks > 0 && --this.happyTicks % 4 == 0) {
                this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        } else if (this.prevAge < 0) {
            this.setAge(this.prevAge + 1);
        } else if (this.prevAge > 0) {
            this.setAge(this.prevAge - 1);
        }
    }

    private Map<class_2338, EntityReference<TentacleEntity>> getTentacles() {
        if (this.tentacles == null) {
            this.tentacles = this.method_37908().method_8390(TentacleEntity.class, this.method_5829().method_1009(5.0, 0.0, 5.0), class_1301.field_6154).stream().collect(Collectors.toMap(class_1297::method_24515, tentacle -> {
                tentacle.setBulb(this);
                return new EntityReference<TentacleEntity>((TentacleEntity)((Object)tentacle));
            }));
        }
        return this.tentacles;
    }

    private EntityReference<TentacleEntity> updateTentacle(class_2338 pos, @Nullable EntityReference<TentacleEntity> tentacle) {
        if (tentacle == null || tentacle.getOrEmpty(this.method_37908()).filter(class_1297::method_5805).isEmpty()) {
            TentacleEntity created = new TentacleEntity(this.method_37908(), pos);
            created.method_5641((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, this.method_37908().field_9229.method_43057() * 360.0f, 0.0f);
            created.setBulb(this);
            if (this.method_37908().method_8515(pos.method_10074(), (class_1297)this)) {
                this.method_37908().method_8649((class_1297)created);
            }
            return new EntityReference<TentacleEntity>(created);
        }
        return tentacle;
    }

    private class_2338 adjustForTerrain(class_2338.class_2339 mutable, class_2338 offset) {
        class_1937 w = this.method_37908();
        mutable.method_10101((class_2382)this.method_24515());
        mutable.method_30927((class_2382)offset);
        while (this.isSpace(w, mutable.method_10074()) && w.method_24794((class_2338)mutable)) {
            mutable.method_10098(class_2350.field_11033);
        }
        while (!this.isPosValid(w, (class_2338)mutable) && w.method_24794((class_2338)mutable)) {
            mutable.method_10098(class_2350.field_11036);
        }
        if (w.method_8320((class_2338)mutable).method_45474()) {
            w.method_22352((class_2338)mutable, true);
        }
        return mutable.method_10062();
    }

    private boolean isPosValid(class_1937 w, class_2338 pos) {
        return w.method_8515(pos.method_10074(), (class_1297)this) && this.isSpace(w, pos);
    }

    private boolean isSpace(class_1937 w, class_2338 pos) {
        class_2680 state = w.method_8320(pos);
        return state.method_26215() || state.method_45474();
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.getTentacles().values().forEach(tentacle -> tentacle.ifPresent(this.method_37908(), t -> t.method_5650(reason)));
    }

    public void method_5784(class_1313 movementType, class_243 movement) {
    }

    public void method_5762(double deltaX, double deltaY, double deltaZ) {
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        if (this.method_6109()) {
            return class_3417.field_14556;
        }
        return USounds.ENTITY_IGNIMEOUS_BULB_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return USounds.ENTITY_IGNIMEOUS_BULB_DEATH;
    }

    @Nullable
    protected class_3414 method_5994() {
        if (!this.method_6109() && this.method_37908().field_9229.method_43048(2) == 0) {
            return class_3417.field_40072;
        }
        return class_3417.field_33433;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("angry", this.isAngry());
        nbt.method_10569("age", this.getAge());
        class_2499 tentacles = new class_2499();
        this.getTentacles().forEach((pos, tentacle) -> {
            class_2487 compound = new class_2487();
            compound.method_10566("pos", class_2512.method_10692((class_2338)pos));
            compound.method_10566("target", (class_2520)tentacle.toNBT((class_7225.class_7874)this.method_56673()));
            tentacles.add((Object)compound);
        });
        nbt.method_10566("tentacles", (class_2520)tentacles);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setAngry(nbt.method_10577("angry"));
        this.setAge(nbt.method_10550("age"));
        if (!this.method_37908().field_9236 && nbt.method_10573("tentacles", 9)) {
            HashMap<class_2338, EntityReference<TentacleEntity>> tentacles = new HashMap<class_2338, EntityReference<TentacleEntity>>();
            nbt.method_10554("tentacles", 10).forEach(tag -> {
                class_2487 compound = (class_2487)tag;
                class_2512.method_10691((class_2487)compound, (String)"pos").ifPresent(pos -> tentacles.put((class_2338)pos, new EntityReference(compound.method_10562("target"), (class_7225.class_7874)this.method_56673())));
            });
            this.tentacles = tentacles;
        }
    }

    public void method_5674(class_2940<?> data) {
        if (AGE.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }
}

